/*
************************************************************************
*
*   wert.h -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.wert.h
*   SCCS identification       : 1.2
*
************************************************************************
*/
/**************************************************************************/
/*                           wert.h                                       */
/*                                                                        */
/* Class defining a general value                                         */
/*                                                                        */
/**************************************************************************/


#ifndef _WERT_H_
#define _WERT_H_

class Wert {
public:
   Wert() {x=0.0; v=0.0; }
   Wert(float f, float d=0.0);
   float x,v;				/* Mittelwert, Standardabweichung */
   float random();                      /* normal distributed random value*/
   float random(float);                 /* normal distributed random value*/
   float randomv();			/* positive random value, mean 0, */
                                        /* standard deviation v           */
};

class Mean : public Wert {
   int n;
   float sum;
   char set;
public:
   Mean();
   Mean(float v, float d=0.0);
   int valid() {return (n>0);}
   int getn() {return n; }
   int isfixed() {return (int)set;}
   void fix();
   void add(float);
   void sub(float);
};


#endif
