/*
************************************************************************
*
*   wert.C -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.wert.C
*   SCCS identification       : 1.2
*
************************************************************************
*/
/**************************************************************************/
/*                           wert.h                                       */
/*                                                                        */
/* Class defining a general value                                         */
/*                                                                        */
/**************************************************************************/

#include <math.h>
#include <stdlib.h>
#include "wert.h"
#include "log.h"
#include "global.h"

/* gaussian random number generator:                                        */
/* from: Numerical Recipes in C, W. H. Press et al., Cambridge 1988, p. 217 */
float gasdev()
{
   static int iset = 0;
   static float gset;
   float fac,r,v1,v2;

   if(iset==0) {
      do {
         v1=2.0 * (float)drand48() -1.0;
         v2=2.0 * (float)drand48() -1.0;
         r=v1*v1+v2*v2;
      }
      while(r >= 1.0 || r == 0.0);
      fac=sqrt(-2.0*log(r)/r);
      gset=v1*fac;
      iset=1;
      return v2*fac;
   } else {
      iset = 0;
      return gset;
   }
}

Wert::Wert(float f, float d)
{
   x=f; 
   v=d;
}


float Wert::random()
{
   return(x + v * gasdev());
}

float Wert::randomv()
{
   return(fabs(v * gasdev()));
}

float Wert::random(float factor)
{
   return(x + factor * v * gasdev());
}

Mean::Mean()
{
   n=0;
   x=0.0;
   sum=0.0;
   v=0.0;
   set=0;
}

Mean::Mean(float v, float d)
{
   n=1;
   x=v;
   sum=v;
   v=d;
   set=0;
}

void Mean::fix()
{
   if(n<=1) set=1;
}

void Mean::add(float v)
{
   n++;
   sum += v;
   if(!set || n==1) x = sum / n;
}

void Mean::sub(float v)
{
   n--;
   sum -= v;
   if(n==0) {sum = 0.0;set=0;}
}
