/*
************************************************************************
*
*   str.C -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.str.C
*   SCCS identification       : 1.2
*
************************************************************************
*/
/**************************************************************************/
/*                              str.h                                     */
/*                                                                        */
/* classes and functions to deal with strings                             */
/**************************************************************************/

#include <string.h>
#include "global.h"

int isDel(char c,char *dels)
{
   int res = 0;
   int i = 0;
   while(dels[i] != '\0' && !res) {
      if(dels[i]==c) res=1;
      i++;
   }
   return res;
}

void getToken(char *str, char *token, char *dels)
{
   int i;
   int first;
   int len;

   len = strlen(str);
   i=0;
   while(i<len && isDel(str[i],dels)) i++;
   first = i;
   while(i<len && !isDel(str[i],dels)) i++;
   strcpy(token,str+first);
   strcpy(str,token+i-first);
   token[i-first] = '\0';
}

void strip(char *str, char *dels)
{
   int start,end;
   int len;
   int i;

   len = strlen(str);
   for(start=0;start<len && isDel(str[start],dels);start++);
   for(end=len-1;end>=0 && isDel(str[end],dels);end--);
   if(end == -1) str[0] = '\0';
   else if(start != 0) {
      for(i=0;i<=end-start;i++) str[i]=str[i+start];
      str[i] = '\0';
   } else {
      str[end+1] = '\0';
   }
}
   

