/*
************************************************************************
*
*   ss.h -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.ss.h
*   SCCS identification       : 1.2
*
************************************************************************
*/
/**************************************************************************/
/*                            ss.h                                        */
/*                                                                        */
/* class to load and generate spin systems                                */
/**************************************************************************/

#ifndef _SS_H_
#define _SS_H_

#include "atom.h"			/* list of atoms                     */
#include "frag.h"			/* list of fragments                 */


/* Graph *********************************************************************/

class Graph {
public:
   LiAtom Atoms;			/* list of atoms                     */
   LiFrag Frags;			/* list of all valid fragments       */
};
   
/* Structure *****************************************************************/

class Structure : public Graph {
   int atomLoad();			/* load all the defined atoms        */
   int bondLoad();			/* load all the defined bonds        */
   int fragLoad();
public:
   int fragAdd(char *,int);		/* add a sequence of fragments to    */
					/* library                           */
					/* returns TRUE if success           */
   void loadCoord(char *, int);		/* load subfrag. or dest. frag. atom */
					/* coordinates from given file       */
   void listAt(char *);			/* list the atoms                    */
   int bond(int,int);			/* add bond between atoms with given */
					/* atom numbers                      */
};

/* Spin System ****************************************************************/

class Ss: public Structure {
public:
   void jMake();
   void statNOEMake(int f=1,int l=0);
   void distNOEMake(int,float,float,int);
};

#endif
