/*
************************************************************************
*
*   specTypes.h -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.specTypes.h
*   SCCS identification       : 1.3
*
************************************************************************
*/
/**************************************************************************/
/*                           specTypes.h                                  */
/*                                                                        */
/* Defines the types of spectra available                                 */
/**************************************************************************/

#ifndef _SPECTYPES_H_
#define _SPECTYPES_H_

#include "peak.h"
#include "specs.h"

/* peaks are allowed to deviate for MAX_DEV standard deviations from the */
/* frequency of the corresponding coherence                              */
#define MAX_DEV 4
/* the distribution is calculated in steps of 1/RES_SCORE standard       */
/* deviations								 */
#define RES_SCORE 4

class Envir;

/* Spectra known by the program *******************************************/

#define NREXP 28

#define COSY       1
#define HN_CO_CA   2
#define HNCA       3
#define HNCO       4
#define HCACO      5
#define HCA_CO_N   6
#define TOCSY      7
#define NOESY      8
#define D2OTOCSY   9
#define N15TOCSY   10
#define N15NOESY   11
#define HNHB       12
#define CCNOESY    13
#define C13NOESY   14
#define D2OCOSY    15
#define C13H1      16
#define N15H1      17
#define HCCH24     18
#define HCCH7      19
#define RELTOCSY   20
#define RELNOESY   21
#define D2ONOESY   22
#define CRELTOCSY  23
#define CBCANH     24
#define CBCACONH   25
#define CCH        26
#define HBHACONH   27
#define C13NOED2O  28

/* Names and dimensionality of the spectra *******************************/
struct specnameT {
    char *name;
    int  nr;
    int dim;
};

extern const struct specnameT specname[];

class SpecType {
public:
   int type;		/* Number to identify the type of spec   */
   char *name;		/* Name for user interactions            */
   int dim;		/* Dimensionality of spectrum            */
   float noise;		/* Noise level of the spectrum           */
   float accPick[DIMENSION];/* Accuracy of the peak picking (ppm)*/
   float accSpec[DIMENSION];/* Accuracy of peak position relative*/
			/* to other spectra                      */
   int permut[DIMENSION];/* Permutation for reading and writing  */
   float matchFac[DIMENSION];
			/* weighting factor for each dimension   */
   float importance;	/* importance of spectrum for assignment */
   int used;		/* Flag if the spectrum is used          */
   void permute(float *);
			/* permute coord according to permut     */
   void unpermute(float *);
			/* reverse permutation                   */
};

class LiSpecType {
public:
   LiSpecType() {}
   static int nrExp;
   static SpecType l[NREXP];	/* List of possible spectra types     */
   void init();
   int start(char *,int &);	/* iterate over spectra matching name */
   int next(char *,int &);	/* return FALSE if no match           */
   int use(int,Envir &);	/* use spectrum with given index      */
   int use(int,char *,Envir &);	/* use spectrum with given name, index*/
   void name(char *,int);	/* returns spec name for given index  */
};

class Spectrum {
public:
   Spectrum() : maxPeakNr(0) {}

   char fn[MAXFILENAME];	/* file name of the spectrum          */
   Spec_Param_Data *specdata;   /* data associated with spectrum      */
   LiPeakDim liPeakDim[DIMENSION];
				/* peaks sorted by their position     */
   NdLiPeak peaks;		/* list of measured peaks             */
   int maxPeakNr;
   SpecType *type;		/* type of the spectrum               */
   int nr;			/* internal index for the spectrum    */
   float bonusPeak;		/* bonus for assigned peak            */
   float bonusAss[DIMENSION][MAX_DEV * RES_SCORE];
				/* bonus for peak matching correct    */
				/* coherence                          */
   float penDegen[DIMENSION][MAX_DEV * RES_SCORE];
				/* penalty for peak matching wrong    */
				/* coherence                          */
   float bonusDegen[DIMENSION];		
				/* bonus for peak not matching wrong  */
				/* coherence                          */
   float bonusDevMean[DIMENSION];
				/* bonus for deviation between shift  */
				/* in spectrum and mean shift         */
   void name(char *);		/* returns spec identification        */
};

class UsedSpec {	/* list of spectra currently used             */
   int cur;		/* counter for iteration through spectra      */
public:
   UsedSpec() {nrExp = NREXP; used=0;}
   void add(SpecType *, char *);
   Spectrum li[NREXP];		/* list of used spectra               */
   int nrExp;		/* max number of spectra that may be used     */
   int used;		/* actual number of used spectra              */
   Spectrum *start();	/* iterator through all spectra               */
   Spectrum *next();
   Spectrum *start(char *,int &); /* Iterator through all spectra     */
   Spectrum *next(char *,int &);  /* matching given name              */
};

extern UsedSpec usedSpec;

#endif
