/*
************************************************************************
*
*   specTypes.C -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.specTypes.C
*   SCCS identification       : 1.3
*
************************************************************************
*/
/**************************************************************************/
/*                           cmdline.h                                    */
/*                                                                        */
/* Defines the types of spectra available                                 */
/**************************************************************************/

#include <string.h>
#include <stdio.h>
#include <math.h>

#include "global.h"
#include "specTypes.h"			/* list of possible spectra       */
#include "log.h"			/* general log file               */
#include "envir.h"

/* static members */
    int LiSpecType::nrExp;
    SpecType LiSpecType::l[NREXP];	/* List of possible spectra types     */

UsedSpec usedSpec;

const struct specnameT specname[]= {
   {"COSY",      COSY,      2},
   {"NOESY",     NOESY,     2},
   {"HN_CO_CA",  HN_CO_CA,  3},
   {"CRELTOCSY", CRELTOCSY, 2},
   {"HNCA",      HNCA,      3},
   {"CBCANH",    CBCANH,    3},
   {"CBCACONH",  CBCACONH,  3},
   {"HBHACONH",  HBHACONH,  3},
   {"HNCO",      HNCO,      3},
   {"HCACO",     HCACO,     3},
   {"HCA_CO_N",  HCA_CO_N,  3},
   {"TOCSY",     TOCSY,     2},
   {"D2OTOCSY",  D2OTOCSY,  2},
   {"D2ONOESY",  D2ONOESY,  2},
   {"N15TOCSY",  N15TOCSY,  3},
   {"N15NOESY",  N15NOESY,  3},
   {"HNHB"    ,  HNHB,      3},
   {"CCNOESY" ,  CCNOESY,   4},
   {"C13NOESY",  C13NOESY,  3},
   {"C13NOED2O", C13NOED2O, 3},
   {"HCCH24"  ,  HCCH24,    3},
   {"HCCH7"   ,  HCCH7,     3},
   {"CCH"     ,  CCH,       3},
   {"D2OCOSY",   D2OCOSY,   2},
   {"C13H1",     C13H1,     2},
   {"N15H1",     N15H1,     2},
   {"RELTOCSY",  RELTOCSY,  2},
   {"RELNOESY",  RELNOESY,  2},
};

void LiSpecType::init()
{
   int i,j;

   nrExp = NREXP;
   for(i=0;i<nrExp;i++) {
      l[i].type  = specname[i].nr;
      l[i].name  = specname[i].name;
      l[i].dim   = specname[i].dim;
      l[i].noise = 0.0;
      l[i].importance = 1.0;
      l[i].used = 0;
      for(j=0;j<DIMENSION;j++) {
         l[i].accPick[j] = 0.01;
         l[i].permut[j] = j;
         l[i].matchFac[j]=1.0;
      }
   }
}

int LiSpecType::start(char *name, int &cur)
{
   cur = -1;
   return next(name,cur);
}

int LiSpecType::next(char *name, int &cur)
{
   int i;
   int len;
   int found = 0;

   len = strlen(name);
   for(i=cur+1;i<nrExp && ! found;i++) {
      if(strncmp(name,l[i].name,len) == 0) {
         cur = i;
         found = 1;
      }
   }
   return found;
}

void LiSpecType::name(char *name,int index)
{
   strcpy(name,l[index].name);
}

int LiSpecType::use(int found,Envir &)
{
   l[found].used = usedSpec.used + 1;
   usedSpec.add(&l[found],"");
   return(1);
}

int LiSpecType::use(int found,char *name,Envir &)
{
   l[found].used = usedSpec.used + 1;
   usedSpec.add(&l[found],name);
   return(1);
}

void UsedSpec::add(SpecType *spec,char *name)
{
   Log log;
   char str[MAXLINE];
   int i;

   if(used==nrExp) {
      log.w("\n... error: too many specra");
   } else {
      li[used].type=spec;
      li[used].nr=used;
      for(i=0;i<spec->dim;i++) li[used].liPeakDim[i].setDim(i);
      strcpy(li[used].fn,name);
      if(li[used].fn[0] != '\0') {
         li[used].specdata = Open_Spec_RO(li[used].fn);
         if(li[used].specdata == 0) {
            sprintf(str,
               "\n... WARNING: could not open spectrum '%s'",li[used].fn);
            log.warn(-1,str);
         }
      } else {
          li[used].specdata = 0;
      }
      used++;
   }
}

Spectrum *UsedSpec::start()
{
   cur=0;
   return next();
}

Spectrum *UsedSpec::next()
{
   Spectrum *res;

   if(used>cur) {
      res=&li[cur];
      cur++;
   } else {
      res=0;
   }
   return res;
}

Spectrum *UsedSpec::start(char *n, int &i)
{
   i=0;
   return next(n,i);
}

Spectrum *UsedSpec::next(char *n, int &i)
{
   int len;
   Spectrum *res = 0;

   len =strlen(n);
   while(i<used && !res) {
      if(strncmp(li[i].type->name,n,len)==0) res=&li[i];
      i++;
   } 
   return res;
}

void Spectrum::name(char *n)
{
   sprintf(n,"%s %d",type->name,nr);
}

void SpecType::unpermute(float *c)
{
   float t[DIMENSION];
   int i;

   for(i=0;i<dim;i++) t[i]=c[permut[i]];
   for(i=0;i<dim;i++) c[i]=t[i];
}

void SpecType::permute(float *c)
{
   float t[DIMENSION];
   int i;

   for(i=0;i<dim;i++) t[permut[i]]=c[i];
   for(i=0;i<dim;i++) c[i]=t[i];
}
