/*
************************************************************************
*
*   score.h -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.score.h
*   SCCS identification       : 1.4
*
************************************************************************
*/
/**************************************************************************/
/*                           score.h                                      */
/*                                                                        */
/* Defines scoring criteria and scores                                    */
/**************************************************************************/

#ifndef _SCORE_H_
#define _SCORE_H_

#include "element.h"
#include "global.h"

class Score;			/* actual scoring of an assignment         */
class Crit;			/* criteria to judge the quality of assign.*/
class LiScore;			/* corresponding lists                     */
class LiCrit;

class ErPeak;
class LiCo;
class LiFrag;
class Frag;
class OrdLiCo;
class Coherence;

class Crit : public Element {	/* different criteria to judge the quality */
				/* of assignments                          */
   char fullname[MAXLINE];	/* name with refernce number               */
   char name[MAXLINE];		/* identification name for the user        */
public:
   Crit(char *); 		/* initialize with name                    */
   int nr;			/* internal reference number               */
   float thresh1;		/* threshold for bad assignments           */
   float thresh2;		/* threshold for critical assignments      */
   int writeCom;		/* flag whether to write the comment out   */
   int lenNam();		/* length of the name of the criteria      */
   char nam(int,int);		/* nth character of the name right adjusted*/
				/* to given length                         */
   void setThresh(float,float);	/* set threshold to given values           */
   void setComment(int);	/* set comment to on or off                */
   virtual char decision(Score *);
				/* character reporting the quality         */
   virtual char *comment(Score *);
				/* comment describing the assignment       */
   virtual int uErPeak() {return 0;}
				/* whether to update with expected peaks   */
   virtual int uOrdLiCo() {return 0;}
				/* whether to update with coherence list   */
				/* ordered by chemical shift               */
   virtual void upErPeak(Score *, ErPeak *, Frag *, Coherence *) {}
				/* update score for frag with expected peak*/
   virtual void upOrdLiCo(OrdLiCo &, Iterator) {}
				/* update with list of ordered coherences  */
				/* Iterator used to identify the score     */
				/* corresponding to the criterium          */
   virtual int match(char *); 	/* does element match the template ?       */
   virtual void iname(char *);	/* return identification name of elem.     */
   virtual void initSums() {}	/* sum up scores and print out result      */
   virtual void addSum(Score *) {}
   virtual char *printSum() {return 0; }
};

class Score : public Element {	/* actual scoring of an assignment         */
public:
   Score(Crit *);
   int nr;
   virtual float value();	/* value of the score                      */
   virtual void reset() {}	/* reset the scoring                       */
};

class LiScore : public Index {
public:
   LiScore() : Index(4) {}
   void reset();		/* reset all the scores within the list   */
   virtual int compare(const Element *,const Element *);
				/* use internal number for comparison     */
};

class LiCrit : public Index {
public:
   LiCrit() : Index(4) {}
   int lenNam();		/* longest length of any criteria name    */
   void upErPeak(LiScore &,ErPeak *,Frag *, Coherence *);
				/* update all scores with expected peak   */
   void upCos(LiCo &);
				/* update coherence scores with list of   */
				/* coherences                             */
   virtual int compare(const Element *,const Element *);
				/* use internal number for comparison     */
   void addFragII(LiFrag &,char *,int,int);
				/* add intrainter criteria for fragments  */
   void addFragTempl(LiFrag &,char *,char *);
				/* add template criteria for fragments    */
   void addCoTempl(LiCo &,char *,char *);
				/* add template criteria for coherences   */
   void addCoDegen(LiCo &,char *,float);
				/* add degeneration criteria for co's     */
   void addCoDegIntra(LiCo &,char *,float);
				/* add degeneration criteria for co's     */
   void addCoDegInter(LiCo &,char *,float);
				/* add degeneration criteria for co's     */
   void addFragMap(LiFrag &,char *);
				/* add mapping criteria for fragments     */
   void addFragCorrect(LiFrag &,char *,char *);
				/* add criteria for fragments to count the*/
				/* number of corrrect assigned co's       */
				/* matching specified the specified templ.*/
   void addFragCorRes(LiFrag &,char *,char *);
				/* add criteria for fragments to count the*/
				/* number of co's assigned to the correct */
				/* residue and                            */
				/* matching specified the specified templ.*/
   void addFragCorrSS(LiFrag &,char *);
				/* add criteria for fragments to count the*/
				/* number of corrrect assigned co's       */
   void addCoMap(LiCo &cos, char *n);
				/* add mapping criteria for coherences    */
   void addFragOverlap(LiFrag &,char *);
				/* add mapping criteria for fragments     */
   void addCoOverlap(LiCo &cos, char *n);
				/* add mapping criteria for coherences    */
};

#endif
