/*
************************************************************************
*
*   rel.h -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.rel.h
*   SCCS identification       : 1.2
*
************************************************************************
*/
/**************************************************************************/
/*                              rel.h                                     */
/*                                                                        */
/* classes of relations between atoms and lists of such relations         */
/**************************************************************************/

#ifndef _REL_H_
#define _REL_H_

#include "global.h"
#include "element.h"
#include "wert.h"

class Atom;

class Relation : public Element {	/* general base class of relations   */
					/* between a number of atoms         */
protected:
   Atom *args[2];			/* list of atoms                     */
public:
   friend LiRel;
   Relation();
   ~Relation();
   Atom *first() {return(args[0]); }	/* get first argument of the relation*/
   Atom *second() {return(args[1]); }	/* get second arg of the relation    */
};

class Bond : public Relation {		/* covalent bond                     */
public:
   Bond() {t = BOND;}
   Bond(Atom *, Atom *);
   virtual void print(int);
};

class Coupling : public Relation {	/* scalar coupling                   */
public:
   Wert J;				/* coupling constant in Herz         */
   Coupling() {t=COUPLING; }
   Coupling(Atom *,Atom *);
   virtual void print(int);
};

class Noe : public Relation {		/* dipolar coupling                  */
public:
   Wert rate;				/* cross relaxation rate             */
   float prob;				/* probability that it exists        */
   float minDist;			/* minimal distance in Angstroem     */
   Noe() {t=NOE;}
   Noe(Atom *,Atom *);
   virtual void print(int);
};

class LiRel : public Index {		/* list of relations                 */
public:
   LiRel(): Index(16) {}
   virtual int compare(const Element *,const Element *);
					/* ordering relation                 */
					/* hierachy: 1. atom - 2. atom -     */
					/*          type of the relation    */
   Relation *find(int,int,Type);	/* find relation of specified type   */
					/* between atoms with given atom nr. */
   void print(int);			/* print list of relations           */
};

#endif
