/*
************************************************************************
*
*   rel.C -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.rel.C
*   SCCS identification       : 1.2
*
************************************************************************
*/
/**************************************************************************/
/*                              rel.cc                                    */
/*                                                                        */
/* classes of relations between atoms and lists of such relations         */
/**************************************************************************/

#include <stdio.h>
#include "log.h"
#include "atom.h"

#include "rel.h"

Relation::Relation()
{
   t = RELATION;
}

Relation::~Relation()
{
}

Bond::Bond(Atom *a1, Atom *a2)
{
   t = BOND;
   args[0] = a1; 
   args[1] = a2;
}

void Bond::print(int off)
{
   Log log;
   char str[MAXLINE];

   sprintf(str,"%*sBond between:\n",off,"");
   log.w(str);
   args[0]->print(off+5);
   args[1]->print(off+5);
}

Coupling::Coupling(Atom *a1, Atom *a2)
{
   t = COUPLING;
   args[0] = a1; 
   args[1] = a2;
}

void Coupling::print(int off)
{
   Log log;
   char str[MAXLINE];

   sprintf(str,"%*sCoupling %5.2fHz between:\n",off,"",J.x);
   log.w(str);
   args[0]->print(off+5);
   args[1]->print(off+5);
}

Noe::Noe(Atom *a1, Atom *a2)
{
   t = NOE;
   args[0] = a1; 
   args[1] = a2;
   minDist = -1.0;
}

void Noe::print(int off)
{
   Log log;
   char str[MAXLINE];

   sprintf(str,"%*sNOE, exch. rate %5.2g, probability %7.5g between:\n",
           off,"",rate.x,prob);
   log.w(str);
   args[0]->print(off+5);
   args[1]->print(off+5);
}

int LiRel::compare(const Element *r1,const Element *r2)
{
   int res;
   res = ((Relation *)r2)->args[0]->nr - ((Relation *)r1)->args[0]->nr;
   if(!res) res = ((Relation *)r2)->args[1]->nr - ((Relation *)r1)->args[1]->nr;
   if(!res) res = r2->t - r1->t;
   return(res);
}

Relation *LiRel::find(int nr1, int nr2, Type t)
{
   int i,j,k,res;

   res = -1;
   if(n>0) {
      i=0; j=n-1;
      while(i<=j && res != 0) {
         k=(i+j)/2;
         res = ((Relation *)l[k])->args[0]->nr - nr1;
         if(!res) res = ((Relation *)l[k])->args[1]->nr - nr2;
         if(!res) res = ((Relation *)l[k])->t - t; 

         if(res<0) i=k+1;
         else j=k-1;
      }
   }

   if(res==0) return (Relation *)l[k];
   else return 0;
}

void LiRel::print(int off)
{
   Log log;
   char str[MAXLINE];

   sprintf(str,"%*sList of Relations:\n",off,"");
   log.w(str);
   Index::print(off+3);
}

