/*
************************************************************************
*
*   prep.h -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.atom.h
*   SCCS identification       : 1.2
*
************************************************************************
*/
/**************************************************************************/
/*                             prep.h                                     */
/*                                                                        */
/* class to define prprocessing of peak lists                             */
/**************************************************************************/

#ifndef _PREP_H_
#define _PREP_H_

#include "global.h"			/* global constants                  */
#include "element.h"			/* base classes Element and Index    */

class Compon;				/* component of equivalent dims      */
class LiCompon;
class EquivDim;				/* calss of equivalent dimensions    */
class LiEquivDim;

/* imported classes */
class SpecType;
class Spectrum;

class Compon : public Element { 
public:
   SpecType *type;
   int dims[DIMENSION];
   Compon(SpecType *s,int *d);
};

class LiCompon : public Index {
public:
   LiCompon(): Index(30) {}
};

class EquivDim : public Element {
   char name[MAXLINE];			/* Name of equivalence class        */
//   Compon *ref;				/* reference component              */
   LiCompon compo;			/* components                       */
public:
   friend LiEquivDim;
   EquivDim(char *n, Compon *r);
   void addDim(int is, int d1=0, int d2=-1, int d3=-1);
   void filter(Spectrum *, Spectrum *, char *, char *);
   void getname(char *n) {strcpy(n,name);}
};

class LiEquivDim : public Index {
public:
   LiEquivDim(): Index(5) {}
   void addEq(char *n, int is, int d1=0, int d2=-1, int d3=-1);
				  /* add new equivalence class        */
   virtual int compare(const Element *c1,const Element *c2);
   EquivDim *start(char *,int &); /* Iterator through all spectra     */
   EquivDim *next(char *,int &);  /* matching given name              */
};


#endif
