/*
************************************************************************
*
*   pos.C -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.pos.C
*   SCCS identification       : 1.2
*
************************************************************************
*/
/**************************************************************************/
/*                                pos.cc                                  */
/*                                                                        */
/* list of complete assignment possibilities                              */
/**************************************************************************/

#include <string.h>
#include <math.h>
#include <stdlib.h>
#include "pos.h"
#include "opt.h"
#include "erPeak.h"
#include "nmrdia.h"
#include "peak.h"
#include "bib.h"
#include "log.h"
#include "functions.h"

/* Criterion to use to sort ass. poss. */
#define USE_VALUE 1
#define USE_SCORE 2
class OptPosSelection : public Index {
public:
   int sort_crit;
   OptPosSelection(): Index(64) {sort_crit = USE_SCORE;}
   virtual int compare(const Element *,const Element *);
				/* use first score then nr for comparing*/
   OptPos *select(float);
				/* slect optimizer                           */
                                /* INPUT: ration of number of times best opt.*/
				/* should be selected compared to the number */
				/* of times the worst optimizer should be    */
				/* selected                                  */
};

OptPosSelection ch;

int OptPosSelection::compare(const Element *o1,const Element *o2)
{
   int res;
   float s1,s2;

   if(sort_crit==USE_SCORE) {
      s1=((OptPos *)o1)->score;
      s2=((OptPos *)o2)->score;
   } else {
      s1=((OptPos *)o1)->value;
      s2=((OptPos *)o2)->value;
   }

   if(s2<s1) res = -1;
   else if (s2>s1) res = 1;
   else res = ((OptPos *)o1)->nr-((OptPos *)o2)->nr;

   return res;
}

OptPos *OptPosSelection::select(float ratio)
{
   float randomnr;
   int index;

   if(getn() == 0) return 0;

   sort();

   randomnr = drand48();
   if(randomnr > 0.0)
      index = (int)floor(exp(log(randomnr) * ratio) * getn());
   else 
      index = 0;

   return (OptPos *)l[index];
}

LiOptPos::LiOptPos(): Index(64)
{
   peaks = 0;
   nrEntries = 0;
}

void LiOptPos::init(int anzahl,LiErPeak &list,LiCo &liCo,LiPeak &)
{
   ErPeak *erPeak;
   Coherence *co;
   int i;
   OptPos *poss;

   if(nrEntries > 0) delete peaks;
   remove();

   nrEntries = 0;
   peaks = new ErPeak*[list.getn()];
   erPeak = (ErPeak *)list.start();
   while(erPeak != 0) {
      if(erPeak->type == DESTFRAG) {
         erPeak->assPop = new Peak *[anzahl];
         erPeak->infPop = new float[anzahl];
         for(i=0;i<anzahl;i++) erPeak->assPop[i]=0;
         peaks[nrEntries] = erPeak;
         nrEntries++;
      }
      erPeak = (ErPeak *)list.next();
   }

   co = (Coherence *)liCo.start();
   while(co != 0) {
      if(co->firstAt()->frag->type == DESTFRAG) {
         if(co->assPop) delete co->assPop;
         co->assPop = new CoAss[anzahl];
      }
      co = (Coherence *)liCo.next();
   }

   for(i=0;i<anzahl;i++) {
      poss = new OptPos(i);
      add(poss);
   }
   sort(-1);
}

int LiOptPos::compare(const Element *o1,const Element *o2)
{
   return ((OptPos *)o1)->nr-((OptPos *)o2)->nr;
}

int LiOptPos::select(float temprature, int anz, int first, int last, int *selected)
{
   OptPos *poss;
   int i,cnt;

   first--; last--;
   if(anz>MAXASSIGN) anz=MAXASSIGN;

   ch.remove();
   poss = (OptPos *)start();
   while(poss != 0) {
      if(poss->nr>=first && poss->nr<=last) ch.add(poss);
      poss = (OptPos *)next();
   }

   ch.sort_crit = USE_VALUE; ch.sort();
   cnt=0;
   for(i=0;i<anz;i++) {
      // if(i==anz/2) {ch.sort_crit = USE_VALUE; ch.sort();}
      poss = ch.select(temprature);
      if(poss != 0) {
         selected[cnt]=poss->nr;
         cnt++;
      }
   }

   return cnt;
}

void LiOptPos::scorePop(int first, int last, NMRdia &dia)
{
   OptPos *poss;
   Coherence *co;
   ErPeak *erPeak;

   first--; last--;

   co = (Coherence *)dia.liCo.start();
   while(co != 0) {
      if(co->firstAt()->frag->type == DESTFRAG) co->imp.calcsignif();
      co = (Coherence *)dia.liCo.next();
   }

   erPeak = (ErPeak *)dia.liErPeak.start();
   while(erPeak != 0) {
      if(erPeak->type == DESTFRAG) erPeak->imp.calcsignif();
      erPeak = (ErPeak *)dia.liErPeak.next();
   }

   poss = (OptPos *)start();
   while(poss != 0) {
      if(poss->nr>=first && poss->nr<=last) {
         dia.sumScore(poss->nr,poss->score,poss->value);
      }
      poss = (OptPos *)next();
   }
}

void LiOptPos::update(float temprature, int first, int last, NMRdia &dia)
{
   Log log;
   OptPos *poss;
   Coherence *co;
   int i;

   first--; last--;

   ch.remove();
   poss = (OptPos *)start();
   while(poss != 0) {
      if(poss->nr>=first && poss->nr<=last) ch.add(poss);
      poss = (OptPos *)next();
   }

   poss = ch.select(temprature);
   if(poss != 0) {
      poss->score = dia.score;
      poss->value = dia.value;
      for(i=0;i<nrEntries;i++) {
         peaks[i]->imp.update(peaks[i]->mutInf);
         peaks[i]->setAss(peaks[i]->getAss(),peaks[i]->mutInf,poss->nr);
      }
      co = (Coherence *)dia.liCo.start();
      while(co != 0) {
         if(co->firstAt()->frag->type == DESTFRAG) {
            co->setAss(poss->nr);
            co->imp.update(co->mutInf);
         }
         co = (Coherence *)dia.liCo.next();
      }
   } else {
      log.warn(10,"\n... WARNING: unknown assignment possibility");
   }

   dia.avgScore=0.0;
   poss=(OptPos *)start();
   while(poss!=0) {
      dia.avgScore += poss->score;
      poss=(OptPos *)next();
   }
   dia.avgScore /= getn();
}

OptPos::OptPos(int number)
{
   nr = number;
   score = 0.0;
   value = 0.0;
   sumScore = 0.0;
}
