/*
************************************************************************
*
*   parser.h -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.parser.h
*   SCCS identification       : 1.2
*
************************************************************************
*/
/**************************************************************************/
/*                             parser.h                                   */
/*                                                                        */
/* match template with instance of a name                                 */
/**************************************************************************/

#ifndef _PARSER_H_
#define _PARSER_H_

#include "global.h"

/* compare routines:							*/
/*    compare a template and a residue number with an instance of a name*/
/*    PARAMETER: template, start position, end position                 */
/*		 instance, start position, end position                 */
/*		 reference residue number				*/
/*    EFFECT: return true and new end position if parsing was succesfull*/
/* parser routines:							*/
/*    check if a string matches a syntactical element                   */
/*    PARAMETER: string, start position, end position                   */
/*    EFFECT: return true and new end position if parsing was succesfull*/
/* syntax:								*/
/*   Peak = Name : { Coherence ' ' } | { Coherence ' ' }		*/
/*   Spectrum = Name | '*'						*/
/*   Coherence = Atom							*/
/*   Atom = AtName | AtName '(' Residue ')'				*/
/*   AtName = Name | '*'						*/
/*   Residue = ResName | ResNum | ResName ' ' ResNum			*/
/*   ResName = Name | '*'						*/
/*   ResNum = Number | '*' | [+,-] Number				*/
/*   Name = no delemiter						*/
/*   Number = scanf(%d)							*/
/* fastpeak routine recognizes only a reduced syntax:                   */
/*   Peak = { Name(Name Number) ' ' }                                   */
/* remarks:								*/
/*   HN HA(-1) will match to all HN HA peaks				*/
/*   HN(*) HA(-1) will match only to sequential HN HA peaks             */

#define UNDEFINED_RES_NR -9999

class Parser {
   char dels[MAXLINE];  /* delemiters to use for parsing                */
   int nrDel;		/* number of valid delemiters                   */
   int isDel(char);	/* is the character a delemiter ?               */
public:
   Parser() {}
   void setDels(char *);/* set delemiters                               */

   /* parsing routines */
   int p_name(char *, int, int &, char *);
   int p_number(char *, int, int &, int &);
   int p_del(char *, int, int &,char *);
   int p_skip(char *, int, int &, char *);

   /* compare routines */
   int fastpeak(char *, int, int &, char *, int, int &);
   int peak(char *, int, int &, char *, int, int &, int &);
   int coherence(char *, int, int &, char *, int, int &, int &);
   int atom(char *, int, int &, char *, int, int &, int &);
   int name(char *, int, int &, char *, int, int &);
   int residue(char *, int, int &, char *, int, int &, int &);
   int resnum(char *, int, int &, char *, int, int &, int &);
};


#endif
