/*
************************************************************************
*
*   parser.C -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.parser.C
*   SCCS identification       : 1.2
*
************************************************************************
*/
/**************************************************************************/
/*                             parser.cc                                  */
/*                                                                        */
/* iterate over all atoms, coherences and expected peak matching a given  */
/* name                                                                   */
/**************************************************************************/

#include <string.h>
#include <stdio.h>
#include "parser.h"
#include "bib.h"

int Parser::isDel(char c)
{
   int i;
   for(i=0;i<nrDel;i++) if(dels[i] == c) return 1;
   return 0;
}

void Parser::setDels(char *d)
{
   strncpy(dels,d,MAXLINE-1);
   nrDel = strlen(dels);
}

int Parser::p_name(char *str, int v, int &b, char *n)
{
   int i;
   b=v;
   while(str[b] != '\0' && isDel(str[b]) ) b++;
   i=0;
   while(str[b] != '\0' && !isDel(str[b]) ) {
      n[i] = str[b]; 
      b++; i++;
   }
   n[i] = '\0';
   if(b!=v) return 1;
   else return 0;
}

int Parser::p_number(char *str, int v, int &b, int &num)
{
   char temp[MAXLINE];

   p_name(str,v,b,temp);
   if(sscanf(temp,"%d",&num) == 1) return 1;
   else return 0;
}

int Parser::p_del(char *str, int v, int &b, char *d)
{
   int res=1;
   int i;

   b=v;
   while(str[b] != '\0' && res) {
      res=0; i=0;
      while(d[i] != '\0' && !res) {
         if(d[i]==str[b]) res = 1;
         i++;
      }
      if(res) b++;
   }
   return 1;
}

int Parser::p_skip(char *str, int v, int &b, char *d)
{
   int res=1;
   int i;

   b=v;
   while(str[b] != '\0' && res) {
      i=0;
      while(d[i] != '\0' && res) {
         if(d[i]==str[b]) res = 0;
         i++;
      }
      if(res) b++;
   }
   return !res;
}

int Parser::peak(char *t, int tv, int &tb,
             char *i,  int iv, int &ib, int &nrRes)
{
   int i1,i2;
   int t1,t2;
   int count=0;
   int res=1;

   setDels(" ():");

   res &= name(t,tv,t1,i,iv,i1);

   setDels(" ()");

   res &= name(t,t1,t2,i,i1,i2);

   if(res) {t1=t2; i1=i2; }
   else {t1=tv; i1=i2; }
   while(coherence(t,t1,t2,i,i1,i2,nrRes)) {
      count++;
      t1=t2; i1=i2;
   }
   tb=t1; ib=i1;
   return 1;
}

int Parser::coherence(char *t, int tv, int &tb,
             char *i,  int iv, int &ib, int &nrRes)
{
   return atom(t,tv,tb,i,iv,ib,nrRes);
}

int Parser::atom(char *t, int tv, int &tb,
             char *i,  int iv, int &ib, int &nrRes)
{
   int i1,i2,i3;
   int t1,t2,t3;
   int res =1;
   char tn[MAXLINE];
   char in[MAXLINE];
   BibAccess bib;

   setDels(" ()");
   res &= p_name(t,tv,t1,tn);
   res &= p_name(i,iv,i1,in);
   if(res) {
      if(strcmp(tn,in) != 0 && tn[0] != '*' && !bib.equivAtNam(tn,in))
         res = 0;
   }
   p_del(t,t1,t2," "); p_del(i,i1,i2," (");
   if(res && t[t2] == '(') {
      t2++;
      res &= residue(t,t2,t3,i,i2,i3,nrRes);
      res &= p_del(t,t3,tb," ");
      res &= (t[tb] == ')');
      tb++;
      res &= p_del(i,i3,ib," )");
   } else {
      res &= p_skip(i,i2,ib,")");
      tb = t2;
      ib++;
   }
   return res;
}

int Parser::name(char *t, int tv, int &tb,
             char *i,  int iv, int &ib)
{
   char tn[MAXLINE];
   char in[MAXLINE];
   int res = 1;

   res &= p_name(t,tv,tb,tn);
   res &= p_name(i,iv,ib,in);
   if(res) {
      if(strcmp(tn,in) != 0 && tn[0] != '*') res = 0;
   }
   return res;
}

int Parser::residue(char *t, int tv, int &tb,
             char *i,  int iv, int &ib, int &nrRes)
{
   int i1,i2;
   int t1,t2;
   int res=1;
   int dnum;
   char dnam[MAXLINE];

   setDels(" ()");
   res &= name(t,tv,t1,i,iv,i1);
   res &= p_del(t,t1,t2," ");
   res &= p_del(i,i1,i2," ");
   res &= resnum(t,t2,tb,i,i2,ib,nrRes);
   if(!res) {
      res = p_name(i,iv,i1,dnam);
      res &= p_del(i,i1,i2," ");
      res &= resnum(t,tv,tb,i,i2,ib,nrRes);
   }
   if(!res) {
      res = name(t,tv,tb,i,iv,i1);
      res &= p_del(i,i1,i2," ");
      res &= p_number(i,i2,ib,dnum);
      /* if(res && nrRes == UNDEFINED_RES_NR) nrRes = dnum; */
      /* else res &= (dnum == nrRes);                       */
   }

   return res;
}

int Parser::resnum(char *t, int tv, int &tb,
             char *i,  int iv, int &ib, int &nrRes)
{
   int res=1;
   int num;
   int numT;

   res &= p_number(i,iv,ib,num);
   if(res) {
      if(t[tv] == '*') {
         tb = tv+1;
         if(nrRes == UNDEFINED_RES_NR) nrRes = num;
         else res &= (num == nrRes);
      } else if(t[tv] == '-' || t[tv] == '+') {
         res &= p_number(t,tv+1,tb,numT);
         if(res) {
            if(t[tv] == '-') num += numT;
            else num -= numT;
            if(nrRes == UNDEFINED_RES_NR) nrRes = num;
            else res &= (num == nrRes);
         }
      } else if(p_number(t,tv,tb,numT)) {
         res &= (numT == num);
         if(nrRes == UNDEFINED_RES_NR) nrRes = num;
         else res &= (num == nrRes);
      } else {
         res = 0;
      }
   }
   return res;
}

int Parser::fastpeak(char *t, int tv, int &tb,
             char *i,  int iv, int &ib)
{
   char iAtName[DIMENSION][MAXNAME];
   char tAtName[DIMENSION][MAXNAME];

   int dim=0;
   int i1;
   int t1;
   int res =1;
   BibAccess bib;

   ib=iv; tb=tv;
   while(i[ib] != ':') ib++;
   ib += 2;
   while(i[ib] != '\0' && res) {
      if(t[tb] != '*') {
         i1=0;
         while(i[ib] != '(') {
            iAtName[dim][i1] = i[ib];
            i1++; ib++;
         }
         iAtName[dim][i1] = '\0';
         t1=0;
         while(t[tb] != '(') {
            tAtName[dim][t1] = t[tb];
            t1++; tb++;
         }
         tAtName[dim][t1] = '\0';
         while(i[ib] != ')' && res) {
           res &= (i[ib]==t[tb]);
           ib++; tb++;
         }
         ib++; tb++;
         while(i[ib] == ' ') ib++;
         while(t[tb] == ' ') tb++;
      } else {
         tb++;
         while(i[ib] != ')') ib++;
         ib++;
         while(i[ib] == ' ') ib++;
         while(t[tb] == ' ') tb++;
      }
      dim++;
   }
   i1=0;
   while(i1<dim && res) {
      res &= (strcmp(tAtName[i1],iAtName[i1]) == 0 ||
              bib.equivAtNam(tAtName[i1],iAtName[i1]));
      i1++;
   }
   return res;
}

