/*
************************************************************************
*
*   opt.h -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.opt.h
*   SCCS identification       : 1.2
*
************************************************************************
*/
/**************************************************************************/
/*                              opt.h                                     */
/*                                                                        */
/* methods to optimize assignments described by the nmr diagram           */
/**************************************************************************/

#ifndef _OPT_H_
#define _OPT_H_

#include "element.h"
#include "nmrdia.h"		/* base class describing experiments & ass.  */

/* forward declarations */
class OptGen;

class OptPar {			/* parameter for the optimization            */
public:
   OptPar(float,float,float,float);
				/* initialize: v,var,low,up                  */
   float low,up;		/* allowed range for parameter               */
   float v;			/* actual value of the parameter             */
   float var;			/* variance used to mutate the parameter     */
};

class Optimizer : public Element {
   NMRdia &nmrdia;
				/* general base class                        */
   CycErPeak liFixed;		/* list of peaks which should not be changed */
   CycErPeak liAss;		/* list of assigned peaks                    */
   CycErPeak liReject;		/* list of rejected unassigned peaks         */
   CycErPeak liUnass;		/* list of unassigned peaks                  */
   CycErPeak liInit;		/* list of peaks to initialize               */
   float tempSelect;		/* temprature to use free and ss selection   */
   float probSelDegen;		/* porbability to select degenerate peaks    */
   int it;			/* iteration counter                         */
   int cntChanged[DIMENSION+1];	/* statistic about changed co's              */
   ErPeak *parPeak;		/* peak from wich ass. is taken              */
   int parNr;			/* number of selected assignment             */
   /* routines to select peaks */
   Peak *selectList(Peak **, int n, float *, float *,Wert *, Wert *,
		    int *,ErPeak *,int);
				/* select from list of possible peaks        */
				/* INPUT: list, number of entries            */
				/*        allowed range                      */
				/*        assigned chem. shift               */
				/*        expected chem. shift               */
				/*        flags, whether the co's are ass.   */
   Peak *selectParents(ErPeak *, float *, float *,Wert *, Wert *,
                       int *,int);
				/* select from list of parent peaks          */
				/* INPUT: expected Peak from which to select */
				/*        allowed range                      */
				/*        assigned chem. shift               */
				/*        expected chem. shift               */
				/*        flags, whether the co's are ass.   */
				/*        number of assigned co's            */
				/*        prob. to drop degen. assignments   */
   Peak *selectEquiv(LiEquiv &, float *, float *,Wert *, Wert *,
		     int *, ErPeak *,int);
				/* select from list ss equivalent peaks      */
				/* INPUT: list of equiv. peaks               */
				/* 	  number of parents to use           */
				/*        allowed range                      */
				/*        assigned chem. shift               */
				/*        expected chem. shift               */
				/*        flags, whether the co's are ass.   */
   Peak *selectRange(Spectrum *, float *, float *, Wert *, Wert *, int, int *,
			ErPeak *);
				/* select measured peak from given spectrum  */
				/* in given range                            */
				/* INPUT: Spectrum,                          */
				/*        lower upper bound of range         */
				/*        assigned chem. shift               */
				/*        expected chem. shift               */
				/*        number of assigned frequencies     */
				/*        flags, whether the co's are ass.   */
   virtual int testCos(ErPeak *,  int *);
				/* decide which coherences should be changed */
				/* INPUT: corresponding expected peak        */
				/*        status of the co's (ASS <-> UNASS) */
                                /* OUTPUT: status changed                    */
				/* returns nr. of co's to RESET              */
public:
   friend LiOpt;
   friend OptGen;
   Optimizer(NMRdia &dia);	/* initialize with nmr diagram and status    */
   /* parameters for the optimization */
   OptPar ratioUnassMult;	/* which peaks should how often be selected  */
				/* for reassignment: unassigned or such with */
				/* ass. to degenerate measured peaks         */
   OptPar tempCo;		/* threshold to adapt coherences or keep them*/
				/* fixed                                     */
   OptPar mutIt;		/* number of mutational iterations to apply  */
   OptPar nrInitPoints;		/* number of residues to reset the ass.      */
   /* routines performing the optimization */
   virtual void initList();	/* fills the list according to the status of */
				/* the peaks                                 */
   virtual void initAss();	/* select initial assignment                 */
   virtual void recursiveInit();
                                /* recursive part of initAss();              */
   virtual void mutOpt(int it) {opt(it); }
				/* initialize for mutations                  */
   virtual void evolOpt(int, Envir &, float) {}
				/* perform optimization                      */
				/* calculate score                           */
				/* update scores                             */
   virtual void opt(int);	/* performs given number of opt. steps       */
   virtual int termCond() {return 0; }
				/* termination condition                     */
   virtual ErPeak *getUnass();	/* iterator over unassigned peaks            */
   virtual ErPeak *getUnassInit();
				/* iterator over unassigned peaks, prefers   */
				/* peaks taht are not degenerate             */
   virtual ErPeak *getReject();	/* Iterator over rejected peaks              */
   virtual ErPeak *getAssDegen();
				/* Iterator over expected peaks assigned to  */
				/* degenerate assigned peak                  */
   virtual ErPeak *getImprove();/* Iterator over peaks, where to improve the */
				/* assignments                               */
   virtual Peak *matchingPeak(ErPeak *);
				/* select a peak matching the exp. peak      */
   virtual Peak *matchingInitPeak(ErPeak *p) {return matchingPeak(p); }
				/* select a peak matching the exp. peak for  */
				/* initialisation                            */
   virtual Peak *possPeak(ErPeak *);
				/* select a poss. ass. for the exp. peak     */
   virtual int accept(ErPeak *, Peak *);
				/* decision whether to accept an assignment  */
   virtual int adapt(ErPeak *, Peak *, int *);
				/* decision whether to adapt certain co's or */
				/* to reject the assignment                  */
   virtual void acceptAss(ErPeak *, Peak *);
				/* assignment has been accepted, update lists*/
   virtual void makeAss(ErPeak *, Peak *, int *);
				/* new assignment, update lists              */
   virtual void resetPeaks(ErPeak *, int *);
				/* reset pesks of the co's to reset          */
   virtual void adaptCos(ErPeak *, Peak *, int *);
				/* adapt co's to match the assignment, update*/
				/* lists                                     */
   virtual void rejectAss(ErPeak *, Peak *);
				/* assignment has been rejected, update lists*/
   virtual void keepAss(ErPeak *);
				/* assignment has not changed, put back into */
				/* lists                                     */
   /* general routines */
   virtual void printInfo();	/* print information about the optimizer     */
   virtual char *idname() {return "local"; }
};

class OptGen : public Optimizer {
public:
   OptGen(NMRdia &dia);		/* initialize with nmr diagram and status    */
   virtual void evolOpt(int, Envir &, float);
				/* perform optimization                      */
				/* calculate score                           */
				/* update scores                             */
   virtual void initAss();	/* select initial assignment                 */
   virtual Peak *matchingPeak(ErPeak *p);
				/* select a peak matching the exp. peak      */
   virtual Peak *matchingInitPeak(ErPeak *);
				/* select a peak matching the exp. peak for  */
				/* initialisation                            */
   virtual Peak *possPeak(ErPeak *p);
				/* select a poss. ass. for the exp. peak     */
   virtual void printInfo();	/* print information about the optimizer     */
   virtual char *idname() {return "genetic"; }
};

#endif
