/*
************************************************************************
*
*   prep.h -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.atom.h
*   SCCS identification       : 1.2
*
************************************************************************
*/
/**************************************************************************/
/*                             match.h                                    */
/*                                                                        */
/* matching of two peak lists                                             */
/**************************************************************************/

#ifndef _MATCH_H_
#define _MATCH_H_

#include "global.h"			/* global constants                  */
#include "element.h"			/* base classes Element and Index    */

/* imported classes */
class Spectrum;
class LiPeak;
class Node;

class Matching { 
   int dim;
   float calcscore(int,Node *,int, Node*);	/* score of given matching     */
   float alternatingPath(int,Node *,int, Node*);/* find alternating path       */
   void updateCycle(int,Node *,int, Node*);     /* use path to improve match   */
   void domatch(int,Node *,int, Node*);		/* find best match             */
   void sort(int,Node *,int, Node*);            /* sort according to deviation */
   void calcdelt(int,Node *,int, Node*);        /* calc. offset between lists  */
   void listmatch(int,Node *,int, Node*);       /* list match                  */
   void copytoref(int,Node *,int, Node*);       /* copy assignments to ref list*/
   void copytoco(int,Node *,int, Node*);        /* copy assignments to co's    */
public:
   void match(Spectrum *, LiPeak &, LiPeak &, float, float);
};


#endif
