/*
************************************************************************
*
*   map.h -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.map.h
*   SCCS identification       : 1.2
*
************************************************************************
*/
/***************************************************************************/
/*                            map.h                                        */
/*                                                                         */
/* class to match a topology with a graph                                  */
/***************************************************************************/

#ifndef _MAP_H_
#define _MAP_H_

#include "atom.h"			/* atoms of the nmr diagram        */
#include "rel.h"			/* relation between atoms          */

class Graph;
class Spectrum;
class LiCo;
class LiErPeak;

/* Abbildung ***************************************************************/

class MapAt: public Atom {		/* atoms of the topology           */
public:
   Atom *partner;			/* matched atom in the graph       */
   int flag;
};

class Topol {				/* defines a topology of atoms     */
					/* interconected by relations and  */
					/* searches for occurencies of this*/
					/* topology within a graph         */
   int expand(Iterator,Graph *);
					/* try to expand match between     */
					/* topology and the graph          */
					/* start at given atom, use        */
					/* iterator to consider all relations */
   void relsAdd(MapAt *);		/* recursively add all relation to */
					/* the list of relations           */
protected:
   int max;				/* number of relations that have to*/
					/* be matched                      */
   int first,last;			/* external residue numbers of     */
					/* first and last residue for which*/
					/* to generate relations           */
public:
   LiAtom Atoms;			/* atoms of the topology           */
   LiRel rels;				/* relation of the topology        */
   Topol(int f=1,int l=0) {first=f; last=l;}
   virtual int found(Graph *);		/* routine to call, if a match has */
					/* been found                      */
   virtual int compAt(Atom *,Atom *);	/* are two atoms compatible ?      */
   virtual int compRel(Relation *,Relation *);
					/* are two relations compatible    */
   void cleanup();			/* erase the topology              */
   int match(Graph *);			/* match the topology to the graph */
					/* call found for each match       */
};

class JTopol : public Topol {		/* the topology identifies two atoms*/
					/* that are scalar coupled to one  */
					/* another			   */
					/* the two coupled atoms have atom */
					/* numbers 1 and 2                 */
   Wert J;				/* coupling constant of the top.   */
protected:
   int it;				/* number of the topology          */
   LiRel *rels;				/* list of relations of the topol. */
					/* to match against the graph      */
public:
   JTopol(int f=1,int l=0) : Topol(f,l) {}
   int start();				/* iteration over all topologies   */
   int next();
   int addBond(int, char *, int, char *);
					/* add a bond between two atoms    */
					/* with given atom nr. an type     */
					/* to the topology                 */
   virtual int found(Graph *);		/* for a found match, add a        */
					/* coupling to the relations       */
   virtual int compAt(Atom *,Atom *);   /* are two atoms compatible ?      */
   virtual int compRel(Relation *,Relation *);
					/* are two relations compatible    */
};

class StatNOETopol : public JTopol {
   float prob;
public:
   StatNOETopol(int f=1,int l=0) : JTopol(f,l) {}
   int start();
   int next();
   virtual int found(Graph *);
   virtual int compAt(Atom *a1,Atom *a2);
};

class NMRTopol : public Topol {
   int it;				/* number of the topology          */
   Spectrum *spec;			/* spectrum for which to generate  */
					/* the expected peaks              */
   LiCo *insertCos;			/* list of co's to which to        */
					/* add the found coherences        */
   LiErPeak *insertPeaks;		/* list of expected peaks to which */
					/* to add the found peaks          */
   int dim;				/* dimensionality of the spectrum  */
   float pExp;				/* prob. to observe the peak       */
public:
   NMRTopol(LiCo *, LiErPeak *);	/* initialize with list of co's and*/
					/* list of expected peaks to which */
					/* to add the found co's & peaks   */
   int start(Spectrum *);		/* iteration over all topologies   */
   int next();				/* of given spectrum               */
   int addCoupling(int, char *, int, char *);
					/* add a coupling between two atoms*/
					/* with given atom nr. an type     */
					/* to the topology                 */
   int addStatNOE(int, char *, int, char *);
					/* add a noe between two atoms     */
					/* with given atom nr. an type     */
					/* to the topology                 */
   void getAtoms(int,Atom **);		/* get list of atoms matched to the*/
					/* atoms 1..n of the topology      */
   virtual int found(Graph *);		/* for a found match, add a the    */
					/* coherences and the expected peak*/
					/* to the corresponding lists      */
   virtual int compAt(Atom *,Atom *);   /* are two atoms compatible ?      */
   virtual int compRel(Relation *,Relation *);
					/* are two relations compatible    */
};

#endif
