/*
************************************************************************
*
*   map.C -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.map.C
*   SCCS identification       : 1.4
*
************************************************************************
*/
/***************************************************************************/
/*                            map.cc                                       */
/*                                                                         */
/* class to match a topology with a graph                                  */
/***************************************************************************/

#include <string.h>
#include "element.h"			/* elements of a general list      */
#include "atom.h"			/* atoms of the nmr diagram        */
#include "rel.h"			/* relation between atoms          */
#include "ss.h"				/* graphs of atoms and rels        */
#include "co.h"				/* coherences                      */
#include "erPeak.h"			/* expected peaks                  */
#include "specTypes.h"			/* spectra and lists of spectra    */
#include "map.h"

void Topol::relsAdd(MapAt *mapAt)
{
   Relation *r;
   Iterator i;

   if(!mapAt->flag) {
      mapAt->flag = 1;
      r = (Relation *)mapAt->rels.start(i);
      while(r!=0) {
         rels.add(r);
         relsAdd((MapAt *)r->second());
         r = (Relation *)mapAt->rels.next(i);
      }
   }
}

/* Abbildung *****************************************************************/

int Topol::match(Graph *G)
{
   Atom *at;
   MapAt *mapAt;
   Relation *r;
   int res = 0;
   Iterator i,j;

   mapAt = (MapAt *)Atoms.start(j);		// reset all flags
   while(mapAt != 0) { mapAt->flag=0; mapAt=(MapAt *)Atoms.next(j); }

   rels.remove();
   mapAt = (MapAt *)Atoms.start(j);
   relsAdd(mapAt);

   max = rels.getn();

   if(max > 0) {
      at = (Atom *)G->Atoms.start(i);
      while(at != 0) {				// match for all atoms

         mapAt = (MapAt *)Atoms.start(j);	// reset all assignments
         while(mapAt != 0) { mapAt->partner=0; mapAt=(MapAt *)Atoms.next(j); }

         r = (Relation *)rels.start();

         if(compAt(r->first(),at)) {
            rels.init(j);
            ((MapAt *)r->first())->partner = at;
            res += expand(j,G);
         }
         at = (Atom *)G->Atoms.next(i);
      }
   }
   return(res);					// number of added couplings
}


int Topol::expand(Iterator mapi, Graph *G)
{
   Relation *mapR, *r;
   MapAt *mapAt1, *mapAt2;
   Atom *at1,*at2;
   Iterator i;
   int ok;
   int res=0;

   /*    mapAt1 <--mapR--> mapAt2 */
   /*       |                 |   */
   /*    partner           partner*/
   /*       |                 |   */
   /*      at1 <----r------> at2  */

   mapR = (Relation *)rels.next(mapi);
   if(mapR==0) {
      res=found(G);
   } else {
      mapAt1 = (MapAt *)mapR->first();
      mapAt2 = (MapAt *)mapR->second();
      at1 = mapAt1->partner;
      at2 = mapAt2->partner;
      if(at2 != 0) {
         r = (Relation *)at1->rels.start(i);
         ok = 0;
         while(r != 0) {
            if(at2 == r->second() && compRel(r,mapR)) {
               ok=1;
               break;
            }
            r = (Relation *)at1->rels.next(i);
         }
         if(ok) {
            res = expand(mapi,G);
         }
      } else {
         r = (Relation *)at1->rels.start(i);
         res = 0;
         while(r != 0) {
            if(compRel(r,mapR) && compAt(mapAt2,r->second())) {
               mapAt2->partner = r->second();
               res += expand(mapi,G);
            }
            r = (Relation *)at1->rels.next(i);
         }
         mapAt2->partner = 0;
      }
   }
   return res;
}

void Topol::cleanup()
{
   Atoms.del();
}

int Topol::found(Graph *)
{
   return 0;
}

int Topol::compAt(Atom *,Atom *)
{
   return 0;
}

int Topol::compRel(Relation *, Relation *)
{
   return 0;
}

int JTopol::compAt(Atom *A1,Atom *A2)
{
   return(!strcmp(A1->atype,A2->atype)
          || strcmp(A1->atype,"PSEUD")==0 && strcmp(A2->atype,"H_ALI")==0
          || strcmp(A2->atype,"PSEUD")==0 && strcmp(A1->atype,"H_ALI")==0
          || strcmp(A1->atype,"PSEUD")==0 && strcmp(A2->atype,"H_AMI")==0
          || strcmp(A2->atype,"PSEUD")==0 && strcmp(A1->atype,"H_AMI")==0
          || strcmp(A1->atype,"H_ARO")==0 && strcmp(A2->atype,"H_ALI")==0
          || strcmp(A2->atype,"H_ARO")==0 && strcmp(A1->atype,"H_ALI")==0
          || strcmp(A1->atype,"N_AMI")==0 && strcmp(A2->atype,"N_AMO")==0
          || strcmp(A2->atype,"N_AMI")==0 && strcmp(A1->atype,"N_AMO")==0
          || strcmp(A1->atype,"C_ALI")==0 && strcmp(A2->atype,"C_ARO")==0
          || strcmp(A2->atype,"C_ALI")==0 && strcmp(A1->atype,"C_ARO")==0
          || strcmp(A1->atype,"C_ALI")==0 && strcmp(A2->atype,"C_VIN")==0
          || strcmp(A2->atype,"C_ALI")==0 && strcmp(A1->atype,"C_VIN")==0
         );
}

int JTopol::compRel(Relation *R1, Relation *R2)
{
   return(R1->t==BOND && R2->t==BOND);
}

int JTopol::found(Graph *)
{
   Coupling *c1,*c2;
   Atom v1,v2;
   Atom *a1,*a2;
   int res;

   v1.nr=1;
   v2.nr=2;
   a1= ((MapAt *)Atoms.find(v1))->partner;
   a2= ((MapAt *)Atoms.find(v2))->partner;
   res=0;
   if(a1!=a2) {
      if(!a1->rels.Index::find(Coupling(a1,a2))) {
         c1=new Coupling(a1,a2);
         c1->J = J;
         res += a1->rels.insert(c1);
      }

      if(!a2->rels.Index::find(Coupling(a2,a1))) {
         c2=new Coupling(a2,a1);
         c2->J = J;
         res += a2->rels.insert(c2);
      }
   }
   return res;
}

int JTopol::start()
{
   it=0;
   return(next());
}

int JTopol::addBond(int n1,char *t1,int n2,char *t2)
{
   MapAt *A1,*A2;
   Bond *B;
   int res=1;

   A1 = new MapAt;
   A1->nr = n1;
   strcpy(A1->atype,t1);
   if(!Atoms.insert(A1)) delete A1;
   A1 = (MapAt *)Atoms.find(Atom(n1));
   A2 = new MapAt;
   A2->nr = n2;
   strcpy(A2->atype,t2);
   if(!Atoms.insert(A2)) delete A2;
   A2 = (MapAt *)Atoms.find(Atom(n2));
   B = new Bond(A1,A2);
   if(!A1->rels.insert(B)) delete B;

   return(res);
}

int JTopol::next()
{
   int res;

   it++;
   switch (it) {
      case 1: {
         res = addBond(1,"H_ALI",3,"C_ALI");
         res = addBond(3,"C_ALI",2,"H_ALI");
         J = Wert(10.0); 
         break; }
      case 2: {
         res = addBond(1,"H_AMI",3,"N_AMI");
         res = addBond(3,"N_AMI",2,"H_AMI");
         J = Wert(10.0); 
         break; }
      case 3: {
         res = addBond(1,"H_ALI",3,"C_ALI");
         res = addBond(3,"C_ALI",4,"C_ALI");
         res = addBond(4,"C_ALI",2,"H_ALI");
         J = Wert(10.0);
         break; }
      case 4: {
         res = addBond(1,"H_AMI",3,"N_AMI");
         res = addBond(3,"N_AMI",4,"C_ALI");
         res = addBond(4,"C_ALI",2,"H_ALI");
         J = Wert(12.0);
         break; }
      case 5: {
         res = addBond(1,"H_AMI",2,"N_AMI");
         J = Wert(90.0,10.0);
         break; }
      case 6: {
         res = addBond(1,"H_ALI",2,"C_ALI");
         J = Wert(50.0,10.0);
         break; }
      case 7: {
         res = addBond(1,"N_AMI",2,"C_ALI");
         J = Wert(9.0,2.0);
         break; }
      case 8: {
         res = addBond(1,"N_AMI",3,"C_BYL");
         res = addBond(3,"C_BYL",2,"C_ALI");
         J = Wert(5.0,2.0);
         break; }
      case 9: {
         res = addBond(1,"N_AMI",2,"C_BYL");
         J = Wert(15.0,2.0);
         break; }
      case 10: {
         res = addBond(1,"C_ALI",2,"C_BYL");
         J = Wert(55.0,5.0);
         break; }
      case 11: {
         res = addBond(1,"N_AMI",3,"C_ALI");    // N -> HB
         res = addBond(3,"C_ALI",4,"C_ALI");
         res = addBond(4,"C_ALI",2,"H_ALI");
         J = Wert(10.0,5.0);
         break; }
      case 12: {
         res = addBond(1,"C_ALI",2,"C_ALI");
         J = Wert(55.0,5.0);
         break; }
      case 13: {
         res = addBond(1,"C_BYL",2,"C_BYL");
         J = Wert(55.0,5.0);
         break; }
      default: {
         res=0;
         break; }
   }
   return(res);
}

int StatNOETopol::compAt(Atom *A1,Atom *A2)
{
   return(!strcmp(A1->atype,A2->atype)
          || strcmp(A1->atype,"N_AMI")==0 && strcmp(A2->atype,"N_AMO")==0
          || strcmp(A2->atype,"N_AMI")==0 && strcmp(A1->atype,"N_AMO")==0
          || strcmp(A1->atype,"PSEUD")==0 && strcmp(A2->atype,"H_ALI")==0
          || strcmp(A2->atype,"PSEUD")==0 && strcmp(A1->atype,"H_ALI")==0
         );
}

int StatNOETopol::found(Graph *)
{
   Noe *noe1,*noe2;
   Atom v1,v2;
   Atom *a1,*a2;
   int res;

   v1.nr=1;
   v2.nr=2;
   a1= ((MapAt *)Atoms.find(v1))->partner;
   a2= ((MapAt *)Atoms.find(v2))->partner;
   res=0;
   if(a1!=a2 && (first>last ||
                 a1->frag->nrExt>=first && a1->frag->nrExt<=last &&
                 a2->frag->nrExt>=first && a2->frag->nrExt<=last)) {
      if(!a1->rels.Index::find(Noe(a1,a2))) {
         noe1=new Noe(a1,a2);
         noe1->prob = prob;
         res+=a1->rels.insert(noe1);
      }
      if(!a2->rels.Index::find(Noe(a2,a1))) {
         noe2=new Noe(a2,a1);
         noe2->prob = prob;
         res+=a2->rels.insert(noe2);
      }
   }
   return res;
}

int StatNOETopol::start()
{
   it=0;
   return(next());
}

int StatNOETopol::next()
{
   int res;

   it++;
   switch (it) {
      case 1: {					// HA(i) --> HN(i)
         res = addBond(1,"H_AMI",3,"N_AMI");
         res = addBond(3,"N_AMI",4,"C_ALI");
         res = addBond(4,"C_ALI",2,"H_ALI");
         // rate = Wert(1.0); 
         prob = 1.0;
         break; }
      case 2: {					// HB(i) --> HN(i)
         res = addBond(1,"H_AMI",3,"N_AMI");
         res = addBond(3,"N_AMI",4,"C_ALI");
         res = addBond(4,"C_ALI",5,"C_ALI");
         res = addBond(5,"C_ALI",2,"H_ALI");
         // rate = Wert(1.0); 
         prob = 0.75;
         break; }
      case 3: {					// HG(i) --> HN(i)
         res = addBond(1,"H_AMI",3,"N_AMI");
         res = addBond(3,"N_AMI",4,"C_ALI");
         res = addBond(4,"C_ALI",5,"C_ALI");
         res = addBond(5,"C_ALI",6,"C_ALI");
         res = addBond(6,"C_ALI",2,"H_ALI");
         // rate = Wert(0.6); 
         prob = 0.3;
         break; }
      case 4: {					// HN(i) --> HN(i+1)
         res = addBond(1,"H_AMI",3,"N_AMI");
         res = addBond(3,"N_AMI",4,"C_ALI");
         res = addBond(4,"C_ALI",5,"C_BYL");
         res = addBond(5,"C_BYL",6,"N_AMI");
         res = addBond(6,"N_AMI",2,"H_AMI");
         // rate = Wert(1.0); 
         prob = 0.5;
         break; }
      case 5: {					// HA(i) --> HN(i+1)
         res = addBond(1,"H_ALI",3,"C_ALI");
         res = addBond(3,"C_ALI",4,"C_BYL");
         res = addBond(4,"C_BYL",5,"N_AMI");
         res = addBond(5,"N_AMI",2,"H_AMI");
         // rate = Wert(1.0); 
         prob = 0.75;
         break; }
      case 6: {					// HB(i) --> HN(i+1)
         res = addBond(1,"H_ALI",3,"C_ALI");
         res = addBond(3,"C_ALI",4,"C_ALI");
         res = addBond(4,"C_ALI",5,"C_BYL");
         res = addBond(5,"C_BYL",6,"N_AMI");
         res = addBond(6,"N_AMI",2,"H_AMI");
         // rate = Wert(1.0); 
         prob = 0.75;
         break; }
      case 7: {					// HG(i) --> HN(i+1)
         res = addBond(1,"H_ALI",3,"C_ALI");
         res = addBond(3,"C_ALI",4,"C_ALI");
         res = addBond(4,"C_ALI",5,"C_ALI");
         res = addBond(5,"C_ALI",6,"C_BYL");
         res = addBond(6,"C_BYL",7,"N_AMI");
         res = addBond(7,"N_AMI",2,"H_AMI");
         // rate = Wert(1.0); 
         prob = 0.05;
         break; }
      case 8: {					// HB(i) --> Hring(i)
         res = addBond(1,"H_ARO",3,"C_ARO");
         res = addBond(3,"C_ARO",4,"C_VIN");
         res = addBond(4,"C_VIN",5,"C_ALI");
         res = addBond(5,"C_ALI",2,"H_ALI");
         // rate = Wert(1.0); 
         prob = 0.75;
         break; }
      case 9: {					// HB(i) --> HNring(i)
         res = addBond(1,"H_AMI",3,"N_AMI");
         res = addBond(3,"N_AMI",4,"C_VIN");
         res = addBond(4,"C_VIN",5,"C_ALI");
         res = addBond(5,"C_ALI",2,"H_ALI");
         // rate = Wert(1.0); 
         prob = 0.75;
         break; }
      case 10: {				// Hring(i) --> HNring(i)
         res = addBond(1,"H_AMI",3,"N_AMI");
         res = addBond(3,"N_AMI",4,"C_ARO");
         res = addBond(4,"C_ARO",2,"H_ARO");
         // rate = Wert(1.0); 
         prob = 0.8;
         break; }
      case 11: {				// Hring(i) --> Hring(i)
         res = addBond(1,"H_ARO",3,"C_ARO");
         res = addBond(3,"C_ARO",4,"C_ARO");
         res = addBond(4,"C_ARO",2,"H_ARO");
         // rate = Wert(1.0); 
         prob = 0.8;
         break; }
      case 12: {				// Hring(i) --> Hring(i)
         res = addBond(1,"H_ARO",3,"C_ARO");
         res = addBond(3,"C_ARO",4,"C_ARO");
         res = addBond(4,"C_ARO",5,"C_ARO");
         res = addBond(5,"C_ARO",2,"H_ARO");
         // rate = Wert(1.0); 
         prob = 0.8;
         break; }
      case 13: {					// HA(i) --> HB(i) etc.
         res = addBond(1,"H_ALI",3,"C_ALI");
         res = addBond(3,"C_ALI",4,"C_ALI");
         res = addBond(4,"C_ALI",2,"H_ALI");
         // rate = Wert(1.0); 
         prob = 1.0;
         break; }
      case 14: {					// HB(i) --> HB(i) etc.
         res = addBond(1,"H_ALI",3,"C_ALI");
         res = addBond(3,"C_ALI",2,"H_ALI");
         // rate = Wert(1.0); 
         prob = 1.0;
         break; }
      case 15: {					// HN(i) --> HN(i) etc.
         res = addBond(1,"H_AMI",3,"N_AMI");
         res = addBond(3,"N_AMI",2,"H_AMI");
         // rate = Wert(1.0); 
         prob = 1.0;
         break; }
      case 16: {					// HA(i) --> HG(i) etc.
         res = addBond(1,"H_ALI",3,"C_ALI");
         res = addBond(3,"C_ALI",4,"C_ALI");
         res = addBond(4,"C_ALI",5,"C_ALI");
         res = addBond(5,"C_ALI",2,"H_ALI");
         // rate = Wert(1.0); 
         prob = 0.6;
         break; }
      case 17: {					// HA(i) --> HG(i+1) Pro
         res = addBond(1,"H_ALI",3,"C_ALI");
         res = addBond(3,"C_ALI",4,"N_AMI");
         res = addBond(4,"N_AMI",5,"C_ALI");
         res = addBond(4,"N_AMI",6,"C_BYL");
         res = addBond(6,"C_BYL",7,"C_ALI");
         res = addBond(7,"C_ALI",2,"H_ALI");
         res = addBond(5,"C_ALI",8,"C_ALI");
         res = addBond(8,"C_ALI",9,"C_ALI");
         res = addBond(9,"C_ALI",3,"C_ALI");
         // rate = Wert(1.0); 
         prob = 0.3;
         break; }
      case 18: {					// HN(i) --> HG(i+1) Pro
         res = addBond(1,"H_ALI",3,"C_ALI");
         res = addBond(3,"C_ALI",4,"N_AMI");
         res = addBond(4,"N_AMI",5,"C_ALI");
         res = addBond(4,"N_AMI",6,"C_BYL");
         res = addBond(6,"C_BYL",7,"C_ALI");
         res = addBond(7,"C_ALI",8,"N_AMI");
         res = addBond(8,"N_AMI",2,"H_AMI");
         res = addBond(5,"C_ALI",9,"C_ALI");
         res = addBond(9,"C_ALI",10,"C_ALI");
         res = addBond(10,"C_ALI",3,"C_ALI");
         // rate = Wert(1.0); 
         prob = 0.3;
         break; }
      default: {
         res=0;
         break; }
   }
   return(res);
}

NMRTopol::NMRTopol(LiCo *liCo, LiErPeak *peaks)
{
   insertCos = liCo;
   insertPeaks = peaks;
}

int NMRTopol::compAt(Atom *A1,Atom *A2)
{
   int res;

   res = (!strcmp(A1->atype,A2->atype)
          || strcmp(A1->atype,"PSEUD")==0 && strcmp(A2->atype,"H_ALI")==0
          || strcmp(A2->atype,"PSEUD")==0 && strcmp(A1->atype,"H_ALI")==0
          || strcmp(A1->atype,"H_ARO")==0 && strcmp(A2->atype,"H_ALI")==0
          || strcmp(A2->atype,"H_ARO")==0 && strcmp(A1->atype,"H_ALI")==0
          || strcmp(A1->atype,"N_AMI")==0 && strcmp(A2->atype,"N_AMO")==0
          || strcmp(A2->atype,"N_AMI")==0 && strcmp(A1->atype,"N_AMO")==0
//          || strcmp(A1->atype,"C_ALI")==0 && strcmp(A2->atype,"C_ARO")==0
//          || strcmp(A2->atype,"C_ALI")==0 && strcmp(A1->atype,"C_ARO")==0
//          || strcmp(A1->atype,"C_ALI")==0 && strcmp(A2->atype,"C_VIN")==0
//          || strcmp(A2->atype,"C_ALI")==0 && strcmp(A1->atype,"C_VIN")==0
   );
   if(!res) return(0);

   Iterator i;
   MapAt *sAt;

   sAt = (MapAt *)Atoms.start(i);
   while(res && sAt != 0) {
      if(sAt != A1 && sAt->partner == A2) res = 0;
      sAt = (MapAt *)Atoms.next(i);
   }
   return(res);
}

int NMRTopol::compRel(Relation *R1, Relation *R2)
{
   return(R1->t==COUPLING && R2->t==COUPLING
          || R1->t==NOE && R2->t==NOE
   );
}

int NMRTopol::addCoupling(int n1,char *t1,int n2,char *t2)
{
   MapAt *A1,*A2;
   Coupling *C;
   int res=1;

   A1 = new MapAt;
   A1->nr = n1;
   strcpy(A1->atype,t1);
   if(!Atoms.insert(A1)) delete A1;
   A1 = (MapAt *)Atoms.find(Atom(n1));
   A2 = new MapAt;
   A2->nr = n2;
   strcpy(A2->atype,t2);
   if(!Atoms.insert(A2)) delete A2;
   A2 = (MapAt *)Atoms.find(Atom(n2));
   C = new Coupling(A1,A2);
   if(!A1->rels.insert(C)) delete C;

   return(res);
}

int NMRTopol::addStatNOE(int n1,char *t1,int n2,char *t2)
{
   MapAt *A1,*A2;
   Noe *NOE;
   int res=1;

   A1 = new MapAt;
   A1->nr = n1;
   strcpy(A1->atype,t1);
   if(!Atoms.insert(A1)) delete A1;
   A1 = (MapAt *)Atoms.find(Atom(n1));
   A2 = new MapAt;
   A2->nr = n2;
   strcpy(A2->atype,t2);
   if(!Atoms.insert(A2)) delete A2;
   A2 = (MapAt *)Atoms.find(Atom(n2));
   NOE = new Noe(A1,A2);
   if(!A1->rels.insert(NOE)) delete NOE;

   return(res);
}

int NMRTopol::start(Spectrum *sp)
{
   spec = sp;
   dim = sp->type->dim;
   it=0;
   return(next());
}

int NMRTopol::next()
{
   int res;

   it++;
   switch (spec->type->type) {
      case COSY: {
         switch (it) {
            case 1: {
               res = addCoupling(1,"H_ALI",2,"H_ALI");
               pExp = 0.98;
               break; }
            case 2: {
               res = addCoupling(1,"H_AMI",2,"H_ALI");
               pExp = 0.98;
               break; }
            case 3: {
               res = addCoupling(1,"H_ALI",2,"H_AMI");
               pExp = 0.98;
               break; }
            case 4: {
               res = addCoupling(1,"H_AMI",2,"H_AMI");
               pExp = 0.98;
               break; }
            default: {
               res=0;
               break; }
         }
         break;
      }
      case D2OCOSY: {
         switch (it) {
            case 1: {
               res = addCoupling(1,"H_ALI",2,"H_ALI");
               pExp = 0.98;
               break; }
            default: {
               res=0;
               break; }
         }
         break;
      }
      case C13H1: {
         switch (it) {
            case 1: {
               res = addCoupling(1,"C_ALI",2,"H_ALI");
               pExp = 0.98;
               break; }
            default: {
               res=0;
               break; }
         }
         break;
      }
      case N15H1: {
         switch (it) {
            case 1: {
               res = addCoupling(1,"N_AMI",2,"H_AMI");
               pExp = 0.98;
               break; }
            default: {
               res=0;
               break; }
         }
         break;
      }
      case NOESY: {
         switch (it) {
            case 1: {
               res = addStatNOE(1,"H_ALI",2,"H_ALI");
               pExp = 0.98;
               break; }
            case 2: {
               res = addStatNOE(1,"H_AMI",2,"H_ALI");
               pExp = 0.98;
               break; }
            case 3: {
               res = addStatNOE(1,"H_ALI",2,"H_AMI");
               pExp = 0.98;
               break; }
            case 4: {
               res = addStatNOE(1,"H_AMI",2,"H_AMI");
               pExp = 0.98;
               break; }
            default: {
               res=0;
               break; }
         }
         break;
      }
      case D2ONOESY: {
         switch (it) {
            case 1: {
               res = addStatNOE(1,"H_ALI",2,"H_ALI");
               pExp = 0.98;
               break; }
            default: {
               res=0;
               break; }
         }
         break;
      }
      case N15NOESY: {
         switch (it) {
            case 1: {
               res = addCoupling(1,"N_AMI",2,"H_AMI");
               pExp = 0.98;
               break; }
            case 2: {
               res = addCoupling(1,"N_AMI",2,"H_AMI");
               res = addStatNOE(2,"H_AMI",3,"H_ALI");
               pExp = 0.98;
               break; }
            case 3: {
               res = addCoupling(1,"N_AMI",2,"H_AMI");
               res = addStatNOE(2,"H_AMI",3,"H_AMI");
               pExp = 0.98;
               break; }
            default: {
               res=0;
               break; }
         }
         break;
      }
      case RELNOESY: {
         switch (it) {
            case 1: {
               res = addCoupling(1,"N_AMI",2,"H_AMI");
               pExp = 0.98;
               break; }
            case 2: {
               res = addCoupling(1,"N_AMI",3,"H_AMI");
               res = addStatNOE(3,"H_AMI",2,"H_ALI");
               pExp = 0.98;
               break; }
            case 3: {
               res = addCoupling(1,"N_AMI",3,"H_AMI");
               res = addStatNOE(3,"H_AMI",2,"H_AMI");
               pExp = 0.98;
               break; }
            default: {
               res=0;
               break; }
         }
         break;
      }
      case C13NOESY: {
         switch (it) {
            case 1: {
               res = addCoupling(1,"C_ALI",2,"H_ALI");
               pExp = 0.98;
               break; }
            case 2: {
               res = addCoupling(1,"C_ALI",2,"H_ALI");
               res = addStatNOE(2,"H_ALI",3,"H_ALI");
               pExp = 0.98;
               break; }
            case 3: {
               res = addCoupling(1,"C_ALI",2,"H_ALI");
               res = addStatNOE(2,"H_ALI",3,"H_AMI");
               pExp = 0.98;
               break; }
            default: {
               res=0;
               break; }
         }
         break;
      }
      case C13NOED2O: {
         switch (it) {
            case 1: {
               res = addCoupling(1,"C_ALI",2,"H_ALI");
               pExp = 0.98;
               break; }
            case 2: {
               res = addCoupling(1,"C_ALI",2,"H_ALI");
               res = addStatNOE(2,"H_ALI",3,"H_ALI");
               pExp = 0.98;
               break; }
            default: {
               res=0;
               break; }
         }
         break;
      }
      case CCNOESY: {
         switch (it) {
            case 1: {
               res = addCoupling(1,"C_ALI",2,"H_ALI");
               pExp = 0.98;
               break; }
            case 2: {
               res = addCoupling(1,"C_ALI",2,"H_ALI");
               res = addStatNOE(2,"H_ALI",3,"H_ALI");
               res = addCoupling(3,"H_ALI",4,"C_ALI");
               pExp = 0.98;
               break; }
            default: {
               res=0;
               break; }
         }
         break;
      }
      case HN_CO_CA: {
         switch (it) {
            case 1: {
               res = addCoupling(1,"H_AMI",2,"N_AMI");
               res = addCoupling(2,"N_AMI",4,"C_BYL");
               res = addCoupling(4,"C_BYL",3,"C_ALI");
               pExp = 0.98;
               break; }
            default: {
               res=0;
               break; }
         }
         break;
      }
      case HNCA: {
         switch (it) {
            case 1: {
               res = addCoupling(1,"H_AMI",2,"N_AMI");
               res = addCoupling(2,"N_AMI",3,"C_ALI");
               pExp = 0.98;
               break; }
            case 2: {
               res = addCoupling(1,"H_AMI",2,"N_AMI");
               res = addCoupling(2,"N_AMI",4,"C_BYL");
               res = addCoupling(4,"C_BYL",3,"C_ALI");
               pExp = 0.3;
               break; }
            default: {
               res=0;
               break; }
         }
         break;
      }
      case CBCANH: {
         switch (it) {
            case 1: {
               res = addCoupling(1,"H_AMI",2,"N_AMI");
               res = addCoupling(2,"N_AMI",3,"C_ALI");
               pExp = 0.98;
               break; }
            case 2: {
               res = addCoupling(1,"H_AMI",2,"N_AMI");
               res = addCoupling(2,"N_AMI",4,"C_ALI");
               res = addCoupling(4,"C_ALI",3,"C_ALI");
               pExp = 0.98;
               break; }
            case 3: {
               res = addCoupling(1,"H_AMI",2,"N_AMI");
               res = addCoupling(2,"N_AMI",4,"C_BYL");
               res = addCoupling(4,"C_BYL",3,"C_ALI");
               pExp = 0.3;
               break; }
            case 4: {
               res = addCoupling(1,"H_AMI",2,"N_AMI");
               res = addCoupling(2,"N_AMI",4,"C_BYL");
               res = addCoupling(4,"C_BYL",5,"C_ALI");
               res = addCoupling(5,"C_ALI",3,"C_ALI");
               pExp = 0.3;
               break; }
            default: {
               res=0;
               break; }
         }
         break;
      }
      case CBCACONH: {
         switch (it) {
            case 1: {
               res = addCoupling(1,"H_AMI",2,"N_AMI");
               res = addCoupling(2,"N_AMI",4,"C_BYL");
               res = addCoupling(4,"C_BYL",3,"C_ALI");
               pExp = 0.98;
               break; }
            case 2: {
               res = addCoupling(1,"H_AMI",2,"N_AMI");
               res = addCoupling(2,"N_AMI",4,"C_BYL");
               res = addCoupling(4,"C_BYL",5,"C_ALI");
               res = addCoupling(5,"C_ALI",3,"C_ALI");
               pExp = 0.98;
               break; }
            default: {
               res=0;
               break; }
         }
         break;
      }
      case HBHACONH: {
         switch (it) {
            case 1: {
               res = addCoupling(1,"H_AMI",2,"N_AMI");
               res = addCoupling(2,"N_AMI",4,"C_BYL");
               res = addCoupling(4,"C_BYL",5,"C_ALI");
               res = addCoupling(5,"C_BYL",3,"H_ALI");
               pExp = 0.98;
               break; }
            case 2: {
               res = addCoupling(1,"H_AMI",2,"N_AMI");
               res = addCoupling(2,"N_AMI",4,"C_BYL");
               res = addCoupling(4,"C_BYL",5,"C_ALI");
               res = addCoupling(5,"C_ALI",6,"C_ALI");
               res = addCoupling(6,"C_ALI",3,"H_ALI");
               pExp = 0.3;
               break; }
            default: {
               res=0;
               break; }
         }
         break;
      }
      case HNHB: {
         switch (it) {
            case 1: {
               res = addCoupling(1,"N_AMI",2,"H_AMI");
               pExp = 0.98;
               break; }
            case 2: {
               res = addCoupling(1,"N_AMI",2,"H_AMI");
               res = addCoupling(1,"N_AMI",3,"H_ALI");
               pExp = 0.98;
               break; }
            default: {
               res=0;
               break; }
         }
         break;
      }
      case HNCO: {
         switch (it) {
            case 1: {
               res = addCoupling(1,"H_AMI",2,"N_AMI");
               res = addCoupling(2,"N_AMI",3,"C_BYL");
               pExp = 0.98;
               break; }
            default: {
               res=0;
               break; }
         }
         break;
      }
      case HCACO: {
         switch (it) {
            case 1: {
               res = addCoupling(1,"H_ALI",2,"C_ALI");
               res = addCoupling(2,"C_ALI",3,"C_BYL");
               pExp = 0.98;
               break; }
            default: {
               res=0;
               break; }
         }
         break;
      }
      case HCA_CO_N: {
         switch (it) {
            case 1: {
               res = addCoupling(1,"H_ALI",2,"C_ALI");
               res = addCoupling(2,"C_ALI",4,"C_BYL");
               res = addCoupling(4,"C_BYL",3,"N_AMI");
               pExp = 0.98;
               break; }
            default: {
               res=0;
               break; }
         }
         break;
      }
      case TOCSY: {
         switch (it) {
            case 1: {
               res = addCoupling(1,"H_ALI",2,"H_ALI");
               pExp = 0.98;
               break; }
            case 2: {
               res = addCoupling(1,"H_AMI",2,"H_ALI");
               pExp = 0.98;
               break; }
            case 3: {
               res = addCoupling(1,"H_ALI",2,"H_AMI");
               pExp = 0.98;
               break; }
            case 4: {
               res = addCoupling(1,"H_ALI",3,"H_ALI");
               res = addCoupling(3,"H_ALI",2,"H_ALI");
               pExp = 0.98;
               break; }
            case 5: {
               res = addCoupling(1,"H_AMI",3,"H_ALI");
               res = addCoupling(3,"H_ALI",2,"H_ALI");
               pExp = 0.98;
               break; }
            case 6: {
               res = addCoupling(1,"H_AMI",3,"H_ALI");
               res = addCoupling(3,"H_ALI",2,"H_AMI");
               pExp = 0.98;
               break; }
            case 7: {
               res = addCoupling(1,"H_ALI",3,"H_ALI");
               res = addCoupling(3,"H_ALI",2,"H_AMI");
               pExp = 0.98;
               break; }
            case 8: {
               res = addCoupling(1,"H_ALI",3,"H_ALI");
               res = addCoupling(3,"H_ALI",4,"H_ALI");
               res = addCoupling(4,"H_ALI",2,"H_ALI");
               pExp = 0.98;
               break; }
            case 9: {
               res = addCoupling(1,"H_AMI",3,"H_ALI");
               res = addCoupling(3,"H_ALI",4,"H_ALI");
               res = addCoupling(4,"H_ALI",2,"H_ALI");
               pExp = 0.98;
               break; }
            case 10: {
               res = addCoupling(1,"H_ALI",3,"H_ALI");
               res = addCoupling(3,"H_ALI",4,"H_ALI");
               res = addCoupling(4,"H_ALI",2,"H_AMI");
               pExp = 0.98;
               break; }
            case 11: {
               res = addCoupling(1,"H_AMI",3,"H_ALI");
               res = addCoupling(3,"H_ALI",4,"H_ALI");
               res = addCoupling(4,"H_ALI",5,"H_ALI");
               res = addCoupling(5,"H_ALI",2,"H_ALI");
               pExp = 0.8;
               break; } 
            case 12: {
               res = addCoupling(1,"H_ALI",3,"H_ALI");
               res = addCoupling(3,"H_ALI",4,"H_ALI");
               res = addCoupling(4,"H_ALI",5,"H_ALI");
               res = addCoupling(5,"H_ALI",2,"H_ALI");
               pExp = 0.8;
               break; } 
            case 13: {
               res = addCoupling(1,"H_ALI",3,"H_ALI");
               res = addCoupling(3,"H_ALI",4,"H_ALI");
               res = addCoupling(4,"H_ALI",5,"H_ALI");
               res = addCoupling(5,"H_ALI",2,"H_AMI");
               pExp = 0.8;
               break; } 
            case 14: {
               res = addCoupling(1,"H_ALI",3,"H_ALI");
               res = addCoupling(3,"H_ALI",4,"H_ALI");
               res = addCoupling(4,"H_ALI",5,"H_ALI");
               res = addCoupling(5,"H_ALI",6,"H_ALI");
               res = addCoupling(6,"H_ALI",2,"H_ALI"); 
               pExp = 0.3;
               break; } 
            case 15: {
               res = addCoupling(1,"H_AMI",3,"H_ALI");
               res = addCoupling(3,"H_ALI",4,"H_ALI");
               res = addCoupling(4,"H_ALI",5,"H_ALI");
               res = addCoupling(5,"H_ALI",6,"H_ALI");
               res = addCoupling(6,"H_ALI",2,"H_ALI"); 
               pExp = 0.3;
               break; } 
            case 16: {
               res = addCoupling(1,"H_ALI",3,"H_ALI");
               res = addCoupling(3,"H_ALI",4,"H_ALI");
               res = addCoupling(4,"H_ALI",5,"H_ALI");
               res = addCoupling(5,"H_ALI",6,"H_ALI");
               res = addCoupling(6,"H_ALI",2,"H_AMI"); 
               pExp = 0.3;
               break; } 
            case 17: {
               res = addCoupling(1,"H_AMI",2,"H_AMI");
               pExp = 0.98;
               break; }
            case 18: {
               res = addCoupling(1,"H_ALI",3,"H_AMI");
               res = addCoupling(3,"H_AMI",2,"H_ALI");
               pExp = 0.98;
               break; }
            case 19: {
               res = addCoupling(1,"H_AMI",3,"H_ALI");
               res = addCoupling(3,"H_ALI",4,"H_ALI");
               res = addCoupling(4,"H_ALI",5,"H_ALI");
               res = addCoupling(5,"H_ALI",6,"H_ALI");
               res = addCoupling(6,"H_ALI",2,"H_AMI"); 
               pExp = 0.3;
               break; } 
            default: {
               res=0;
               break; }
         }
         break;
      }
      case D2OTOCSY: {
         switch (it) {
            case 1: {
               res = addCoupling(1,"H_ALI",2,"H_ALI");
               pExp = 0.98;
               break; }
            case 2: {
               res = addCoupling(1,"H_ALI",3,"H_ALI");
               res = addCoupling(3,"H_ALI",2,"H_ALI");
               pExp = 0.98;
               break; }
            case 3: {
               res = addCoupling(1,"H_ALI",3,"H_ALI");
               res = addCoupling(3,"H_ALI",4,"H_ALI");
               res = addCoupling(4,"H_ALI",2,"H_ALI");
               pExp = 0.98;
               break; }
            case 4: {
               res = addCoupling(1,"H_ALI",3,"H_ALI");
               res = addCoupling(3,"H_ALI",4,"H_ALI");
               res = addCoupling(4,"H_ALI",5,"H_ALI");
               res = addCoupling(5,"H_ALI",2,"H_ALI");
               pExp = 0.8;
               break; } 
            case 5: {
               res = addCoupling(1,"H_ALI",3,"H_ALI");
               res = addCoupling(3,"H_ALI",4,"H_ALI");
               res = addCoupling(4,"H_ALI",5,"H_ALI");
               res = addCoupling(5,"H_ALI",6,"H_ALI");
               res = addCoupling(6,"H_ALI",2,"H_ALI"); 
               pExp = 0.3;
               break; } 
            default: {
               res=0;
               break; }
         }
         break;
      }
      case N15TOCSY: {
         switch (it) {
            case 1: {
               res = addCoupling(1,"N_AMI",2,"H_AMI");
               pExp = 0.98;
               break; }
            case 2: {
               res = addCoupling(1,"N_AMI",2,"H_AMI");
               res = addCoupling(2,"H_AMI",3,"H_ALI");
               pExp = 0.98;
               break; }
            case 3: {
               res = addCoupling(1,"N_AMI",2,"H_AMI");
               res = addCoupling(2,"H_AMI",3,"H_AMI");
               pExp = 0.98;
               break; }
            case 4: {
               res = addCoupling(1,"N_AMI",2,"H_AMI");
               res = addCoupling(2,"H_AMI",4,"H_ALI");
               res = addCoupling(4,"H_ALI",3,"H_ALI");
               pExp = 0.98;
               break; }
            case 5: {
               res = addCoupling(1,"N_AMI",2,"H_AMI");
               res = addCoupling(2,"H_AMI",4,"H_ALI");
               res = addCoupling(4,"H_ALI",3,"H_AMI");
               pExp = 0.98;
               break; }
            case 6: {
               res = addCoupling(1,"N_AMI",2,"H_AMI");
               res = addCoupling(2,"H_AMI",4,"H_ALI");
               res = addCoupling(4,"H_ALI",3,"H_AMI");
               pExp = 0.98;
               break; }
            case 7: {
               res = addCoupling(1,"N_AMI",2,"H_AMI");
               res = addCoupling(2,"H_AMI",4,"H_ALI");
               res = addCoupling(4,"H_ALI",5,"H_ALI");
               res = addCoupling(5,"H_ALI",3,"H_ALI");
               pExp = 0.01;
               break; }
            case 8: {
               res = addCoupling(1,"N_AMI",2,"H_AMI");
               res = addCoupling(2,"H_AMI",4,"H_ALI");
               res = addCoupling(4,"H_ALI",5,"H_ALI");
               res = addCoupling(5,"H_ALI",3,"H_AMI");
               pExp = 0.01;
               break; }
//            case 9: {
//               res = addCoupling(1,"N_AMI",2,"H_AMI");
//               res = addCoupling(2,"H_AMI",4,"H_ALI");
//               res = addCoupling(4,"H_ALI",5,"H_ALI");
//               res = addCoupling(5,"H_ALI",6,"H_ALI");
//               res = addCoupling(6,"H_ALI",3,"H_ALI");
//               pExp = 0.1;
//               break; }
//            case 10: {
//               res = addCoupling(1,"N_AMI",2,"H_AMI");
//               res = addCoupling(2,"H_AMI",4,"H_ALI");
//               res = addCoupling(4,"H_ALI",5,"H_ALI");
//               res = addCoupling(5,"H_ALI",6,"H_ALI");
//               res = addCoupling(6,"H_ALI",3,"H_AMI");
//               pExp = 0.1;
//               break; }
            default: {
               res=0;
               break; }
         }
         break;
      }
      case RELTOCSY: {
         switch (it) {
            case 1: {
               res = addCoupling(1,"N_AMI",2,"H_AMI");
               pExp = 0.98;
               break; }
            case 2: {
               res = addCoupling(1,"N_AMI",3,"H_AMI");
               res = addCoupling(3,"H_AMI",2,"H_ALI");
               pExp = 0.98;
               break; }
            case 3: {
               res = addCoupling(1,"N_AMI",3,"H_AMI");
               res = addCoupling(3,"H_AMI",2,"H_AMI");
               pExp = 0.98;
               break; }
            case 4: {
               res = addCoupling(1,"N_AMI",3,"H_AMI");
               res = addCoupling(3,"H_AMI",4,"H_ALI");
               res = addCoupling(4,"H_ALI",2,"H_ALI");
               pExp = 0.98;
               break; }
            case 5: {
               res = addCoupling(1,"N_AMI",3,"H_AMI");
               res = addCoupling(3,"H_AMI",4,"H_ALI");
               res = addCoupling(4,"H_ALI",2,"H_AMI");
               pExp = 0.98;
               break; }
            case 6: {
               res = addCoupling(1,"N_AMI",3,"H_AMI");
               res = addCoupling(3,"H_AMI",4,"H_ALI");
               res = addCoupling(4,"H_ALI",2,"H_AMI");
               pExp = 0.98;
               break; }
            case 7: {
               res = addCoupling(1,"N_AMI",3,"H_AMI");
               res = addCoupling(3,"H_AMI",4,"H_ALI");
               res = addCoupling(4,"H_ALI",5,"H_ALI");
               res = addCoupling(5,"H_ALI",2,"H_ALI");
               pExp = 0.9;
               break; }
            case 8: {
               res = addCoupling(1,"N_AMI",3,"H_AMI");
               res = addCoupling(3,"H_AMI",4,"H_ALI");
               res = addCoupling(4,"H_ALI",5,"H_ALI");
               res = addCoupling(5,"H_ALI",2,"H_AMI");
               pExp = 0.9;
               break; }
            case 9: {
               res = addCoupling(1,"N_AMI",3,"H_AMI");
               res = addCoupling(3,"H_AMI",4,"H_ALI");
               res = addCoupling(4,"H_ALI",5,"H_ALI");
               res = addCoupling(5,"H_ALI",6,"H_ALI");
               res = addCoupling(6,"H_ALI",2,"H_ALI");
               pExp = 0.4;
               break; }
            case 10: {
               res = addCoupling(1,"N_AMI",3,"H_AMI");
               res = addCoupling(3,"H_AMI",4,"H_ALI");
               res = addCoupling(4,"H_ALI",5,"H_ALI");
               res = addCoupling(5,"H_ALI",6,"H_ALI");
               res = addCoupling(6,"H_ALI",2,"H_AMI");
               pExp = 0.4;
               break; }
            default: {
               res=0;
               break; }
         }
         break;
      }
      case CRELTOCSY: {
         switch (it) {
            case 1: {
               res = addCoupling(1,"C_ALI",2,"H_ALI");
               pExp = 0.98;
               break; }
            case 2: {
               res = addCoupling(1,"C_ALI",3,"H_ALI");
               res = addCoupling(3,"H_ALI",2,"H_ALI");
               pExp = 0.98;
               break; }
            case 3: {
               res = addCoupling(1,"C_ALI",3,"H_ALI");
               res = addCoupling(3,"H_ALI",4,"H_ALI");
               res = addCoupling(4,"H_ALI",2,"H_ALI");
               pExp = 0.3;
               break; }
            case 4: {
               res = addCoupling(1,"C_ALI",3,"H_ALI");
               res = addCoupling(3,"H_ALI",4,"H_ALI");
               res = addCoupling(4,"H_ALI",5,"H_ALI");
               res = addCoupling(5,"H_ALI",2,"H_ALI");
               pExp = 0.05;
               break; }
            default: {
               res=0;
               break; }
         }
         break;
      }
      case HCCH7: {
         switch (it) {
            case 1: {
               res = addCoupling(1,"C_ALI",2,"H_ALI");
               pExp = 0.98;
               break; }
            case 2: {
               res = addCoupling(1,"C_ALI",2,"H_ALI");
               res = addCoupling(1,"C_ALI",3,"H_ALI");
               pExp = 0.98;
               break; }
            case 3: {
               res = addCoupling(1,"C_ALI",2,"H_ALI");
               res = addCoupling(1,"C_ALI",4,"C_ALI");
               res = addCoupling(4,"C_ALI",3,"H_ALI");
               pExp = 0.98;
               break; }
            default: {
               res=0;
               break; }
         }
         break;
      }
      case HCCH24: {
         switch (it) {
            case 1: {
               res = addCoupling(1,"C_ALI",2,"H_ALI");
               pExp = 0.98;
               break; }
            case 2: {
               res = addCoupling(1,"C_ALI",2,"H_ALI");
               res = addCoupling(1,"C_ALI",3,"H_ALI");
               pExp = 0.98;
               break; }
            case 3: {
               res = addCoupling(1,"C_ALI",2,"H_ALI");
               res = addCoupling(1,"C_ALI",4,"C_ALI");
               res = addCoupling(4,"C_ALI",3,"H_ALI");
               pExp = 0.98;
               break; }
            case 4: {
               res = addCoupling(1,"C_ALI",2,"H_ALI");
               res = addCoupling(1,"C_ALI",4,"C_ALI");
               res = addCoupling(4,"C_ALI",5,"C_ALI");
               res = addCoupling(5,"C_ALI",3,"H_ALI");
               pExp = 0.8;
               break; }
            case 5: {
               res = addCoupling(1,"C_ALI",2,"H_ALI");
               res = addCoupling(1,"C_ALI",4,"C_ALI");
               res = addCoupling(4,"C_ALI",5,"C_ALI");
               res = addCoupling(5,"C_ALI",6,"C_ALI");
               res = addCoupling(6,"C_ALI",3,"H_ALI");
               pExp = 0.3;
               break; }
            case 6: {
               res = addCoupling(1,"C_ALI",2,"H_ALI");
               res = addCoupling(1,"C_ALI",4,"C_ALI");
               res = addCoupling(4,"C_ALI",5,"C_ALI");
               res = addCoupling(5,"C_ALI",6,"C_ALI");
               res = addCoupling(6,"C_ALI",7,"C_ALI");
               res = addCoupling(7,"C_ALI",3,"H_ALI");
               pExp = 0.3;
               break; }
            default: {
               res=0;
               break; }
         }
         break;
      }
      case CCH: {
         switch (it) {
            case 1: {
               res = addCoupling(1,"H_ALI",2,"C_ALI");
               pExp = 0.98;
               break; }
            case 2: {
               res = addCoupling(1,"H_ALI",2,"C_ALI");
               res = addCoupling(2,"C_ALI",3,"C_ALI");
               pExp = 0.98;
               break; }
            case 3: {
               res = addCoupling(1,"H_ALI",2,"C_ALI");
               res = addCoupling(2,"C_ALI",4,"C_ALI");
               res = addCoupling(4,"C_ALI",3,"C_ALI");
               pExp = 0.8;
               break; }
            case 4: {
               res = addCoupling(1,"H_ALI",2,"C_ALI");
               res = addCoupling(2,"C_ALI",4,"C_ALI");
               res = addCoupling(4,"C_ALI",5,"C_ALI");
               res = addCoupling(5,"C_ALI",3,"C_ALI");
               pExp = 0.3;
               break; }
            case 5: {
               res = addCoupling(1,"H_ALI",2,"C_ALI");
               res = addCoupling(2,"C_ALI",4,"C_ALI");
               res = addCoupling(4,"C_ALI",5,"C_ALI");
               res = addCoupling(5,"C_ALI",6,"C_ALI");
               res = addCoupling(6,"C_ALI",3,"C_ALI");
               pExp = 0.3;
               break; }
            default: {
               res=0;
               break; }
         }
         break;
      }
      default: {
         res=0;
         break;
      }
   }
   return(res);
}

int NMRTopol::found(Graph *)
{
   Coherence *c[DIMENSION];
   ErPeak *p;
   Atom **a;
   int i;
   float prob;
   float minDist=-1.0;

   a = new Atom*[max+1];
   getAtoms(max+1,a);

   /* treat diagonal peaks of 3D spectra */
   if((spec->type->type == CCNOESY) && it == 1) {
					/* diag. peaks of 4D spectra */
      for(i=0;i<dim-2;i++) {
         c[i] = newR(*insertCos,a[i],a[i]->p);
         a[i]->addCo(c[i]);
      }
      c[3] = c[0];
      c[2] = c[1];
   } else if ((spec->type->type == N15TOCSY || spec->type->type == N15NOESY ||
       spec->type->type == HNHB || spec->type->type == C13NOESY || 
       spec->type->type == HCCH7 || spec->type->type == HCCH24 ||
       spec->type->type == CCH || spec->type->type == C13NOED2O) &&
       it == 1) {			/* diag. peaks of 3D spectra */
      for(i=0;i<dim-1;i++) {
         c[i] = newR(*insertCos,a[i],a[i]->p);
         a[i]->addCo(c[i]);
      }
      c[dim-1] = c[dim-2];
   } else {				/* normal case */
      for(i=0;i<dim;i++) {
         c[i] = newR(*insertCos,a[i],a[i]->p);
         a[i]->addCo(c[i]);
      }
   }

   prob = pExp;
   switch (spec->type->type) {
      case NOESY: {
         Noe *noe;
         noe = (Noe *)a[0]->rels.find(a[0]->nr,a[1]->nr,NOE);
         prob *= noe->prob;
         minDist = noe->minDist;
         break;
      }
      case N15NOESY: {
         Noe *noe;
         if(it != 1) {
            noe = (Noe *)a[1]->rels.find(a[1]->nr,a[2]->nr,NOE);
            prob *= noe->prob;
            minDist = noe->minDist;
         }
         break;
      }
      case C13NOESY: {
         Noe *noe;
         if(it != 1) {
            noe = (Noe *)a[1]->rels.find(a[1]->nr,a[2]->nr,NOE);
            prob *= noe->prob;
            minDist = noe->minDist;
         }
         break;
      }
      case C13NOED2O: {
         Noe *noe;
         if(it != 1) {
            noe = (Noe *)a[1]->rels.find(a[1]->nr,a[2]->nr,NOE);
            prob *= noe->prob;
            minDist = noe->minDist;
         }
         break;
      }
      case CCNOESY: {
         Noe *noe;
         if(it != 1) {
            noe = (Noe *)a[1]->rels.find(a[1]->nr,a[2]->nr,NOE);
            prob *= noe->prob;
            minDist = noe->minDist;
         }
         break;
      }
   }

   for(i=0;i<dim;i++) prob = prob*(1.0 - c[i]->pUnass);

   /* add the expected peak to the list of expected peaks */
   if(prob>0.0001) {
      p = newR(*insertPeaks,&c[0],prob,spec,a[0]->frag->type);
      p->minDist = minDist;
      for(i=0;i<dim;i++) c[i]->addPeak(p);
   }

   delete a;
   return 1;
}


void NMRTopol::getAtoms(int nr,Atom **ats)
{
   int i;
   Atom v;

   for(i=0;i<nr;i++) {
      v.nr=i+1;
      ats[i] = ((MapAt *)Atoms.find(v))->partner;
   }
}
