/*
************************************************************************
*
*   interpreter.h -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.interpreter.h
*   SCCS identification       : 1.2
*
************************************************************************
*/
/**************************************************************************/
/*                         interpreter.h                                  */
/*                                                                        */
/* class to call routines:                                                */
/*    defines user variables                                              */
/*    gets values of the user variables                                   */
/*    deciphers command                                                   */
/**************************************************************************/

#ifndef _INTERPRETER_H_
#define _INTERPRETER_H_

#define MAXCOMMANDS 200
#define MAXPARAMS   20

class Envir;
class Command;
class Cmd;
class UserVar;

class Call {
   Command *commands[MAXCOMMANDS];
   int nrCmds;
   void helpSyntax(Cmd &);		/* list commands similar to a     */
					/* typed command                  */
public:
   Call(Envir *);			/* initialize with environment to */
					/* use for interpratation of cmd's*/
   int setVars(UserVar &);		/* Set names of global user vars  */
   void setValues(UserVar &, Envir &);	/* Set values of global user vars */
   int getValues(UserVar &, Envir &);	/* Read values of global user vars*/
   int applyCmd(Envir &,Cmd &);		/* interprete command             */
   void callmacro(char *);		/* call macro specified by the    */
					/* string                         */
};

#endif
