/*
************************************************************************
*
*   frag.h -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.frag.h
*   SCCS identification       : 1.2
*
************************************************************************
*/
/**************************************************************************/
/*                           frag.h                                       */
/*                                                                        */
/* Defines list of fragments                                              */
/**************************************************************************/

#ifndef _FRAG_H_
#define _FRAG_H_

#include "score.h"
#include "element.h"

class Frag : public Element {
public:
   int type;			/* detsination or subfragment             */
   int nrInt;			/* internal fragment number               */
   int nrExt;			/* external number                        */
   char *name;			/* name of the fragment                   */
   Frag(int,int,int,char *,int);/* initialize with type, nrInt, nrExt and */
				/* name and equivNr                       */
   Frag(int n) {nrInt=n;}	/* initialization for searching in list   */
   LiScore scores;		/* list of scores evaluating the ass. of  */
				/* the fragment                           */
   float penDegen;		/* used for scoring: penalty for multiple */
				/* assigned peaks                         */
   float penMiss;		/* used for scoring: penalty for          */
				/* unassigned peaks                       */
   int equivNr;			/* number identifying equivalent ss       */
   int equiv(Frag *);		/* are two fragments equivalent           */
};

class LiFrag : public Index {
public:
   int firstDest,lastDest;	/* first and last destination fragment    */
   LiFrag() : Index(4) {}
   virtual int compare(const Element *,const Element *);
				/* use internal number for comparison     */
};

#endif
