/*
************************************************************************
*
*   frag.C -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.frag.C
*   SCCS identification       : 1.2
*
************************************************************************
*/
/**************************************************************************/
/*                             frag.cc                                    */
/*                                                                        */
/* Defines list of fragments                                              */
/**************************************************************************/

#include "frag.h"
#include "bib.h"

Frag::Frag(int t, int ni, int ne, char *n, int ss)
{
   type = t;
   nrInt = ni;
   nrExt = ne;
   name = n;
   equivNr = ss;
}

int Frag::equiv(Frag *f)
{
   BibAccess bib;

   return bib.equivFrag(name,f->name);
}

int LiFrag::compare(const Element *f1,const Element *f2)
{
   return(((Frag *)f2)->nrInt - ((Frag *)f1)->nrInt);
}
