/*
************************************************************************
*
*   erPeak.h -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.erPeak.h
*   SCCS identification       : 1.2
*
************************************************************************
*/
/**************************************************************************/
/*                           erPeak.h                                     */
/*                                                                        */
/* expected peaks                                                         */
/**************************************************************************/

#ifndef _ERPEAK_H_
#define _ERPEAK_H_

#include "element.h"		/* base class for lists and list elements */
#include "global.h"
#include "imp.h"

/* peak is fixed, assigned, unassigne or rejected */
#define P_FIXED      0
#define P_ASS        1
#define P_UNASS      2
#define P_REJECTED   3

/* whether to use restrictrd selection or free selection for a given peak */
#define O_FREE  0
#define O_RESTR 1

class Peak;		/* measured peaks                         */
class Spectrum;		/* used spectra                           */
class Coherence;		/* coherences for expected peaks          */
class NMRdia;
class PeakWriter;	/* write EASY *.peaks peak list           */
class ErPeakParser;
class Atom;
class Wert;
class AssRequest;
class PeakInfo;

class ErPeak;			/* expected peaks                         */
class LiErPeak;			/* list of expected peaks                 */

class LiErPeak : public Index {
   void init(Iterator &, Spectrum *);
public:
   LiErPeak() : Index(8) {}
   LiErPeak(int s) : Index(s) {}
   ErPeak *start(Iterator &, Spectrum *);
					/* iteration over all peaks belonging */
					/* belonging to given spectrum        */
   ErPeak *next(Iterator &, Spectrum *);
					/* iterate over all peaks belonging to*/
					/* to given spectrum and matching the */
					/* template                           */
   ErPeak *startPars(Iterator &, Spectrum *, char *);
   ErPeak *nextPars(Iterator &, Spectrum *, char *);
   inline ErPeak *start(Iterator &i) {return (ErPeak *)Index::start(i); }
   inline ErPeak *next(Iterator &i) {return (ErPeak *)Index::next(i); }
   inline ErPeak *start() {return (ErPeak *)Index::start(); }
   inline ErPeak *next() {return (ErPeak *)Index::next(); }
   virtual int compare(const Element *,const Element *);
				/* compare according to spectrum number       */
				/* coherences and fragment type               */
   void print(int);
};

class LiEquiv : public LiErPeak {
public:
   LiEquiv() : LiErPeak(8) {}
};

class CycErPeak : public Cycle {/* fifo for expected peaks                    */
public:
   CycErPeak() : Cycle(128) {}
};

class ErPeak : public Element {
   Coherence *liCo[DIMENSION];		/* coherences defining the peak freq. */
   Peak *currAss;			/* current ass. to measured peaks     */
   int pos[DIMENSION];			/* expected position in points in the */
					/* spectrum			      */
   int intensity;			/* intensity at expected position     */
public:
   friend LiErPeak;
   friend NMRdia;
   friend Coherence;
   friend PeakInfo;
   ErPeak();
   ErPeak(Coherence **, float, Spectrum *,int);
   ErPeak(Coherence **, Spectrum *, int);
   Peak **assPop;			/* population of assignments          */
   float *infPop;			/* mutInf of population               */
   int asslinkindex;			/* index of link back from assigned   */
					/* Peak to this ErPeak                */
   float sumPeakP;			/* maximal possible value of mutInf   */
   float pExist;			/* prob. that peak exists             */
   int group;				/* classification according to exist. */
					/* probability                        */
   float pSelect;			/* used to decide which peak should   */
					/* be reassigned next                 */
   float importance;			/* importance of the peak for the     */
					/* assignment                         */
   float mutInf;			/* mutual information of assignment   */
   Imp imp;				/* statistics of made scorings       */
   int type;				/* subfragment or dest. fragment ?    */
   Spectrum *spec;			/* spectrum the peak is belonging to  */
   LiEquiv *liEquiv;			/* equivalent peaks within dest.      */
					/* fragment                           */
   LiErPeak *liPseud;			/* peaks with the same pseudo atom    */
   /* used in optimization routines to keep track of the status of the peak   */
   short status;			/* P_FIXED, P_ASS, P_UNASS, P_REJECTED*/
   short optstat;			/* O_RESTR, O_FREE                    */
   short inRejectList;			/* TRUE ... peak is allready in the   */
					/*          list of rejected peaks    */
   short inInitList;			/* TRUE ... peak is allready in the   */
					/*          list of p. to initialize  */
   short active;			/* FALSE ... peak should not be used  */
   float minDist;			/* minimal observeed distans for NOESY*/
					/* peaks                              */
   /* general access routines */
   float getMutInf(int nr) {return infPop[nr];}
   Coherence *startCo(Iterator &);	/* Iterate over all coherences        */
   Coherence *nextCo(Iterator &);
   Coherence *getCo(Iterator);		/* Get current coherence or 0         */
					/* Iterator over all atoms            */
   Coherence *getCo(int i) {return liCo[i]; }
   Atom *startAt(Iterator &, Iterator &);
   Atom *nextAt(Iterator &, Iterator &);
					/* Iterator over all expected peaks   */
					/* with a common coherence, where the */
					/* decision is set to RESET           */
   ErPeak *startNeighbour(int &, int &,int *);
   ErPeak *nextNeighbour(int &, int &,int *);
					/* Iterator over all expected peaks   */
   ErPeak *startNeighbour(int &, int &);
   ErPeak *nextNeighbour(int &, int &);
   inline Peak *getAss() {return currAss; }
   inline void setAss(Peak *p) {currAss=p; }
					/* Get assignment of the peak         */
   inline Peak *getAss(int i) {return assPop[i]; }
					/* Get ith assignment of the peak     */
   inline void setAss(Peak *p, float f,int i) {assPop[i] = p; infPop[i]=f;}
   int getWriteFreq(Wert *);		/* Get frequencies to write out into  */
					/* peak list                          */
					/* returns number of undefined freq.  */
   int write(PeakWriter &,int,int);	/* Write peak out if it is from the   */
					/* specified fragment type and has    */
					/* less than the indicated number of  */
					/* undefined frequencies              */
   friend ErPeak *newR(LiErPeak &, Coherence **, float, Spectrum *,int);
				       	/* return reference to peak with given*/
				       	/* coherences, spectrum, observe prob.*/
					/* and fragment type                  */
   void resetAss();			/* reset the assignment               */
   void rejectAss();			/* peak could not be assigned         */
   void makeAss(Peak *, const int *, ErPeak *, int);
					/* make assignment to peak            */
					/* adapt coherences                   */
					/* according to given decisions:      */
					/*      RESET: old ass. invalid       */
					/*      ADAPT: old ass. still valid   */
					/* parent peak and number             */
   void statCo(int *);			/* status of the coherences:          */
					/* UNASSIGNED ... no peaks assigned   */
					/* ASSIGNED ..... peaks assigned to   */
   int nrUnAssCo();			/* retuns number of unassigned co's   */
   void updateScoreCo(float *,float *,float *);
					/* calculate and get the local scores */
					/* of the coherences, the average     */
					/* score                              */
   void setSumPeakP();			/* calculate max. poss. mutual Inform.*/
   void freq(int *, Wert *);		/* get frequencies according to status*/
   int range(int *, float *, float *);
					/* get ranges according to status     */
					/* return number of assigned freq.    */
   void expFreq(Wert *);		/* get the expected frequencies       */
   void assFreq(Wert *);		/* get the assigned frequencies       */
   int testDiagUnDef(int *);		/* given status, test whether the peak*/
					/* is diagonal and the corresponding  */
					/* coherences are undefiend           */
   int testSeqRange();			/* retun sequential range of the peak */
					/* 0 ... intra residual peak          */
   void name(char *);			/* return full peak name              */
   int equiv(ErPeak *);			/* are the peaks equivalent           */
					/* calls SQCo::equiv                  */
   void addEquiv(ErPeak *);		/* add peak to list of equiv. peaks   */
   void sortEquiv();			/* sort list of equiv. peaks acc. to  */
					/* size of stretch of equiv resiudes  */
   void addPseudo(ErPeak *);		/* add peak to list of peaks from the */
					/* same pseudo atom                   */
   void printEquiv();			/* print list of equivalent peaks     */
   int pseudIdentical(ErPeak *);	/* using activated pseudo coherences  */
					/* are the peaks yhen identical ?     */
   int floatIdentical(ErPeak *);	/* using floating assignmnets for     */
					/* pseudo coherences                  */
					/* are the peaks then identical ?     */
   int cmpAss(AssRequest &);
				/* check whether a peak conforms to the a */
				/* read in assignment                     */
   void getIntensity();			/* reads intensity from spectral data */
					/* file                               */
   int isPresent();			/* based on the measured intensity and*/
					/* the noise level, is there a peak at*/
					/* the expected position              */
   virtual void print(int);		/* list information about the peak    */
   virtual int match(char *);		/* does peak match template ?         */
};

class PeakDegen : public Element {
public:
   float p;				/* probabilty of degeneracy        */
   ErPeak *peak;			/* partner                         */
   PeakDegen(ErPeak *erPeak, float prob) {peak=erPeak; p=prob;}
   virtual int match(char *n) {return peak->match(n); }
   virtual void iname(char *n) {peak->iname(n); }
};

#endif
