/*
************************************************************************
*
*   envir.h -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.envir.h
*   SCCS identification       : 1.2
*
************************************************************************
*/
/**************************************************************************/
/*                            envir.h                                     */
/*                                                                        */
/* class defining the environment onto which to apply the commands        */
/**************************************************************************/

#ifndef _ENVIR_H_
#define _ENVIR_H_

#include "ss.h"
#include "nmrdia.h"
#include "specTypes.h"
#include "opt.h"
#include "prep.h"
#include "match.h"

class Envir {
public:
   Envir() { strcpy(optPosSel,"NULL");}
   NMRdia dia;			/* atoms, bonds, couplings, coherences,   */
				/* expected peaks                         */
   LiCrit critFrag;		/* list of scoring criteria to use for    */
				/* fragments                              */
   LiCrit critCo;		/* list of scoring criteria to use for    */
				/* coherences                             */
   LiCrit critGlobal;		/* list of global scoring criteria        */
   LiEquivDim filter;		/* filter for preprocessing of spectra    */
   Matching matching;		/* matching of peak lists                 */
   char optPosSel[MAXLINE];	/* selected optimization possibility      */
};

#endif
