/*
************************************************************************
*
*   data_structures.h -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.data_structures.h
*   SCCS identification       : 1.2
*
************************************************************************
*/
/* globale datenstrukturen */


/* n dimensional AVL tree ***************************************************/

struct node_nD
{
   void *element;		/* entry                         */
   char bal;			/* balanced or not               */
   struct node_nD *left;	/* left branch                   */
   struct node_nD *right;       /* right branch                  */
   struct node_nD *next_dim;    /* root of tree of next dimension*/
};


/* data structure containing spectral data *********************************/

typedef struct
{
   int offset[DIMENSION];	/* Offset of subspectrum                   */
   long pos;                    /* Position relative to SEEK_SET           */
} Subspectrum;

typedef struct
{
   char file[80];       	/* Spectral filename                       */
   FILE *fp;	                /* filepointer for 8 bit file              */
   int fd;			/* file descriptor for direct access       */
   FILE *fp_param;              /* filepointer for parameter file          */
   Subspectrum *current_sub;	/* aktuelles Subspektrum                   */
   char type;           	/* Type of spectrum (C, N, T, M, O)        */
   int dim;                     /* Number of dimensions used               */
   float sw[DIMENSION]; 	/* Sweep widths in ppm.                    */
   float max_ppm[DIMENSION];	/* Upper ppm limits.                       */  
   float w0[DIMENSION];		/* Spectrometer frequencies in MHz.        */
   int size[DIMENSION];		/* Size of spectrum in points              */
   int sub_size[DIMENSION];	/* Size of subspectra                      */
   int sub_perm[DIMENSION];     /* Permutation of subspectra               */
   int folding[DIMENSION];	/* Folding of the spectrum                 */
   char state;			/* State ...                               */
   struct node_nD *subs;        /* Source of tree of subspectra            */
                                /*      ordering key left offset           */
   int file_type;		/* Use 16 or 8 bit data                    */ 
   int view_perm[DIMENSION];	/* Permutation for projection into view    */
   long increment[DIMENSION];	/* increment in file for each dimension    */
   int permut[DIMENSION];       /* Permutation                             */
   char *flags[DIMENSION];	/* used to mark data points to read        */
   unsigned char *col;          /* coloum used for reading                 */
}
Spec_Param_Data;

