/*
************************************************************************
*
*   constants.h -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.constants.h
*   SCCS identification       : 1.2
*
************************************************************************
*/
/* Global constants */

#define DIMENSION 4
#define MAX_STR 200  /* Length of general purpose strings   */
#define TRUE 1
#define FALSE 0
#define FILE3D_8  4  /* Format of 3D version, 8 bit         */
#define FILE3D_16 5  /* Format of 3D version, 16 bit        */
#define MAX_WIDTH   	 8192
#define MAX_POS 47
#define MIN_POS 1
#define MAX_NEG 48
#define MIN_NEG 95

/* types of foding */

#define TPPI 1
#define RSH  2

/* types of requests */

#define SP_DIM 1     /* Affect spectral dimension            */
#define SP_SIZE 2    /* Affect size of spectrum              */
#define SP_NAME 3    /* Affect name of spectrum              */
#define SP_FTYPE 4   /* Affect file type (i.e. 8 or 16 bit)  */
#define SUB_SIZE 5   /* Affect submatrix size of spectrum    */
#define SUB_PERM 6   /* Affect submatrix permutation         */
#define SP_TYPE 7    /* Affect type of spectrum (i.e. C,N,..)*/
#define SP_SW 8      /* Affect sweep width                   */
#define SP_MAXPPM 9  /* Affect upper ppm limits              */
#define SP_SFO1 10   /* Affect spectrometer ferquency        */
#define SP_ALL 11    /* Affect all parameters of the spectrum*/
#define SP_FOLDT 12  /* Affect folding type of spectrum      */

/* Global macros */

#define MAX(i,j) (j > i) ? j : i   
