/*
************************************************************************
*
*   cmdline.h -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /home/cb/garant-1.0/src/SCCS/s.cmdline.h
*   SCCS identification       : 1.3
*
************************************************************************
*/
/**************************************************************************/
/*                           cmdline.h                                    */
/*                                                                        */
/* class to read commands and global variables from a batch file          */
/* interpreter that reads from stdio or files.                            */
/*                                                                        */
/* a command is a string suplemented with parameters                      */
/* a global variable has aname and a value of type string                 */
/**************************************************************************/

#ifndef _CMDLINE_H_
#define _CMDLINE_H_

/* definitions to use fortran code ****************************************/

#define MAX_LINE 250
#define MAX_PAR  30
#define MAX_VAR 500
#define MAX_VAR_NAME 32
#define MAX_DEF_NAME 250
extern char HELP_PATH[];
extern char INITMACRO[];
#define EXTENSION    ".gar"


/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
/* ATENTION: call of Cmd:next() changes contents of UserVar               */
/*           UserVar has to be set before first call to Cmd:next()        */
/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/


class Cmd {
   static int npath;			/* number of paths defined        */
   static int maxp;			/* maximal number of parameters   */
   static char extension[MAX_LINE];	/* extension for macros	          */
   static char initmacro[MAX_LINE];	/* macro called for initialization*/
   static char hlpp[MAX_LINE];		/* path for help files            */
public:
   Cmd() {}
   char cmd[MAX_LINE];			/* command                        */
   char param[MAX_PAR][MAX_LINE];	/* parameters for the command     */
   int nparam;				/* number of parameters           */
   static int mode;			/*  1..try to call macro          */
					/*  0..get next command           */
					/*  2..try to call macro, don't   */
					/* print error messages           */
   void start() {mode = 0;}		/* initialization                 */
   void next();				/* read next command              */
};

class UserVar {
public:
   UserVar() {nrSet = 0; max = MAX_VAR; }
   static int nrSet;			/* nr. of vars set by the program */
   static int max;			/* max. allowed number of vars    */
   static char var[MAX_VAR][MAX_VAR_NAME];/* names of the global variables*/
   static char vardef[MAX_VAR][MAX_DEF_NAME];/* value of the variables    */
   static int error;			/* signals error to batch intrpr. */
   static int reonly[MAX_VAR];		/* TRUE -> variable = constant    */
   int init(const int);			/* initialize global vars         */
};

class MacroCall {
public:
   MacroCall() {}
   static char cmd[2*MAX_LINE];
};

#endif
