/*
************************************************************************
*
*   cmdline.C -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.cmdline.C
*   SCCS identification       : 1.2
*
************************************************************************
*/

/* C libraries */

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>

/* Global variables and classes */

#include "global.h"

/* Definition module */

#include "cmdline.h"

/* paths to use */
char HELP_PATH[]=BASEDIR "/help/";
char INITMACRO[]=BASEDIR "/macro/init";

/* static members */
    int Cmd::npath;			/* number of paths defined        */
    int Cmd::maxp;			/* maximal number of parameters   */
    int Cmd::mode;			/*  1..try to call macro          */
					/*  0..get next command           */
					/*  2..try to call macro, don't   */
					/* print error messages           */
    char Cmd::extension[MAX_LINE];/* extension for macros	          */
    char Cmd::initmacro[MAX_LINE];	/* macro called for initialization*/
    char Cmd::hlpp[MAX_LINE];		/* path for help files            */

    int UserVar::nrSet;			/* nr. of vars set by the program */
    int UserVar::max;			/* max. allowed number of vars    */
    char UserVar::var[MAX_VAR][MAX_VAR_NAME];
					/* names of the global variables  */
    char UserVar::vardef[MAX_VAR][MAX_DEF_NAME];
					/* value of the variables         */
    int UserVar::error;			/* signals error to batch intrpr. */
    int UserVar::reonly[MAX_VAR];	/* TRUE -> variable = constant    */

    char MacroCall::cmd[2*MAX_LINE];


/* instances of the command line interpreter and the global vars. to use  */
/* with the FORTRAN routines                                              */

//static Cmd command;			/* commands from the user         */
static UserVar userVar;			/* variables set by the user      */

/* interfaces external fortran routines */

extern "C" {
   void getcmd_(int *,char *,char [MAX_PAR][MAX_LINE],int *,int *,
                char *, char *,char *,int,int,int,int,int);
				/* read the next command           */
				/* calls sysvar_ and expvar_       */
				/* PARAMETER: mode 1..try to call macro    */
				/*	           0..get next command     */
				/* 	      command			   */
				/*	      parameter			   */
				/*	      nr. of parameters            */
				/*	      max nr. of parameters        */
				/*	      extension for macro files    */
				/*	      directory for help files	   */
				/* 	      name of initialization macro */
   void sysvar_(char [MAX_VAR][MAX_VAR_NAME], char[MAX_VAR][MAX_DEF_NAME], 
               int [MAX_VAR], int *, int*, int*, int, int);
					/* set the variables of the FORTRAN*/
					/* command line interpreter        */
   void expvar_(char [MAX_VAR_NAME], char [MAX_DEF_NAME], int*, int, int);
					/* copy the variables from the FORT*/
					/* RAN cmd line interpreter into   */
					/* the global instance of UserVar  */
   void getlin_(char [],int);		/* pass line of input to command   */
					/* line interpreter                */
   extern void f_init();
}

/* converts fortran strings into C strings */

void ffStripStr(char *,int);
void ffFillStr(char *,int);

/* Implementation of the classes Cmd and UserVar ****************************/

void Cmd::next()
{
   int i;

   strcpy(extension,EXTENSION); ffFillStr(extension,MAX_LINE);
   strcpy(initmacro,INITMACRO); ffFillStr(initmacro,MAX_LINE);
   strcpy(hlpp,HELP_PATH);      ffFillStr(hlpp,MAX_LINE);
   maxp = MAX_PAR;

   getcmd_(&mode,cmd, param, &nparam, &maxp,extension, hlpp, initmacro, 
           MAX_LINE,MAX_LINE,MAX_LINE,MAX_LINE,MAX_LINE);
   ffStripStr(cmd,MAX_LINE);
   for(i=0;i<nparam;i++) ffStripStr(param[i],MAX_LINE);
}

int UserVar::init(const int nr)
{
   if(nr > MAX_VAR) {
      nrSet = 0;
      return(0);
   } else {
      nrSet = nr;
      error = 0;
      return(1);
   }
}

/* Routines to interface FORTRAN *********************************************/

void ffStripStr(char *str,int max)
{
   int i;
   for(i=max-2;i>=0 && str[i]==' ';i--);
   if(str[i]==' ') str[i] = 0;
   else str[i+1] = 0;
}

void ffFillStr(char *str,int max)
{
   int i;
   for(i=strlen(str);i<max;i++) str[i]=' ';
}

void sysvar_(char var[MAX_VAR][MAX_VAR_NAME],
             char vardef[MAX_VAR][MAX_DEF_NAME],
             int reonly[MAX_VAR], int *nvar, int *nsvar, int *haveerr, 
             int lenVar, int lenDef)
{
   int i;
   static int nrSet = 0;

   if(nrSet == 0) {
      nrSet = userVar.nrSet;
      *nvar = nrSet;
      *nsvar= *nvar;
      for(i=0;i<nrSet;i++) {
         strcpy(var[i],userVar.var[i]); ffFillStr(var[i],lenVar);
         strcpy(vardef[i],userVar.vardef[i]); ffFillStr(vardef[i],lenDef);
         reonly[i] = userVar.reonly[i];
      }
      *haveerr = 0;
   } else {
      for(i=0;i<nrSet;i++) {
         strcpy(vardef[i],userVar.vardef[i]); ffFillStr(vardef[i],lenDef);
      }
      *haveerr = userVar.error;
   }
}

void expvar_(char var[MAX_VAR_NAME],
            char vardef[MAX_DEF_NAME], int *haveerr, 
            int lenVar, int lenDef)
{
   int i;

   ffStripStr(var,lenVar);
   ffStripStr(vardef,lenVar);
   for(i=0;i<userVar.nrSet;i++) {
      if(strcmp(userVar.var[i],var) == 0) {
         strcpy(userVar.vardef[i],vardef);
         break;
      }
   }
   ffFillStr(var,lenVar);
   ffFillStr(vardef,lenDef);
   *haveerr = userVar.error;
}

void getlin_(char line[],int lenLine)
{
   MacroCall call;

   if(strlen(call.cmd) > 0) {
      strcpy(line,call.cmd);
      call.cmd[0] = '\0';
   } else {
      gets(line);
   }
   ffFillStr(line,lenLine);
}

