/*
************************************************************************
*
*   choice.h -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.choice.h
*   SCCS identification       : 1.2
*
************************************************************************
*/
/**************************************************************************/
/*                              choice.h                                  */
/*                                                                        */
/* random choice of a peak                                                */
/**************************************************************************/

#ifndef _CHOICE_H_
#define _CHOICE_H_

#define MAXPEAKS 2000			/* Max number of peaks in a choice    */

class Peak;
class ErPeak;

/* Selection list of measured peaks  */
class ChoicePeak {
   float ptot;				/* sum of all scores             */
   float ploc[MAXPEAKS];		/* score of corresponding peak   */
   float psum[MAXPEAKS];		/* summed up scores              */
   Peak *peaks[MAXPEAKS];		/* peaks                         */
   ErPeak *erPeaks[MAXPEAKS];
   int parents[MAXPEAKS];
   int n;				/* number of peaks               */
public:
   ChoicePeak() {}
   int insert(Peak *, float, ErPeak *, int);
					/* add possible peak to list     */
   Peak *select(ErPeak *&, int &);	/* select from list              */
   void reset();			/* reset list of possibilities   */
};

#endif
