/*
************************************************************************
*
*   choice.C -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.choice.C
*   SCCS identification       : 1.2
*
************************************************************************
*/
/**************************************************************************/
/*                            choice.cc                                   */
/*                                                                        */
/* random choice of a peak                                                */
/**************************************************************************/

#include "choice.h"
#include <stdlib.h>

int ChoicePeak::insert(Peak *peak, float p_local, ErPeak *erPeak, int parent)
{
   if(n>=MAXPEAKS) return(0);

   if(p_local == 0.0) return(1);

   peaks[n] = peak;
   ploc[n] = p_local;
   ptot += p_local;
   psum[n] = ptot;
   parents[n] = parent;
   erPeaks[n] = erPeak;
   n++;
   return(1);
}

void ChoicePeak::reset()
{
   ptot = 0.0;
   n = 0;
}

/* random selection of a peak */
Peak *ChoicePeak::select(ErPeak *&erPeak, int &parent)
{
   float random,dif;
   int i,j,cur;

   random = (float)drand48() * ptot;

   if(n==0) {
      return(0);
   }

   i=0;
   j=n-1;
   cur=0;
   dif = 1.0;
   while(i<=j && dif != 0.0 ) {
      cur = (i+j)/2;
      dif = psum[cur] - random;
      if (dif < 0) i=cur+1;
      else if (dif < ploc[cur]) dif = 0.0;
      else j=cur-1;
   }

   parent = parents[cur];
   erPeak = erPeaks[cur];
   return(peaks[cur]);
}

