/*
************************************************************************
*
*   atom.h -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : 95/09/15
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.atom.h
*   SCCS identification       : 1.2
*
************************************************************************
*/
/**************************************************************************/
/*                             atom.h                                     */
/*                                                                        */
/* class to define atoms and list of atoms                                */
/**************************************************************************/

#ifndef _ATOM_H_
#define _ATOM_H_

#include "global.h"			/* global constants                  */
#include "element.h"			/* base classes Element and Index    */
#include "wert.h"			/* general measured value            */
#include "rel.h"			/* relations between atoms           */

class Coherence;			/* coherences                        */
class AtParser;			/* find atoms corresponding to name  */
class Frag;

class Atom;				/* Atom                              */
class LiAtom;				/* List of atoms                     */

class Coord : public Element {
public:
   float coord[3];
   int idStructure;
   Coord(float *c,int id);
   Coord(int id) {idStructure=id;}
};

class LiCoord : public Index {
public:
   LiCoord(): Index(10) {}
   virtual int compare(const Element *c1,const Element *c2);
};

class LiAtom : public Index {
public:
   LiAtom() : Index(512) {}
   LiAtom(int n) : Index(n) {}
   virtual int compare(const Element *,const Element *);
					/* use internal number for comparison*/
   void setScore(char *,float);		/* set p for all atoms matching templ*/
   void setPseudCor(char *,float);	/* define psudo atom correction      */
   void print(int);			/* print list of atoms               */
};

class OrdLiAtom : public Index {
public:
   OrdLiAtom(LiAtom &);
   virtual int compare(const Element *,const Element *);
   int compare(int,char *,int,const Atom *);
   Atom *find(int,char *,int);	        /* find coherence given external     */
					/* fragment number, name and type    */
};

class Atom : public Element {
   Coherence *liCo[MAX_CO_PER_ATOM];	/* list of coherences                */
   int nrCos;				/* number of coherences              */
public:
   int nr;				/* internal number of the atom       */
   float p;				/* probability to observe the atom   */
   Frag *frag;				/* reference into fargment list      */
   Wert measF;				/* shift calculated using peak assig.*/
   Wert w;				/* staisticaly expected shift        */
   char atype[MAXNAME];			/* type of the atom                  */
   char name[MAXNAME];			/* name of the atom                  */
   float pseudoCorr;			/* pseudo atom correction for calc.  */
					/* distances                         */
   LiCoord coords;			/* list of coordinates               */
   LiRel rels;				/* relations involving this atom     */
   LiAtom pseud;			/* list of atoms only differing in   */
					/* their stereo chemistry            */
   Atom(int,char *,char *,Wert, float, Frag *);
					/* Initialisierung mit ICEPP library */
					/* with nr,name,atype,p,w,frag       */
   Atom(int,char *,char *);		/* Initialisierung with nr,name,     */
					/* atype                             */
   Atom(int);				/* Initialisierung nur mit nummer    */
   Atom();
   ~Atom() {rels.del(); }
   Coherence *getCo() { if(nrCos>0) return(liCo[0]); else return 0; }
   void addCo(Coherence *);		/* add a new coherence to the list   */
   int sameSsPos(Atom *);		/* are the two atom ss equivalent ?  */
   void fullname(char *,char *,int &);	/* return the full name of the atom  */
   void shortname(char *);		/* return only first name i.e. HA    */
   void resnumber(int &);		/* return residue number             */
   void fullNameGet(char *);		/* return full name: HA(ALA 2)       */
   void shortNameGet(char *);		/* return short name: HA 2           */
   void nameSet(char *);		/* set name as used for EASY *.prot  */
					/* file                              */
   int equiv(Atom *);			/* are the two atoms equivalent      */
					/* calls BibAccess::equivAt          */
   int proton();			/* is the atom a proton              */
   virtual void print(int);		/* print info about atom             */
   virtual int match(char *);		/* does atom match template ?        */
};


#endif
