h09177
s 00000/00000/00111
d D 1.2 95/09/15 13:39:11 cb 2 1
c program renamed into garant
e
s 00111/00000/00000
d D 1.1 95/03/03 14:10:52 cb 1 0
c date and time created 95/03/03 14:10:52 by cb
e
u
U
f e 0
t
T
I 1
/*
************************************************************************
*
*   %M% -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : %E%
*   Pathname of SCCS file     : %P%
*   SCCS identification       : %I%
*
************************************************************************
*/
/**************************************************************************/
/*                           wert.h                                       */
/*                                                                        */
/* Class defining a general value                                         */
/*                                                                        */
/**************************************************************************/

#include <math.h>
#include <stdlib.h>
#include "wert.h"
#include "log.h"
#include "global.h"

/* gaussian random number generator:                                        */
/* from: Numerical Recipes in C, W. H. Press et al., Cambridge 1988, p. 217 */
float gasdev()
{
   static int iset = 0;
   static float gset;
   float fac,r,v1,v2;

   if(iset==0) {
      do {
         v1=2.0 * (float)drand48() -1.0;
         v2=2.0 * (float)drand48() -1.0;
         r=v1*v1+v2*v2;
      }
      while(r >= 1.0 || r == 0.0);
      fac=sqrt(-2.0*log(r)/r);
      gset=v1*fac;
      iset=1;
      return v2*fac;
   } else {
      iset = 0;
      return gset;
   }
}

Wert::Wert(float f, float d)
{
   x=f; 
   v=d;
}


float Wert::random()
{
   return(x + v * gasdev());
}

float Wert::random(float factor)
{
   return(x + factor * v * gasdev());
}

Mean::Mean()
{
   n=0;
   x=0.0;
   sum=0.0;
   v=0.0;
   set=0;
}

Mean::Mean(float v, float d)
{
   n=1;
   x=v;
   sum=v;
   v=d;
   set=0;
}

void Mean::fix()
{
   if(n<=1) set=1;
}

void Mean::add(float v)
{
   n++;
   sum += v;
   if(!set || n==1) x = sum / n;
}

void Mean::sub(float v)
{
   n--;
   sum -= v;
   if(n==0) {sum = 0.0;set=0;}
}
E 1
