h13204
s 00000/00000/00068
d D 1.2 95/09/15 13:39:09 cb 2 1
c program renamed into garant
e
s 00068/00000/00000
d D 1.1 95/03/03 14:10:40 cb 1 0
c date and time created 95/03/03 14:10:40 by cb
e
u
U
f e 0
t
T
I 1
/*
************************************************************************
*
*   %M% -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : %E%
*   Pathname of SCCS file     : %P%
*   SCCS identification       : %I%
*
************************************************************************
*/
/**************************************************************************/
/*                            ss.h                                        */
/*                                                                        */
/* class to load and generate spin systems                                */
/**************************************************************************/

#ifndef _SS_H_
#define _SS_H_

#include "atom.h"			/* list of atoms                     */
#include "frag.h"			/* list of fragments                 */


/* Graph *********************************************************************/

class Graph {
public:
   LiAtom Atoms;			/* list of atoms                     */
   LiFrag Frags;			/* list of all valid fragments       */
};
   
/* Structure *****************************************************************/

class Structure : public Graph {
   int atomLoad();			/* load all the defined atoms        */
   int bondLoad();			/* load all the defined bonds        */
   int fragLoad();
public:
   int fragAdd(char *,int);		/* add a sequence of fragments to    */
					/* library                           */
					/* returns TRUE if success           */
   void loadCoord(char *, int);		/* load subfrag. or dest. frag. atom */
					/* coordinates from given file       */
   void listAt(char *);			/* list the atoms                    */
   int bond(int,int);			/* add bond between atoms with given */
					/* atom numbers                      */
};

/* Spin System ****************************************************************/

class Ss: public Structure {
public:
   void jMake();
   void statNOEMake(int f=1,int l=0);
   void distNOEMake(int,float,float,int);
};

#endif
E 1
