h47103
s 00000/00000/01207
d D 1.4 95/09/15 13:39:06 cb 4 3
c program renamed into garant
e
s 00094/00001/01113
d D 1.3 95/07/10 13:41:48 cb 3 2
c new criterion: assigned to correct residue, crit corres
e
s 00041/00010/01073
d D 1.2 95/03/14 10:33:24 cb 2 1
c report of percentage of correct HN, HA, ..., coherences
e
s 01083/00000/00000
d D 1.1 95/03/03 14:10:27 cb 1 0
c date and time created 95/03/03 14:10:27 by cb
e
u
U
f e 0
t
T
I 1
/*
************************************************************************
*
*   %M% -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : %E%
*   Pathname of SCCS file     : %P%
*   SCCS identification       : %I%
*
************************************************************************
*/
/**************************************************************************/
/*                            score.cc                                    */
/*                                                                        */
/* Defines scoring criteria and score s                                   */
/**************************************************************************/

#include <string.h>
#include <stdio.h>
#include <math.h>
#include "erPeak.h"
#include "atom.h"
#include "wert.h"
#include "specTypes.h"
#include "atom.h"
#include "frag.h"
#include "score.h"
#include "co.h"
#include "parser.h"

int nrCrits=0;			/* number of defined criteria             */
char com[MAXLINE];		/* storage of one comment                 */

class CritMap : public Crit {	/* criteria generating the mapping into   */
				/* subfragments                           */
public:
   CritMap(char *n) : Crit(n) {}
				/* initialize with name                   */
   virtual char decision(Score *);
				/* character reporting the quality        */
   virtual char *comment(Score *);
				/* comment describing the assignment       */
   virtual int uErPeak() {return 1;}
				/* whether to update with expected peaks   */
   virtual void upErPeak(Score *, ErPeak *, Frag *, Coherence *);
				/* update score with expected peak         */
};

class CritCorrect : public Crit {/* criteria counting correct co.         */
				/* assignments                            */
I 2
D 3
   char templ[MAXLINE];		/* template to match                      */
E 3
E 2
public:
I 3
   char templ[MAXLINE];		/* template to match                      */
E 3
   int cntOk, cntTot;
D 2
   CritCorrect(char *n) : Crit(n) {}
				/* initialize with name                   */
E 2
I 2
   CritCorrect(char *n, char *t) : Crit(n) {strcpy(templ,t); }
				/* initialize with name and template       */
E 2
   virtual char decision(Score *);
D 2
				/* character reporting the quality        */
E 2
I 2
				/* character reporting the quality         */
E 2
   virtual char *comment(Score *);
				/* comment describing the assignment       */
   virtual int uErPeak() {return 1;}
				/* whether to update with expected peaks   */
   virtual void upErPeak(Score *, ErPeak *, Frag *, Coherence *);
				/* update score with expected peak         */
   virtual void initSums();	/* sum up scores and print out result      */
   virtual void addSum(Score *);
   virtual char *printSum();
};

I 3
class CritCorRes : public CritCorrect
{				/* criteria counting correct spin sys. co.*/
				/* assignments                            */
public:
   CritCorRes(char *n, char *t) : CritCorrect(n,t) {}
				/* initialize with name                   */
   virtual void upErPeak(Score *, ErPeak *, Frag *, Coherence *);
				/* update score with expected peak         */
   virtual char *printSum();
};


E 3
class CritCorrSS : public CritCorrect
{				/* criteria counting correct spin sys. co.*/
				/* assignments                            */
public:
D 2
   CritCorrSS(char *n) : CritCorrect(n) {}
E 2
I 2
   CritCorrSS(char *n) : CritCorrect(n,"") {}
E 2
				/* initialize with name                   */
   virtual void upErPeak(Score *, ErPeak *, Frag *, Coherence *);
				/* update score with expected peak         */
   virtual char *printSum();
};

class ScoreCorrect : public Score{
public:
   ScoreCorrect(Crit *c) : Score(c), cos_correct(10), cos_assigned(10) {}
   LiCo cos_correct;		/* correct assigned coherences            */
   LiCo cos_assigned;		/* assigned coherences                    */
   virtual float value();	/* value of the score                     */
   virtual void reset();	/* reset the scoring                      */
};

class CritOvrlp : public CritMap {
				/* criteria generating the mapping into   */
				/* subfragments                           */
public:
   CritOvrlp(char *n) : CritMap(n) {}
   virtual void upErPeak(Score *, ErPeak *, Frag *, Coherence *);
				/* update score with expected peak         */
};

class ScoreMap : public Score{
public:
   ScoreMap(Crit *c) : Score(c) {}
   LiFrag frags;		/* possible fragments                     */
   virtual float value();	/* value of the score                     */
   virtual void reset();	/* reset the scoring                       */
};

class CritMapCo : public Crit { /* criteria generating the mapping into   */
				/* subfragment coherences                 */
public:
   CritMapCo(char *n) : Crit(n) {}
				/* initialize with name                   */
   virtual char decision(Score *);
				/* character reporting the quality        */
   virtual char *comment(Score *);
				/* comment describing the assignment       */
   virtual int uErPeak() {return 1;}
				/* whether to update with expected peaks   */
   virtual void upErPeak(Score *, ErPeak *, Frag *, Coherence *);
				/* update score with expected peak         */
};

class CritOvrlpCo : public CritMapCo {
				/* criteria generating the mapping into   */
				/* subfragment coherences                 */
public:
   CritOvrlpCo(char *n) : CritMapCo(n) {}
   virtual void upErPeak(Score *, ErPeak *, Frag *, Coherence *);
				/* update score with expected peak         */
};

class ScoreMapCo : public Score  {
public:
   ScoreMapCo(Crit *c) : Score(c), cos(8) {}
   LiCo cos;			/* possible fragments                     */
   virtual float value();	/* value of the score                     */
   virtual void reset();	/* reset the scoring                       */
};

class CritDegen : public Crit {	/* criteria reporting on                  */
				/* degenerated coherences                 */
   float tol;			/* tolerance in ppm                       */
public:
   CritDegen(char *n, float t) : Crit(n) {tol = t;}
				/* initialize with name and tolerance     */
   virtual char decision(Score *);
				/* character reporting the quality        */
   virtual char *comment(Score *);
				/* comment describing the assignment       */
   virtual int uOrdLiCo() {return 1;}
				/* whether to update with coherence list   */
				/* ordered by chemical shift               */
   virtual void upOrdLiCo(OrdLiCo &, Iterator);
				/* update with list of ordered coherences  */
   virtual int acceptCo(Coherence *, Coherence *) {return 1; }
				/* whether to use the pair of coherences   */
};

class CritDegIntra : public CritDegen {	/* criteria reporting on          */
				/* degenerated coherences                 */
   float tol;			/* tolerance in ppm                       */
public:
   CritDegIntra(char *n, float t) : CritDegen(n,t) {}
   virtual int acceptCo(Coherence *, Coherence *);
				/* whether to use the pair of coherences   */
};

class CritDegInter : public CritDegen {	/* criteria reporting on          */
				/* degenerated coherences                 */
   float tol;			/* tolerance in ppm                       */
public:
   CritDegInter(char *n, float t) : CritDegen(n,t) {}
   virtual int acceptCo(Coherence *, Coherence *);
				/* whether to use the pair of coherences   */
};

class ScoreDegen : public Score{
public:
   ScoreDegen(Crit *c) : Score(c), cos(4) {}
   LiCo cos;			/* degenerated co's                       */
   virtual float value();	/* value of the score                     */
   virtual void reset();	/* reset the scoring                       */
};

class CritErPeak : public Crit{ /* criteria using a subset of expected    */
				/* peaks                                  */
public:
   CritErPeak(char *n) : Crit(n) {}
				/* initialize with name                   */
   virtual int accept(ErPeak *,int);
				/* should the expected peak be used for   */
				/* fragment with given external number    */
   virtual char decision(Score *);
				/* character reporting the quality        */
   virtual char *comment(Score *);
				/* comment describing the assignment       */
   virtual int uErPeak() {return 1;}
				/* whether to update with expected peaks   */
   virtual void upErPeak(Score *, ErPeak *, Frag *, Coherence *);
				/* update score with expected peak         */
};

class ScoreErPeak : public Score{
public:
   ScoreErPeak(Crit *c) : Score(c), tot(0.0), sum(0.0), cur(0) {}
   float tot;			/* total possible score                   */
   float sum;			/* actual score                           */
   ErPeak *cur;			/* current peak                           */
   virtual float value();	/* value of the score                     */
   virtual void reset();	/* reset the scoring                       */
};

class CritII : public CritErPeak {
				/* criteria to report about intra resp.   */
				/* interresidual peaks                    */
   int low,up;			/* allowed difference in residue numbers  */
				/* [0,0] ... intraresidual		  */
				/* [0,1] ... intraresidual and sequential */
public:
   CritII(char *,int,int);
				/* initialize with allowed differneces    */
   virtual int accept(ErPeak *,int);
				/* should the expected peak be used for   */
				/* fragment with given external number    */
};

class CritTempl : public CritErPeak {
				/* criteria to report about intra resp.   */
				/* interresidual peaks                    */
   char templ[MAXLINE];		/* template to match                      */
public:
   CritTempl(char *,char *);
				/* initialize with allowed differneces    */
   virtual int accept(ErPeak *,int);
				/* should the expected peak be used for   */
				/* fragment with given external number    */
};

int CritErPeak::accept(ErPeak *, int)
{
   return 1;
}

int CritII::accept(ErPeak *peak, int nr)
{
   Atom *at;
   Iterator i,j;
   int dif;
   int valid = 0;
   int invalid = 0;

   at = peak->startAt(i,j);
   while(at != 0) {
      dif = at->frag->nrExt - nr;
      if(dif != 0 && (dif< low || dif>up)) invalid=1;
      if(dif >= low && dif <= up) valid=1;
      at = peak->nextAt(i,j);
   }
   return (valid && !invalid);
}

int CritTempl::accept(ErPeak *peak, int nr)
{
   int valid = 0;
   Parser pars;
   char str[MAXLINE];
   int tb,ib;

   peak->name(str);
   valid = pars.peak(templ,0,tb,str,0,ib,nr);
   valid &= (strlen(str) == ib);

   return valid;
}

Crit::Crit(char *n)
{
   strncpy(name,n,MAXLINE-10);
   sprintf(fullname,"%d %s",nrCrits,name);
   nr = nrCrits;
   thresh1 = 0.4;
   thresh2 = 0.7;
   writeCom = 0;
   nrCrits++;
}

CritII::CritII(char *n, int l, int u) : CritErPeak(n)
{
   low =l;
   up = u;
}

CritTempl::CritTempl(char *n, char *t) : CritErPeak(n)
{
   strcpy(templ,t);
}

char Crit::decision(Score *)
{
   return '.';
}

char CritErPeak::decision(Score *score)
{
   char res;
   float q;

   if(((ScoreErPeak *)score)->tot == 0.0) {
      res = '0';
   } else {
      q = ((ScoreErPeak *)score)->sum / ((ScoreErPeak *)score)->tot;
      if(q < thresh1) res = '*';
      else if(q < thresh2) res = '-';
      else res = '.';
   }
   return res;
}

char CritMap::decision(Score *score)
{
   char res;
   int n;

   n = ((ScoreMap *)score)->frags.getn();
   if(n==0) res = '-';
   else if (n==1) res = '.';
   else if (n>1)  res = '+';

   return res;
}

char CritCorrect::decision(Score *score)
{
   char res;
   int ok;
   int tot;
   float q;

   ok = ((ScoreCorrect *)score)->cos_correct.getn();
   tot =((ScoreCorrect *)score)->cos_assigned.getn();
   if(tot==0) {
      res = '0';
   } else {
      q = (float)ok / (float)tot;
      if(q < thresh1) res = '*';
      else if(q < thresh2) res = '-';
      else res = '.';
   }
   return res;
}

char CritMapCo::decision(Score *score)
{
   char res;
   int n;

   n = ((ScoreMapCo *)score)->cos.getn();
   if(n==0) res = '-';
   else if (n==1) res = '.';
   else if (n>1)  res = '+';

   return res;
}

char CritDegen::decision(Score *score)
{
   char res;
   int n;

   n = ((ScoreDegen *)score)->cos.getn();
   if(n==0) res = '.';
   else if (n>0) res = '+';

   return res;
}

void ScoreMap::reset()
{
   frags.remove();
}

void ScoreCorrect::reset()
{
   cos_correct.remove();
   cos_assigned.remove();
}

void ScoreMapCo::reset()
{
   cos.remove();
}

void ScoreErPeak::reset()
{
   tot = 0.0;
   sum = 0.0;
   cur = 0;
}

void ScoreDegen::reset()
{
   cos.remove();
}

float Score::value()
{
   return 0.0;
}

float ScoreErPeak::value()
{
   if(tot == 0.0) return 0.0;
   else return sum/tot;
}

float ScoreMap::value()
{
   return (float)frags.getn();
}

float ScoreCorrect::value()
{
   int ok,tot;
   float q;

   ok = cos_correct.getn();
   tot =cos_assigned.getn();
   if(tot==0) {
      q=0;
   } else {
      q = (float)ok / (float)tot;
   }
   return q;
}

float ScoreMapCo::value()
{
   return (float)cos.getn();
}

float ScoreDegen::value()
{
   return (float)cos.getn();
}

char *Crit::comment(Score *s)
{
   sprintf(com,"%d) %6.4g",nr,s->value());

   return com;
}

char *CritErPeak::comment(Score *score)
{
   if(((ScoreErPeak *)score)->tot == 0) {
      sprintf(com,"%d) ----- ",nr);
   } else {
      sprintf(com,"%d) %6.4g",nr,
         ((ScoreErPeak *)score)->sum / ((ScoreErPeak *)score)->tot);
   }
   return com;
}

char *CritCorrect::comment(Score *score)
{
   int ok,tot;
   float q;

   ok = ((ScoreCorrect *)score)->cos_correct.getn();
   tot =((ScoreCorrect *)score)->cos_assigned.getn();
   if(tot==0) {
      sprintf(com,"%d) ----- ",nr);
   } else {
      q = (float)ok / (float)tot;
      sprintf(com,"%d) %6.0f",nr,q*100.0);
   }
   return com;
}

char *CritMap::comment(Score *score)
{
   Frag *frag;
   LiFrag &list = ((ScoreMap *)score)->frags;
   char name[MAXLINE];

   if(list.getn() == 0) {
      return 0;
   } else {
      sprintf(com,"%d)",nr);
      frag = (Frag *)list.start();
      while(frag != 0 && strlen(com) < MAXLINE - 30) {
         sprintf(name,"  %s %d",frag->name,frag->nrExt);
         strcat(com,name);
         frag = (Frag *)list.next();
      }
      if(frag != 0) strcat(com," ...");
   }
   return com;
}

char *CritMapCo::comment(Score *score)
{
   Coherence *co;
   LiCo &list = ((ScoreMapCo *)score)->cos;
   char name[MAXLINE];

   if(list.getn() == 0) {
      return 0;
   } else {
      sprintf(com,"%d)",nr);
      co = (Coherence *)list.start();
      while(co != 0 && strlen(com) < MAXLINE - 30) {
         co->fullNameGet(name);
         strcat(com,"   ");
         strcat(com,name);
         co = (Coherence *)list.next();
      }
      if(co != 0) strcat(com," ...");
   }
   return com;
}

char *CritDegen::comment(Score *score)
{
   Coherence *co;
   LiCo &list = ((ScoreDegen *)score)->cos;
   char name[MAXLINE];

   if(list.getn() == 0) {
      return 0;
   } else {
      sprintf(com,"%d)",nr);
      co = (Coherence *)list.start();
      while(co != 0 && strlen(com) < MAXLINE - 30) {
         co->fullNameGet(name);
         strcat(com," ");
         strcat(com,name);
         co = (Coherence *)list.next();
      }
      if(co != 0) strcat(com," ...");
   }
   return com;
}


void CritErPeak::upErPeak(Score *score, ErPeak *peak, Frag *frag, Coherence *)
{
   if(((ScoreErPeak *)score)->cur != peak) {
      ((ScoreErPeak *)score)->cur = peak;
      if(this->accept(peak,frag->nrExt)) {
         ((ScoreErPeak *)score)->tot += 1.0;
         if(peak->getAss() != 0)
            ((ScoreErPeak *)score)->sum += 1.0;
      }
   }
}

void CritMap::upErPeak(Score *score, ErPeak *peak, Frag *frag, Coherence *)
{
   ErPeak *poss;
   Atom *atSub, *atDest;
   int i;
   Iterator s1,s2,d1,d2;

   if(peak->getAss() != 0) {
      poss = peak->getAss()->p->ass.start(i);
      while(poss != 0) {
         if(poss->type == SUBFRAG && poss->spec == peak->spec) {
            atSub = poss->startAt(s1,s2);
            atDest= peak->startAt(d1,d2);
            while(atSub != 0 && atDest != 0) {
               if(atDest->frag == frag)
                  ((ScoreMap *)score)->frags.insert(atSub->frag);
               atSub = poss->nextAt(s1,s2);
               atDest= peak->nextAt(d1,d2);
            }
         }
         poss = peak->getAss()->p->ass.next(i);
      }
   }
}

void CritCorrect::upErPeak(Score *score, ErPeak *peak, Frag *frag, Coherence *)
{
   ErPeak *poss;
   Coherence *coSub, *coDest;
   int i;
   Iterator s1,d1;
I 2
   Parser pars;
   char str[MAXLINE];
   int tb,ib;
   int valid;
   int nr;
E 2

I 2
   coDest= peak->startCo(d1);
   while(coDest != 0) {
      if(coDest->firstAt()->frag == frag) {
         if (templ[0]=='\0') { valid=1; }
         else {
            coDest->fullNameGet(str); nr=frag->nrExt;
            valid = pars.coherence(templ,0,tb,str,0,ib,nr);
            valid &= (strlen(str) == ib);
         }
         if(valid)
            ((ScoreCorrect *)score)->cos_assigned.insert(coDest);
      }
      coDest= peak->nextCo(d1);
   }

E 2
   if(peak->getAss() != 0) {
      poss = peak->getAss()->p->ass.start(i);
      while(poss != 0) {
         if(poss->type == SUBFRAG && poss->spec == peak->spec) {
            coSub = poss->startCo(s1);
            coDest= peak->startCo(d1);
            while(coSub != 0 && coDest != 0) {
               if(coDest->firstAt()->frag == frag) {
D 2
                  ((ScoreCorrect *)score)->cos_assigned.insert(coDest);
                  if(coDest->floatIdentical(coSub))
                     ((ScoreCorrect *)score)->cos_correct.insert(coDest);
E 2
I 2
                  if (templ[0]=='\0') { valid=1; }
                  else {
                     coDest->fullNameGet(str); nr=frag->nrExt;
                     valid = pars.coherence(templ,0,tb,str,0,ib,nr);
                     valid &= (strlen(str) == ib);
                  }
                  if(valid) {
                     if(coDest->floatIdentical(coSub))
                        ((ScoreCorrect *)score)->cos_correct.insert(coDest);
                  }
E 2
               }
               coSub = poss->nextCo(s1);
               coDest= peak->nextCo(d1);
            }
         }
         poss = peak->getAss()->p->ass.next(i);
      }
   }
}

I 3
void CritCorRes::upErPeak(Score *score, ErPeak *peak, Frag *frag, Coherence *)
{
   ErPeak *poss;
   Coherence *coSub, *coDest;
   int i;
   Iterator s1,d1;
   Parser pars;
   char str[MAXLINE];
   int tb,ib;
   int valid;
   int nr;

   coDest= peak->startCo(d1);
   while(coDest != 0) {
      if(coDest->firstAt()->frag == frag) {
         if (templ[0]=='\0') { valid=1; }
         else {
            coDest->fullNameGet(str); nr=frag->nrExt;
            valid = pars.coherence(templ,0,tb,str,0,ib,nr);
            valid &= (strlen(str) == ib);
         }
         if(valid)
            ((ScoreCorrect *)score)->cos_assigned.insert(coDest);
      }
      coDest= peak->nextCo(d1);
   }

   if(peak->getAss() != 0) {
      poss = peak->getAss()->p->ass.start(i);
      while(poss != 0) {
         if(poss->type == SUBFRAG && poss->spec == peak->spec) {
            coSub = poss->startCo(s1);
            coDest= peak->startCo(d1);
            while(coSub != 0 && coDest != 0) {
               if(coDest->firstAt()->frag == frag) {
                  if (templ[0]=='\0') { valid=1; }
                  else {
                     coDest->fullNameGet(str); nr=frag->nrExt;
                     valid = pars.coherence(templ,0,tb,str,0,ib,nr);
                     valid &= (strlen(str) == ib);
                  }
                  if(valid) {
                     if(coSub->firstAt()->frag->nrExt == frag->nrExt)
                        ((ScoreCorrect *)score)->cos_correct.insert(coDest);
                  }
               }
               coSub = poss->nextCo(s1);
               coDest= peak->nextCo(d1);
            }
         }
         poss = peak->getAss()->p->ass.next(i);
      }
   }
}

E 3
void CritCorrSS::upErPeak(Score *score, ErPeak *peak, Frag *frag, Coherence *)
{
   ErPeak *poss;
   Coherence *coSub, *coDest;
   int i;
   Iterator s1,d1;

   if(peak->getAss() != 0) {
      poss = peak->getAss()->p->ass.start(i);
      while(poss != 0) {
         if(poss->type == SUBFRAG && poss->spec == peak->spec) {
            coSub = poss->startCo(s1);
            coDest= peak->startCo(d1);
            while(coSub != 0 && coDest != 0) {
               if(coDest->firstAt()->frag == frag) {
                  ((ScoreCorrect *)score)->cos_assigned.insert(coDest);
                  if(coDest->floatEquivalent(coSub))
                     ((ScoreCorrect *)score)->cos_correct.insert(coDest);
               }
               coSub = poss->nextCo(s1);
               coDest= peak->nextCo(d1);
            }
         }
         poss = peak->getAss()->p->ass.next(i);
      }
   }
}

void CritMapCo::upErPeak(Score *score, ErPeak *peak, Frag *, Coherence *co)
{
   ErPeak *poss;
   Coherence *coSub, *coDest;
   int i;
   Iterator s1,d1;

   if(peak->getAss() != 0) {
      poss = peak->getAss()->p->ass.start(i);
      while(poss != 0) {
         if(poss->type == SUBFRAG && poss->spec == peak->spec) {
            coSub = poss->startCo(s1);
            coDest= peak->startCo(d1);
            while(coSub != 0 && coDest != 0) {
               if(coDest == co /* && !coSub->subEqual(co) */)
                  ((ScoreMapCo *)score)->cos.insert(coSub);
               coSub = poss->nextCo(s1);
               coDest= peak->nextCo(d1);
            }
         }
         poss = peak->getAss()->p->ass.next(i);
      }
   }
}

void CritOvrlp::upErPeak(Score *score, ErPeak *peak, Frag *frag, Coherence *)
{
   ErPeak *poss;
   Atom *atSub, *atDest;
   int i;
   Iterator s1,s2,d1,d2;

   if(peak->getAss() != 0) {
      poss = peak->getAss()->p->ass.start(i);
      while(poss != 0) {
         if(poss != peak && poss->type == DESTFRAG &&
            poss->spec == peak->spec) {
            atSub = poss->startAt(s1,s2);
            atDest= peak->startAt(d1,d2);
            while(atSub != 0 && atDest != 0) {
               if(atDest->frag == frag && atSub->frag != frag)
                  ((ScoreMap *)score)->frags.insert(atSub->frag);
               atSub = poss->nextAt(s1,s2);
               atDest= peak->nextAt(d1,d2);
            }
         }
         poss = peak->getAss()->p->ass.next(i);
      }
   }
}

void CritOvrlpCo::upErPeak(Score *score, ErPeak *peak, Frag *, Coherence *co)
{
   ErPeak *poss;
   Coherence *coSub, *coDest;
   int i;
   Iterator s1,d1;

   if(peak->getAss() != 0) {
      poss = peak->getAss()->p->ass.start(i);
      while(poss != 0) {
         if(poss->type == DESTFRAG && poss->spec == peak->spec) {
            coSub = poss->startCo(s1);
            coDest= peak->startCo(d1);
            while(coSub != 0 && coDest != 0) {
               if(coDest == co && coSub != co)
                  ((ScoreMapCo *)score)->cos.insert(coSub);
               coSub = poss->nextCo(s1);
               coDest= peak->nextCo(d1);
            }
         }
         poss = peak->getAss()->p->ass.next(i);
      }
   }
}

void CritDegen::upOrdLiCo(OrdLiCo &cos, Iterator scoreIt)
{
   Coherence *co1, *co2;
   ScoreDegen *s1, *s2;
   Iterator i1,i2;
   int res;

   co1 = (Coherence *)cos.start(i1);
   while(co1 != 0) {
      s1 = (ScoreDegen *)co1->scores.get(scoreIt);
      i2 = i1;
      co2 = (Coherence *)cos.next(i2);
      res = 1;
      while(co1->meanF.valid() && co2 != 0 && res &&
         co1->firstAt()->frag->type==DESTFRAG) {
         if(co2->meanF.valid() && fabs(co1->meanF.x - co2->meanF.x) <= tol &&
            acceptCo(co1,co2) &&
            co2->firstAt()->frag->type==DESTFRAG) {
            s2 = (ScoreDegen *)co2->scores.get(scoreIt);
            s1->cos.insert(co2);
            s2->cos.insert(co1);
         } else {
            res = 0;
         }
         co2 = (Coherence *)cos.next(i2);
      }
      co1 = (Coherence *)cos.next(i1);
   }
}

int CritDegInter::acceptCo(Coherence *co1, Coherence *co2)
{
   return (co1->firstAt()->frag->nrExt != co2->firstAt()->frag->nrExt);
}

int CritDegIntra::acceptCo(Coherence *co1, Coherence *co2)
{
   return (co1->firstAt()->frag->nrExt == co2->firstAt()->frag->nrExt);
}

int Crit::lenNam()
{
   return strlen(fullname);
}

char Crit::nam(int i,int)
{
   if(i < strlen(fullname)) return fullname[i];
   else return ' ';
}

int Crit::match(char *templ)
{
   int len;

   len = strlen(templ);
   return (strncmp(templ,name,len) == 0);
}

void Crit::iname(char *n)
{
   strcpy(n,name);
}

void Crit::setThresh(float t1, float t2)
{
   thresh1 = t1;
   thresh2 = t2;
}

void Crit::setComment(int flag)
{
   writeCom = flag;
}

Score::Score(Crit *crit)
{
   nr = crit->nr;
}

int LiCrit::compare(const Element *c1,const Element *c2)
{
   return(((Crit *)c2)->nr - ((Crit *)c1)->nr);
}

int LiCrit::lenNam()
{
   Crit *crit;
   Iterator i;
   int max = 0;
   crit = (Crit *)start(i);
   while(crit != 0) {
      if(crit->lenNam() > max) max = crit->lenNam();
      crit = (Crit *)next(i);
   }
   return max;
}

void LiCrit::addFragII(LiFrag &frags, char *n,int l, int u)
{
   CritII *crit;
   ScoreErPeak *score;
   Frag *frag;

   crit = new CritII(n,l,u);
   add(crit);
   frag = (Frag *)frags.start();
   while(frag != 0) {
      score = new ScoreErPeak(crit);
      frag->scores.add(score);
      frag = (Frag *)frags.next();
   }
}

void LiCrit::addFragTempl(LiFrag &frags, char *n, char *t)
{
   CritTempl *crit;
   ScoreErPeak *score;
   Frag *frag;

   crit = new CritTempl(n,t);
   add(crit);
   frag = (Frag *)frags.start();
   while(frag != 0) {
      score = new ScoreErPeak(crit);
      frag->scores.add(score);
      frag = (Frag *)frags.next();
   }
}

void LiCrit::addCoTempl(LiCo &cos, char *n, char *t)
{
   CritTempl *crit;
   ScoreErPeak *score;
   Coherence *co;

   crit = new CritTempl(n,t);
   add(crit);
   co = (Coherence *)cos.start();
   while(co != 0) {
      score = new ScoreErPeak(crit);
      co->scores.add(score);
      co = (Coherence *)cos.next();
   }
}

void LiCrit::addCoDegen(LiCo &cos, char *n, float t)
{
   CritDegen *crit;
   ScoreDegen *score;
   Coherence *co;

   crit = new CritDegen(n,t);
   add(crit);
   co = (Coherence *)cos.start();
   while(co != 0) {
      score = new ScoreDegen(crit);
      co->scores.add(score);
      co = (Coherence *)cos.next();
   }
}

void LiCrit::addCoDegIntra(LiCo &cos, char *n, float t)
{
   CritDegIntra *crit;
   ScoreDegen *score;
   Coherence *co;

   crit = new CritDegIntra(n,t);
   add(crit);
   co = (Coherence *)cos.start();
   while(co != 0) {
      score = new ScoreDegen(crit);
      co->scores.add(score);
      co = (Coherence *)cos.next();
   }
}

void LiCrit::addCoDegInter(LiCo &cos, char *n, float t)
{
   CritDegInter *crit;
   ScoreDegen *score;
   Coherence *co;

   crit = new CritDegInter(n,t);
   add(crit);
   co = (Coherence *)cos.start();
   while(co != 0) {
      score = new ScoreDegen(crit);
      co->scores.add(score);
      co = (Coherence *)cos.next();
   }
}

void LiCrit::addFragMap(LiFrag &frags, char *n)
{
   CritMap *crit;
   ScoreMap *score;
   Frag *frag;

   crit = new CritMap(n);
   add(crit);
   frag = (Frag *)frags.start();
   while(frag != 0) {
      score = new ScoreMap(crit);
      frag->scores.add(score);
      frag = (Frag *)frags.next();
   }
}

D 2
void LiCrit::addFragCorrect(LiFrag &frags, char *n)
E 2
I 2
void LiCrit::addFragCorrect(LiFrag &frags, char *n, char *t)
E 2
{
   CritCorrect *crit;
   ScoreCorrect *score;
   Frag *frag;

D 2
   crit = new CritCorrect(n);
E 2
I 2
   crit = new CritCorrect(n,t);
E 2
   add(crit);
   frag = (Frag *)frags.start();
   while(frag != 0) {
      score = new ScoreCorrect(crit);
      frag->scores.add(score);
      frag = (Frag *)frags.next();
   }
}

I 3
void LiCrit::addFragCorRes(LiFrag &frags, char *n, char *t)
{
   CritCorrect *crit;
   ScoreCorrect *score;
   Frag *frag;

   crit = new CritCorRes(n,t);
   add(crit);
   frag = (Frag *)frags.start();
   while(frag != 0) {
      score = new ScoreCorrect(crit);
      frag->scores.add(score);
      frag = (Frag *)frags.next();
   }
}

E 3
void LiCrit::addFragCorrSS(LiFrag &frags, char *n)
{
   CritCorrSS *crit;
   ScoreCorrect *score;
   Frag *frag;

   crit = new CritCorrSS(n);
   add(crit);
   frag = (Frag *)frags.start();
   while(frag != 0) {
      score = new ScoreCorrect(crit);
      frag->scores.add(score);
      frag = (Frag *)frags.next();
   }
}

void LiCrit::addCoMap(LiCo &cos, char *n)
{
   CritMapCo *crit;
   ScoreMapCo *score;
   Coherence *co;

   crit = new CritMapCo(n);
   add(crit);
   co = (Coherence *)cos.start();
   while(co != 0) {
      score = new ScoreMapCo(crit);
      co->scores.add(score);
      co = (Coherence *)cos.next();
   }
}

void LiCrit::addFragOverlap(LiFrag &frags, char *n)
{
   CritOvrlp *crit;
   ScoreMap *score;
   Frag *frag;

   crit = new CritOvrlp(n);
   add(crit);
   frag = (Frag *)frags.start();
   while(frag != 0) {
      score = new ScoreMap(crit);
      frag->scores.add(score);
      frag = (Frag *)frags.next();
   }
}

void LiCrit::addCoOverlap(LiCo &cos, char *n)
{
   CritOvrlpCo *crit;
   ScoreMapCo *score;
   Coherence *co;

   crit = new CritOvrlpCo(n);
   add(crit);
   co = (Coherence *)cos.start();
   while(co != 0) {
      score = new ScoreMapCo(crit);
      co->scores.add(score);
      co = (Coherence *)cos.next();
   }
}

void LiCrit::upErPeak(LiScore &scores, ErPeak *peak, Frag *frag, Coherence *co)
{
   Crit *crit;
   Score *score;
   Iterator i,j;

   crit = (Crit *)start(i);
   score = (Score *)scores.start(j);
   while(crit != 0) {
      if(crit->uErPeak()) {
         crit->upErPeak(score,peak,frag,co);
      }
      crit = (Crit *)next(i);
      score= (Score *)scores.next(j);
   }
}

void LiCrit::upCos(LiCo &li)
{
   OrdLiCo cos = OrdLiCo(li);
   Crit *crit;
   Iterator i;

   crit = (Crit *)start(i);
   while(crit != 0) {
      if(crit->uOrdLiCo()) {
         crit->upOrdLiCo(cos,i);
      }
      crit = (Crit *)next(i);
   }
}

int LiScore::compare(const Element *s1,const Element *s2)
{
   return(((Score *)s2)->nr - ((Score *)s1)->nr);
}

void LiScore::reset()
{
   Score *score;

   score = (Score *)start();
   while(score != 0) {
      score->reset();
      score = (Score *)next();
   }
}
void CritCorrect::initSums()
{
   cntOk=0; cntTot=0;
}

void CritCorrect::addSum(Score *s)
{
   cntOk  += ((ScoreCorrect *)s)->cos_correct.getn();
   cntTot += ((ScoreCorrect *)s)->cos_assigned.getn();
}

char *CritCorrect::printSum()
{
   static char str[MAXLINE];
D 2
   sprintf(str,"%d of %d coherences correctly assigned",cntOk,cntTot);
E 2
I 2
   static char name[MAXLINE];

   sprintf(str,"%3d of %3d %s coherences correctly assigned",
I 3
      cntOk,cntTot,templ);
   return str;
}

char *CritCorRes::printSum()
{
   static char str[MAXLINE];
   static char name[MAXLINE];

   sprintf(str,"%3d of %3d %s coherences assigned to correct residue",
E 3
      cntOk,cntTot,templ);
E 2
   return str;
}

char *CritCorrSS::printSum()
{
   static char str[MAXLINE];
   sprintf(str,"%d of %d coherences assigned to correct spin system type",
      cntOk,cntTot);
   return str;
}

E 1
