h60240
s 00000/00000/00082
d D 1.2 95/09/15 13:39:06 cb 2 1
c program renamed into garant
e
s 00082/00000/00000
d D 1.1 95/03/03 14:10:23 cb 1 0
c date and time created 95/03/03 14:10:23 by cb
e
u
U
f e 0
t
T
I 1
/*
************************************************************************
*
*   %M% -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : %E%
*   Pathname of SCCS file     : %P%
*   SCCS identification       : %I%
*
************************************************************************
*/
/**************************************************************************/
/*                                pos.h                                   */
/*                                                                        */
/* list of complete assignment possibilities                              */
/**************************************************************************/

#ifndef _POS_H_
#define _POS_H_

#include "element.h"
#include "global.h"

class LiPeak;
class ErPeak;
class Optimizer;
class NMRdia;
class OptPosSelection;
class Peak;

/* forward declarations */
class LiOptPos;

class OptPos : public Element	/* info for assignment possibility        */
{
   float score;			/* gloabal score of the possibility       */
   float value;			/* value of the possibility               */
   float sumScore;		/* summed up scores used for selection    */
   int nr;			/* number of the asisgnment in the nmr    */
                                /* diagram                                */
public:
   friend LiOptPos;
   friend OptPosSelection;
   OptPos(int);			/* initialize with given number           */
};

class LiOptPos : public Index  {
   ErPeak **peaks;		/* order in which the peaks assignments   */
				/* are written to the file                */
   int nrEntries;		/* how many expected peaks                */
public:
   LiOptPos();
   virtual int compare(const Element *,const Element *);
				/* use nr for comparing                 */
   void init(int, LiErPeak &, LiCo &, LiPeak &);
				/* initialize given nmber of assignment   */
				/* possibilities of the given list of     */
				/* peaks                                  */
   int select(float, int, int, int, int *);
				/* random select set of a ass. possibility*/
				/* INPUT: temprature			  */
				/*        number of poss. to select       */
				/*	  first allowed possibility       */
				/* 	  last allowed possibility        */
				/* OUTPUT: numbers of the selected poss.  */
				/*         number of selected poss.       */
   void update(float,int,int, NMRdia &dia);
				/* update optimization possibility        */
   void scorePop(int,int, NMRdia &dia);
				/* calculate scores for a population      */
};

#endif
E 1
