h14361
s 00000/00000/00169
d D 1.2 95/09/15 13:39:02 cb 2 1
c program renamed into garant
e
s 00169/00000/00000
d D 1.1 95/03/03 14:10:07 cb 1 0
c date and time created 95/03/03 14:10:07 by cb
e
u
U
f e 0
t
T
I 1
/*
************************************************************************
*
*   %M% -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : %E%
*   Pathname of SCCS file     : %P%
*   SCCS identification       : %I%
*
************************************************************************
*/
/**************************************************************************/
/*                           nmrdia.h                                     */
/*                                                                        */
/* diagram representing nmr experiments and assignments                   */
/**************************************************************************/

#ifndef _NMRDIA_H_
#define _NMRDIA_H_

#include "erPeak.h"		/* expected peaks                         */
#include "co.h"			/* coherences                             */
#include "ss.h"
#include "global.h"
#include "peak.h"
#include "pos.h"
#include <math.h>

class Envir;
class LiPeak;
class Spectrum;
class OptPos;
class Optimizer;

class NMRdia {
   void scoreFrags(LiCrit &);	/* score the fragments according to list  */
				/* of criteria                            */
   void scoreCos(LiCrit &);	/* score the coherences according to list */
				/* of criteria                            */
public:
   NMRdia() {avgScore=0.0;}
   Ss ss;			/* all the atoms and relations            */
   LiCo liCo;			/* list of all involve coherences         */
   LiErPeak liErPeak;		/* list of all expected peaks             */
   LiPeak peaks;		/* all measured peaks                     */
   LiOptPos optPos;		/* list of assignmnet possibilities for   */
				/* the optimization                       */
   int activePos[MAXASSIGN];	/* active optimization possibilities      */
   int nrActive;		/* number of active possibilities         */
   float score;			/* global score of the assignment         */
   float value;			/* value of assignment                    */
   float avgScore;		/* average score, calculated by           */
				/* optPos.select()			  */
   float ratioMut;		/* percentage of mutations                */
   void scoreGlobal();		/* calculate the global score of the ass. */
   void sumScore(int,float&,float&);
				/* sum up partial scores of co's and peaks*/
   void assStatistic(Spectrum *);
				/* make statistics of the assignments     */
   void distHamilton();		/* calc distances between parents and     */
				/* child                                  */
   void coMake();		/* generate all possible coherences       */
   void peakMake(Envir &);	/* generate the peaks of all used spectra */
   void listPeaks(char *);	/* list peaks matching the template       */
   void initOptPos(int);	/* initialize optimization poss.          */
				/* INPUT: number of possibilities         */
   void setPeakImp(char *,float);
				/* set importance of peak matching the    */
				/* template to the specified value        */
   int writeCo(char *,int);	/* write coherence file                   */
				/* INPUT: filename of EASY *.prot file    */
				/*        type (sub- or dest. fragment)   */
   void loadFreqCo(char *,int); /* load assigned frequencies of the co's  */
				/* INPUT: filename of EASY *.prot file    */
				/*        type (sub- or dest. fragment)   */
   void setFreqTol(char *,float);
				/* set the tolerance of the assigned      */
				/* frequencies                            */
				/* INPUT: template to identify co's       */
				/*        tolerance in ppm                */
				/*        type (sub- or dest. fragment)   */
   void writeExpPeaks(Spectrum *, char *, char *,int,int);
				/* write out list  of expected peaks in   */
				/* the EASY *.peaks format                */
				/* INPUT: type of spectrum                */
				/*        file name of peak list          */
				/*        file name of coherence list to  */
				/*           use for assignments          */
				/*        sub- or destination fragment ?  */
				/*        max nr. of undefined freq.      */
   void appendExpPeaks(Spectrum *, int, int, int);
				/* append expected peaks to the list of   */
				/* measured peaks			  */
				/* INPUT: type of spectrum		  */
				/*        sub- or destination fragment ?  */
				/*        nr. of undefined freq.          */
				/*        color for the appende peaks     */
   void reportMissPeaks(Spectrum *, int, int);
				/* report expected peaks not present in   */
				/* the list of measured peaks             */
				/* INPUT: type of spectrum		  */
				/*        sub- or destination fragment ?  */
				/*        nr. of undefined freq.          */
				/*        color for the appende peaks     */
   void loadPeakAss(LiPeak &, Spectrum *, char *, char *, int,float);
				/* load assignments of measured peaks to  */
				/* expected peaks                         */
				/* INPUT: list of peaks to assign         */
				/*        spectrum type of the assignments*/
				/*        file name of peak list          */
				/*        file name of coherence list to  */
				/*           use for assignments          */
				/*        sub- or destination fragment ?  */
				/*	  tolerance factor to match peaks */
				/*		0.0 ... use peak number   */
				/*		1.0 ... tol. ass specified*/
				/*			for spectrum      */
   void addPeakAss();		/* generate assignment possibilities from */
				/* the assignments of expected to measured*/
				/* peaks                                  */
   void addPossAss();		/* generate assignment using the position */
				/* of expected peaks                      */
   void resetAss();		/* reset all peak assignments             */
   void resetAss(int,int,int);	/* reset all peak assignments involving   */
				/* specified residues                     */
   void calcMeanFreq();		/* calculate the coherence frequencies    */
				/* and standard deviation from the ass.   */
				/* expected peaks                         */
				/* initialize nrAss of the measured peaks */
   void checkIncon();		/* check for inconsistently assigned peaks*/
//   void cpMeanToAssFreq();	/* copy the mean frequency to the assigned*/
				/* frequencies                            */
   void resetAssF();		/* reset the assigned frequencies         */
   void genSsEquiv();		/* Generate lists of peaks from equivalent*/
				/* positions in equivalent spinsystems    */
   void markPosPeaks(Spectrum *, int, int);
				/* mark peaks that have possible          */
				/* assignments for the given two dim.     */
				/* 0 as a dimension = no dimension        */
   void sortFloatAss();		/* sort peaks with floating assignment    */
				/* according to chem. shift               */
   void fixAss(char *, int);	/* hold assignments constant              */
				/* INPUT: name of co's to fix             */
				/*        whether to fix or release ass.  */
				/*           1 ... fix     		  */
				/*	     0 ... release		  */
   void reportFrags(LiCrit &);	/* generate asssignment report for frags  */
				/* using the given criteria               */
   void reportCos(LiCrit &,char *);
				/* generate asssignment report for co's   */
				/* using the given criteria               */
				/* list only co's matching template       */
   void reportCalc(LiCrit &, LiCrit &, LiCrit &);
                                /* calculate the scoring for the reports  */
				/* coherence, fragment, global            */
   void calcScoreTables();	/* calculates the contributions to the    */
				/* score 				  */
};

#endif
E 1
