h44876
s 00000/00000/00124
d D 1.2 95/09/15 13:38:59 cb 2 1
c program renamed into garant
e
s 00124/00000/00000
d D 1.1 95/03/03 14:09:58 cb 1 0
c date and time created 95/03/03 14:09:58 by cb
e
u
U
f e 0
t
T
I 1
/*
************************************************************************
*
*   %M% -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : %E%
*   Pathname of SCCS file     : %P%
*   SCCS identification       : %I%
*
************************************************************************
*/
/**************************************************************************/
/*                              log.cc                                    */
/*                                                                        */
/* writes lines of text intoo a file or stdio                             */
/**************************************************************************/

#include <stdio.h>
#include <string.h>

#include "log.h"
#include "global.h"

/* static members */
FILE *Log::fp=0;
OldLogs *Log::hist=0;
int Log::nrWarns=0;


/* implementation of class Log ********************************************/

class OldLogs {
   OldLogs *hist;
   FILE *fp;
public:
   friend Log;
};

//void Log::init()
//{
//   fp =0; hist=0; 
//}

void Log::open(char *name)
{
   OldLogs *newEntry;

   newEntry = new OldLogs;
   newEntry->fp = fp;
   newEntry->hist = hist;
   hist = newEntry;
   if(strcmp(name,"/dev/null.log")==0)
      fp = fopen("/dev/null","w");
   else
      fp = fopen(name,"w");
   if(fp == 0) printf("Could not open log file '%s'.\n",name);
}

void Log::append(char *name)
{
   OldLogs *newEntry;

   newEntry = new OldLogs;
   newEntry->fp = fp;
   newEntry->hist = hist;
   hist = newEntry;
   fp = fopen(name,"a");
   if(fp == 0) printf("Could not open log file '%s'.\n",name);
}

void Log::close()
{
   OldLogs *oldEl;
   w("\n");
   if(fp != 0) fclose(fp);
   if(hist != 0) {
      fp = hist->fp;
      oldEl = hist;
      hist = oldEl->hist;
      delete oldEl;
   }
}

void Log::write(char *line)
{
   if(fp == 0) {				// write to stdio
      printf("%s",line);
   } else {
      fprintf(fp,"%s",line);
   }
}

void Log::w(char *line)
{
   nrWarns = 0;
   write(line);
}

void Log::r(char *line)
{
   w(line);
}

void Log::warn(int max, char *line)
{
   char str[MAXLINE];

   nrWarns++;
   if(nrWarns <= max || max<0) write(line);
   if(nrWarns == max) {
      sprintf(str,"\n... more than %d WARNINGS - some are discarded",max);
      write(str);
   }
}

E 1
