h61225
s 00000/00000/02090
d D 1.3 95/09/15 13:38:56 cb 3 2
c program renamed into garant
e
s 00018/00020/02072
d D 1.2 95/03/03 15:26:28 cb 2 1
c header changed to fortran
e
s 02092/00000/00000
d D 1.1 95/03/03 14:09:44 cb 1 0
c date and time created 95/03/03 14:09:44 by cb
e
u
U
f e 0
t
T
I 1
D 2
/*
************************************************************************
*
*   %M% -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : %E%
*   Pathname of SCCS file     : %P%
*   SCCS identification       : %I%
*
************************************************************************
*/
E 2
I 2
c       ************************************************************************
c       *
c       *   %M% -
c       *
c       *   Copyright (c) 1995
c       *
c       *   ETH Zuerich
c       *   Institut fuer Molekularbiologie und Biophysik
c       *   ETH-Hoenggerberg
c       *   CH-8093 Zuerich
c       *
c       *   All Rights Reserved
c       *
c       *   Date of last modification : %E%
c       *   Pathname of SCCS file     : %P%
c       *   SCCS identification       : %I%
c       *
c       ************************************************************************
E 2
c     ==================================================================
c     GETCMD: Read command line input and execute some built-in 
c             commands.
c             Do not touch!
c                                         
c             Peter G"untert, 25-03-1992
c     ------------------------------------------------------------------
      subroutine getcmd (mode,cmd,param,nparam,maxp,
     *                   macext,hlpdir,inifil)
c
c      common /timdat/timer(100)
c
      save
      character*(*) quote,dquote
      parameter (maxlin=250,maxid=32,maxvar=500,maxlnr=500,
     *           maxif=10,maxlop=maxif,maxpar=100,maxsub=100,
     *           maxsul=2000,minuni=10,maxuni=20,maxfil=30,maxali=100,
     *           quote='''',dquote='"')
      dimension nlvar(minuni:maxuni),lnr(minuni:maxuni),
     *          laslnr(minuni:maxuni),
     *          lopbeg(minuni:maxuni),nifbeg(minuni:maxuni),
     *          loopnr(maxlop),lopcnt(maxlop),lopend(maxlop),
     *          lopinc(maxlop),isub(maxsub+1),iusub(maxsub),lp(maxpar),
     *          ic(maxlin)
      complex cres
      logical leva,declar,echon,echful,asking,ifdone(maxif),yes,havpas,
     *        reonly(maxvar),quoted,nostr,haverr,illexp,visibl,havhlp,
     *        useini,noecho,going,arived,loadin,idch(0:255),qcmd,match,
     *        appfil,clofil,havexp,ketket,nostvd
      character*(*) cmd,param(maxp),macext,hlpdir,inifil,
     *              dirend*2,group*80,pgroup*80,fmt*20,esc*1,ch*1
      character*(maxlin) line,prompt,maclin(maxlnr,minuni:maxuni),
     *                   linbuf(minuni:maxuni),filnam(minuni:maxuni),
     *                   sublin(maxsul),subbuf(maxlnr),
     *                   filsub(maxsub),alidef(maxali),
     *                   e,path,vd,topic,str,str1,str2
      character*(maxid) label,askvar(maxvar),
     *                  lopvar(maxlop),defpar(maxpar),alias(maxali)
c
      character var*(maxid),vardef*(maxlin)
      common /vardat/nvar
     *       /vdch/var(maxvar),vardef(maxvar)
      character extnsn*(maxid)
      common /macdat/extnsn
c
      data iunit,nif,nloop,mif,mloop,reonly,going,dirend,useini,
     *     iecho,nsub,nalias,nfil
     *     /minuni,4*0,maxvar*.false.,.false.,'/]',.true.,3*0,maxuni/
c
c      t0=timnow()
      if (mode.gt.0) go to 200
      asking=.false.
      loadin=.false.
      haverr=.false.
c     ------- check existence of initialization macro, initialize recall
      if (useini) then
        nvar=0
        esc=char(92)
        extnsn=macext
        str=inifil(1:lenstr(inifil))//macext
        inquire (file=str,exist=useini)
c        print *,str,useini
        lnr(minuni)=0
        do 2 l=1,maxlnr
    2     maclin(l,minuni)=' '
        do 3 l=1,maxpar
          defpar(l)(1:1)='p'
    3     call intstr (l,defpar(l)(2:))
        do 4 l=0,255
          ch=char(l)
          idch(l)=(ch.ge.'0' .and. ch.le.'9') .or.
     *            (ch.ge.'a' .and. ch.le.'z') .or.
     *            (ch.ge.'A' .and. ch.le.'Z') .or. ch.eq.'_'
    4     continue
        linbuf(minuni)=' '
      end if
c     --------------------------------------------- set system variables
      call sysvar (var,vardef,reonly,nvar,nsvar,haverr)
      if (nvar.gt.maxvar) then
        print '(''*** Fatal error: Too many system variables.'')'
        stop
      end if
c     ----------------------------------------------------- command loop
   10 line=' '
c     -------------------------------------- exit after error, if needed
      if (haverr .and. iunit.gt.minuni) then
        haverr=.false.
        asking=.false.
        loadin=.false.
        linbuf(iunit)=' '
        do 11 k=nvar,1,-1
   11     if (var(k).eq.'erract') go to 12
   12   if (k.gt.0) then
          line=vardef(k)
        else
          line='exit'
        end if
        if (line.ne.'NULL') go to 15
      end if
      haverr=.false.
c     ------------------------------------------------ read command line
      if (asking) print '(A)',prompt(1:lenstr(prompt))
      l=1
c   13 if (iunit.gt.minuni .and. .not.asking) then
c     ....................................... read line from line buffer
   13 if (linbuf(iunit).ne.' ') then
        line=linbuf(iunit)
        linbuf(iunit)=' '
        go to 15
c     ........................................... read line from a macro
      else if (iunit.gt.minuni .and. .not.asking) then
c        print *,nifbeg(iunit),nif,mif,nloop,mloop
        lnr(iunit)=lnr(iunit)+1
        if (laslnr(iunit).le.0) then
          read (iunit,'(A)',end=14) line(l:)
          go to 15
        else if (lnr(iunit).le.laslnr(iunit)) then
          line(l:)=maclin(lnr(iunit),iunit)
          go to 15
        end if
c       ................................................. end of a macro
   14   if (laslnr(iunit).le.0) close (iunit)
        nvar=nlvar(iunit)-1
c        print *,nifbeg(iunit),nif,mif,nloop,mloop
        do 141 i=nsub,1,-1
  141     if (iusub(i).lt.iunit) go to 149
  149   nsub=i
        if (loadin) then
          print '(''*** Error: Missing "end".'')'
          haverr=.true.
        else if (nif.ne.nifbeg(iunit) .or. mif.gt.0) then
          print '(''*** Error: Missing "end if".'')'
          haverr=.true.
        end if
        nif=nifbeg(iunit)
        mif=0
        if (nloop.ne.lopbeg(iunit) .or. mloop.gt.0) then
          print '(''*** Error: Missing "end do".'')'
          haverr=.true.
        end if
        nloop=lopbeg(iunit)
        mloop=0
        if (going) then
          print '(''*** Error: Missing label "'',A,''".'')',
     *          label(1:lenstr(label))
          haverr=.true.
        end if
        iunit=iunit-1
        iecho=-1
        going=.false.
        loadin=.false.
        if (haverr) go to 10
      else 
        if (useini) then
c         ......................... use initialization macro, if present
          line=inifil
          useini=.false.
        else
c         ................................ read line from standard input
c        read '(A)',line(l:)
          call getlin (line(l:))
        end if
        declar=.false.
      end if
   15 ll=lenstr(line)
c     ------------------------------------ load line in subroutine buffer
      if (loadin) then
        ll=max(1,ll)
        str(1:ll)=line(1:ll)
        call lefstr (str(1:ll))
        i=index(str(1:ll),'#')
        if (i.gt.0) str(i:ll)=' '
        if (nsulev.le.0 .and. str(1:ll).eq.'end') then
          isub(nsub+2)=isub(nsub+1)+nbuf
          if (iusub(nsub+1).le.minuni) then
            do 19 i=1,nsub
   19         if (iusub(i).gt.minuni) go to 20
   20       do 21 j=isub(nsub+1)-1,isub(i),-1
   21         sublin(j+nbuf)=sublin(j)
            do 22 j=1,nbuf
   22         sublin(isub(i)+j-1)=subbuf(j)
            do 23 j=nsub,i,-1
              isub(j+1)=isub(j)+nbuf
              iusub(j+1)=iusub(j)
   23         filsub(j+1)=filsub(j)
            iusub(i)=minuni
          end if
          nsub=nsub+1
          loadin=.false.
        else
          nbuf=nbuf+1
          if (nbuf.gt.maxlnr .or. isub(nsub+1)+nbuf-1.gt.maxsul) then
            print '(''*** Error: Subroutines too long.'')'
            haverr=.true.
            go to 10
          else if (iusub(nsub+1).le.minuni) then
            subbuf(nbuf)=line
          else
            sublin(isub(nsub+1)+nbuf-1)=line
          end if
          if (str(1:10).eq.'subroutine' .or. 
     *        str(1:7).eq.'command') then
            nsulev=nsulev+1
          else if (nsulev.gt.0 .and. str(1:ll).eq.'end') then
            nsulev=nsulev-1
          end if
        end if
        go to 10
      end if
c
      if (ll.gt.0) then
c       --------------------------------------- treat continuation lines
        if (line(ll:ll).eq.esc) then
          line(ll:ll)=' '
          l=ll+1
          go to 13
c       ---------------------------------- skip comments and empty lines
        else if (line(1:1).eq.'#') then
          ll=0
        else
          quoted=.false.
          do 16 i=1,ll
            if (line(i:i).eq.'#' .and. .not.quoted) then
              line(i:ll)=' '
              ll=i-1
              go to 17
            end if
            if (line(i:i).lt.' ') line(i:i)=' '
   16       quoted=line(i:i).eq.esc
   17     call lefstr (line(1:ll))
          ll=lenstr(line(1:ll))
        end if
      end if
      if (asking) go to 28
      if (ll.eq.0) then
        if (iunit.le.minuni) print '(''... Ready.'')'
        go to 10
      end if
c      print *,'# treated ',lenstr(line),line(1:max(1,lenstr(line)))
c     ---------------------------- recall a previous interactive command
      if (iunit.le.minuni .and. line(1:1).eq.'!') then
        if (line.eq.'!!' .and. lnr(minuni).gt.0)
     *    line='!'//maclin(mod(lnr(minuni)-1,maxlnr)+1,minuni)(1:1)
        k=lenstr(line)-1
        if (k.le.0) then
          print '(''*** Error: Illegal statement recall.'')'
          haverr=.true.
          go to 10
        end if
        do 24 i=lnr(minuni),max(1,lnr(minuni)-maxlnr),-1
          j=mod(i-1,maxlnr)+1
          if (maclin(j,minuni)(1:k).eq.line(2:k+1)) then
            line=maclin(j,minuni)
            ll=lenstr(line)
            print '(A)',line(1:ll)
            go to 27
          end if
   24     continue
        print '(''*** Error: No matching statement found.'')'
        haverr=.true.
        go to 10
c     ------------------------- modify the preceding interactive command
      else if (iunit.le.minuni .and. line(1:1).eq.'^') then
        str1=line(2:)
        i1=index(str1,'^')-1
        if (i1.gt.0) then
          str2=str1(i1+2:)
          str1(i1+1:)=' '
          i2=index(str2,'^')-1
          if (i2.ge.0) then
            str2(i2+1:)=' '
          else
            i2=lenstr(str2)
          end if
          str=maclin(mod(lnr(minuni)-1,maxlnr)+1,minuni)
          line=str
          i=index(str,str1(1:i1))
          if (i.gt.0) then
            if (i2.gt.0) then
              line(i:)=str2(1:i2)//str(i+i1:)
            else
              line(i:)=str(i+i1:)
            end if
            ll=lenstr(line)
            print '(A)',line(1:ll)
            go to 27
          end if
        end if
        print '(''*** Error: Modifier failed.'')'
        haverr=.true.
        go to 10
      end if
c     ----------------------------------------------------- treat labels
c      if (going) print '(I5,2X,A)',nsulev,line(1:ll)
      arived=.false.
      do 25 i=1,ll
        if (line(i:i).eq.':') then
          if (line(i:min(i+1,ll)).eq.':=') go to 26
          if (i.eq.1) then
            print '(''*** Error: Missing label.'')'
            haverr=.true.
            go to 10
          end if
          if (going .and. nsulev.le.0) arived=line(1:i-1).eq.label
          line(1:i)=' '
          call lefstr(line(1:ll))
          ll=lenstr(line(1:ll))
          go to 26
        else if (.not.idch(ichar(line(i:i)))) then
          go to 26
        end if
   25   continue
c     ---------------------- skip commands in a not executed "if" branch
c      print *,iunit,nif,mif,ifdone(max(1,nif))
   26 if (mif.gt.0) then
        if ((line(1:3).eq.'if ' .or. line(1:3).eq.'if(') .and.
     *      line(max(1,ll-4):ll).eq.' then') then
          mif=mif+1
          go to 10
        else if ((line(1:4).ne.'end' .and. line(1:5).ne.'else') .or.
     *           (ifdone(nif) .and. line(1:5).eq.'else') .or.
     *           (line(1:4).eq.'end' .and. 
     *            line(max(1,ll-1):ll).eq.'do')) then
          go to 10
        else if (mif.gt.1) then
          if (line(1:4).eq.'end' .and. line(max(1,ll-1):ll).eq.'if') 
     *      mif=mif-1
          go to 10
        end if
      else if (line(1:3).eq.'if ' .or. line(1:3).eq.'if(') then
        ifdone(nif+1)=.false.
      end if
c     ----------------------------- skip commands in a not executed loop
      if (mloop.gt.0) then
        if (line(1:3).eq.'do ') then
          mloop=mloop+1
          go to 10
        else if (line(1:4).ne.'end ' .or. line(max(1,ll-1):ll).eq.'if') 
     *  then
          go to 10
        end if
      end if   
c     ---------------------------- skip commands when jumping to a label
      if (going) then
        if (arived) then
          going=.false.
        else
          if ((line(1:3).eq.'if ' .or. line(1:3).eq.'if(') .and.
     *        line(max(1,ll-4):ll).eq.' then') then
            nif=nif+1
          else if (line(1:3).eq.'do ') then
            nloop=nloop+1
          else if (line(1:4).eq.'end ') then
            if (line(max(1,ll-1):ll).eq.'if') nif=nif-1
            if (line(max(1,ll-1):ll).eq.'do') nloop=nloop-1
            if (line(1:ll).eq.'end') nsulev=nsulev-1
          else if (line(1:10).eq.'subroutine' .or. 
     *             line(1:7).eq.'command') then
            nsulev=nsulev+1
          end if
          go to 10
        end if
      end if
c     ----------------------------- save interactive commands for recall
   27 if (iunit.le.minuni) then
        lnr(minuni)=lnr(minuni)+1
        maclin(mod(lnr(minuni)-1,maxlnr)+1,minuni)=line
      end if
c     -------------------------------------- look for escaped characters
   28 str(1:ll)=line(1:ll)
      line(1:ll)=' '
c      e(1:ll)=' '
      e=' '
      j=0
      quoted=.false.
      do 29 i=1,ll
c       .................................... escaping a single character
        if (str(i:i).eq.esc .and. e(j+1:j+1).ne.'E') then
c          print *,'Esc: ',ichar(esc),'|'//str(i:i)//'|    |'//esc
          e(j+1:j+1)='E'
c       ............................ single quotes for character strings
        else if (str(i:i).eq.quote .and. e(j+1:j+1).eq.' ') then
          j=j+1
          line(j:j)=str(i:i)
          quoted=.not.quoted
          if (quoted) e(j+1:j+1)='e'
c       .................................................. double quotes
        else if (str(i:i).eq.dquote .and. e(j+1:j+1).eq.' ') then
          quoted=.not.quoted
          if (quoted) e(j+1:j+1)='e'
        else
          j=j+1
          line(j:j)=str(i:i)
          if (quoted .and. e(j:j).ne.'E') e(j:j)='e'
        end if
   29   continue
c      print '(A)','Quoting treated:',
c     *      str(1:lenstr(str)),line(1:lenstr(line)),e(1:lenstr(e))
      if (quoted) then
        print '(''*** Error: Missing '',A,'' or '',A,''.'')',
     *        quote,dquote
        haverr=.true.
        go to 10
      end if
      ll=j
c      print *,ll,lenstr(line),'"'//line(1:lenstr(line))//'"'
c     ------------------------------- treat semicolon-separated commands
      do 292 i=1,ll
  292   if (line(i:i).eq.';' .and. e(i:i).eq.' ') go to 293
      go to 30
  293 k=lenstr(linbuf(iunit))
      if (k.eq.0) then
        linbuf(iunit)=line(i+1:ll)
      else
        str(1:k)=linbuf(iunit)(1:k)
        linbuf(iunit)=line(i+1:ll)//'; '//str(1:k)
      end if
      line(i:ll)=' '
      ll=i-1
      if (ll.eq.0) go to 10
c     ------------------------------------------------ replace variables
c   30 t8=timnow()
   30 do 31 i=ll,1,-1
        if ((line(i:i).eq.'$' .or. line(i:i).eq.'%') .and. 
     *      e(i:i).ne.'E') go to 32
   31   continue
   32 i=i+1
      if (i.gt.1) then
c       ............................................. find variable name
        havexp=line(i:i).eq.'{' .and. e(i:i).ne.'E'
        if (havexp) then
          line(i:i)=line(i-1:i-1)
          line(i-1:i-1)='{'
          i=i+1
          do 33 j=i,ll
   33       if (line(j:j).eq.'}' .and. e(j:j).ne.'E') go to 35
          print '(''*** Error: Missing "}".'')'
          haverr=.true.
          go to 10
        else
          do 34 j=i,ll
   34       if (.not.idch(ichar(line(j:j)))) go to 35
        end if
   35   if (i.eq.j) then 
          print '(''*** Error: Missing variable or function name.'')'
          haverr=.true.
          go to 10
        end if
c       .................................................. function call
        if (.not.havexp) then
          do 36 k=nvar,1,-1
   36       if (var(k).eq.line(i:j-1)) go to 37
   37     if (k.eq.0) then
            if (line(j:j).eq.'(') then
              do 275 l=j+1,ll
                if (line(l:l).eq.quote) nostr=.not.nostr
                if (nostr) then
                  if (line(l:l).eq.'(') then
                    nparen=nparen+1
                  else if (nparen.gt.1 .and. line(l:l).eq.')') then
                    nparen=nparen-1
                  else if (line(l:l).eq.')') then
                    j=l+1
                    go to 276
                  end if
                end if
  275           continue
            end if
          end if
        end if
  276   if (havexp .or. k.eq.0) then
          if (line(i-1:i-1).eq.'$') then
            i1=1
          else
            i1=2
          end if
          call eva (line(i:j-1),ires,res,cres,vd(i1:),ityp)
          if (ityp.eq.1) then
            call intstr (ires,vd(1:10))
            i2=lenstr(vd(1:10))
          else if (ityp.eq.2) then
            write (vd(1:20),'(1PG20.6)') res
            call lefstr (vd(1:20))
            i2=lenstr(vd(1:20))
          else if (ityp.eq.3) then
            vd(1:1)='('
            write (vd(2:21),'(1PG20.6)') real(cres)
            call lefstr (vd(2:21))
            kk=lenstr(vd(1:21))
            vd(kk+1:kk+1)=','
            write (vd(kk+2:kk+21),'(1PG20.6)') aimag(cres)
            call lefstr (vd(kk+2:kk+21))
            i2=lenstr(vd(1:kk+21))+1
            vd(i2:i2)=')'
          else if (ityp.eq.4) then
            if (i1.eq.1) then
              i2=ires
            else
              i2=ires+2
              vd(1:1)=quote
              vd(i2:i2)=quote
            end if
          else if (havexp) then
            print '(''*** Error: Illegal expression "'',
     *              A,''".'')',line(i:j-1)
            haverr=.true.
            go to 10
          else
            print '(''*** Error: Illegal variable or function call "'',
     *              A,''".'')',line(i:j-1)
            haverr=.true.
            go to 10
          end if
          vd(i2+1:)=' '
        else if (vardef(max(1,k)).eq.'NULL') then
          print '(''*** Error: Undefined variable "'',A,''".'')',
     *          line(i:j-1)
          haverr=.true.
          go to 10
        else
          i2=lenstr(vardef(k))
          if (line(i-1:i-1).eq.'$' .and. vardef(k)(1:1).eq.quote .and.
     *        vardef(k)(i2:i2).eq.quote) then
            vd=vardef(k)(2:i2-1)
            i2=i2-2
          else
            vd=vardef(k)(1:i2)
          end if
        end if
c       ........................ substring selection and Fortran formats
        i1=1
        ketket=havexp .and. line(j:j+1).eq.'}(' .and. e(j+1:j+1).ne.'E'
        if (ketket) j=j+1
        if (line(j:j).eq.'(') then
          nparen=1
          nostr=.true.
          do 375 l=j+1,ll
            if (line(l:l).eq.quote) nostr=.not.nostr
            if (nostr) then
              if (line(l:l).eq.'(') then
                nparen=nparen+1
              else if (nparen.gt.1 .and. line(l:l).eq.')') then
                nparen=nparen-1
              else
                if (line(l:l).eq.':') goto 376
                if (line(l:l).eq.')') then
                  iel=ieva(line(j+1:l-1),illexp)
c                  print *,'iel = ',iel
                  if (.not.illexp .and. iel.ge.1) then
                    str(1:i2)=vd(1:i2)
                    nc=0
                    nostvd=.true.
                    do 370 j2=1,i2
                      if (str(j2:j2).eq.quote) nostvd=.not.nostvd
                      if (nostvd .and. str(j2:j2).eq.',') then
                        nc=nc+1
                        ic(nc)=j2
                        if (nc.ge.iel) go to 371
                      end if
  370                 continue
  371               if (iel.gt.nc+1) then
                      vd(1:i2)=' '
                    else
                      if (iel.eq.1) then
                        j1=1
                      else
                        j1=ic(iel-1)+1
                      end if
                      if (iel.le.nc) then
                        j2=ic(iel)-1
                      else
                        j2=i2
                      end if
                      if (j1.le.j2) then
                        vd(1:i2)=str(j1:j2)
                        call lefstr(vd(1:i2))
                        i2=lenstr(vd(1:i2))
                        if (line(i-1:i-1).eq.'$' .and. 
     *                      vd(1:1).eq.quote .and.
     *                      vd(i2:i2).eq.quote) then
                          i2=i2-2
                          str(1:i2)=vd(2:i2+1)
                          vd(1:i2)=str(1:i2)
                        end if
                      else
                        vd(1:i2)=' '
                      end if
                    end if
                  else
                    fmt='('//line(j+1:l-1)//')'
                    if (max(index(fmt,'I'),index(fmt,'i')).gt.0) then
                      read (vd,'(BN,I40)',iostat=ios) idum
                      if (ios.le.0) write (vd,fmt,iostat=ios) idum
                    else
                      read (vd,'(BN,F40.0)',iostat=ios) dum
                      if (ios.le.0) write (vd,fmt,iostat=ios) dum
                    end if
                    if (ios.gt.0) then
                      print '(''*** Error: Illegal selector/format '',A,
     *                      '' for expression "'',A,''".'')',
     *                      fmt(1:lenstr(fmt)),vd(1:max(1,lenstr(vd)))
                      haverr=.true.
                      go to 10
                    end if
                  end if
                  i2=lenstr(vd)
                  go to 379
                end if
              end if
            end if
  375       continue
  376     if (l.ne.j+1) then
            if (line(j+1:l-1).ne.' ') then
              i1=ieva(line(j+1:l-1),illexp)
              if (illexp) then
                print '(''*** Error: Illegal expression "'',A,''".'')',
     *                line(j+1:l-1)
                haverr=.true.
                go to 10
              end if
            end if
          end if
          j=l
          id=0
          nostr=.true.
          do 377 l=j+1,ll
            if (line(l:l).eq.quote) nostr=.not.nostr
            if (nostr) then
              if (line(l:l).eq.'(') then
                id=id+1
              else if (line(l:l).eq.')') then
                if (id.eq.0) go to 378
                id=id-1
              end if
            end if
  377       continue
  378     if (l.ne.j+1) then
            if (line(j+1:l-1).ne.' ') then
              i2=ieva(line(j+1:l-1),illexp)
              if (illexp) then
                print '(''*** Error: Illegal expression "'',A,''".'')',
     *                line(j+1:l-1)
                haverr=.true.
                go to 10
              end if
            end if
          end if
  379     j=l+1
        end if
c       .......................................... remove curly brackets
        if (i.gt.2) then
          if (havexp .or. 
     *        (line(i-2:i-2).eq.'{' .and. e(i-2:i-2).ne.'E' .and.
     *         line(j:j).eq.'}' .and. e(j:j).ne.'E')) then
            i=i-1
            if (.not.ketket) j=j+1
          end if
        end if
c       ................................... insert value of the variable
        str(j:ll)=line(j:ll)
        l=max(1,i-2)
        quoted=line(l:l).eq.quote .and. line(j:j).eq.quote
        if (quoted) i2=max(1,i2)
        l=i-2
        do 38 ii=i1,i2
          l=l+1
          line(l:l)=vd(ii:ii)
          if (quoted .and. vd(ii:ii).eq.quote) then
            l=l+1
            line(l:l)=vd(ii:ii)
          end if
   38     continue
        kk=l+ll-j+1
        line(l+1:kk)=str(j:ll)
        str(j:ll)=e(j:ll)
        do 39 ii=i+1,l
   39     e(ii:ii)=e(i:i)
        e(l+1:kk)=str(j:ll)
        ll=kk
c        ll=lenstr(line)
c      print'(A)',line(1:lenstr(line)),e(1:lenstr(e))
      go to 30
      end if
      if (ll.eq.0 .and. .not.asking) go to 10
c     ---------------------- loop to extract command name and parameters
c      print'(A)','|'//line(1:lenstr(line))//'|',' '//e(1:lenstr(e))
      nparam=-1
      i=1
      cmd=' '
   40 continue
        do 41 j=i,ll
   41     if (line(j:j).gt.' ' .or. e(j:j).ne.' ') go to 42
        go to 45
   42   do 43 i=j,ll
   43     if (line(i:i).le.' ' .and. e(i:i).eq.' ') go to 44
c       -------------------------------- set command name and parameters
   44   nparam=nparam+1
        if (nparam.gt.min(maxp,maxpar)) then
          print '(''*** Error: Too many parameters.'')'
          haverr=.true.
          go to 10
        end if
c        print '(A)','|'//line(j:i-1)//'|'
        if (nparam.eq.0) then
          qcmd=e(j:i-1).ne.' '
          cmd=line(j:i-1)
          lcmd=i-j
        else
          param(nparam)=line(j:i-1)
          lp(nparam)=i-j
        end if
      go to 40
c     --------------------------- set variables according to "ask" input
   45 if (asking) then
c        print *,nparam,nask
        if (nparam+1.gt.nask) then
          print '(''*** Error: Too many parameters. Try again.'')'
          haverr=.true.
        else
          if (cmd.ne.' ')
     *      call setvar (askvar(1),cmd,var,vardef,reonly,
     *                   nvar,nsvar,nlvar,iunit,maxvar,iecho,haverr)
          do 46 k=2,nparam+1
            call setvar (askvar(k),param(k-1),var,vardef,reonly,
     *                   nvar,nsvar,nlvar,iunit,maxvar,iecho,haverr)
   46       continue
          asking=.false.
        end if
        go to 10
      end if
c      print '(''|'',A,''|'')',(param(i)(1:lenstr(param(i))),i=1,nparam)
c     ------------------------------------- echo commands read from file
c      print *,iecho
      if (iecho.lt.0) then
        iecho=0
        do 47 k=nvar,1,-1
          if (var(k).eq.'echo') then
            if (vardef(k).eq.'off') then
              iecho=1
            else if (vardef(k).eq.'on') then
              iecho=2
            else if (vardef(k).eq.'full') then
              iecho=3
            end if
            go to 48
          end if
  47      continue
      end if
  48  if (iecho.eq.0) then
        echful=.false.
        echon=iunit.gt.minuni
      else
        echful=iecho.eq.3
        echon=iecho.eq.2
      end if
   50 noecho=cmd(1:1).eq.'@'
      if (noecho) then
        echon=.false.
        str(2:lcmd)=cmd(2:lcmd)
        cmd(1:lcmd)=str(2:lcmd)
        lcmd=lcmd-1
      end if
      if (echful) call doecho (echful,cmd,param,nparam,lnr,iunit,filnam)
c     ------------------------------------------------------------ alias
      if (.not.qcmd) then
        i1=1
        i2=nalias
   51   if (i1.le.i2) then
          i=(i1+i2)/2
          if (cmd(1:lcmd).eq.alias(i)) then
c            print *,'binary ', i
            j=index(line,cmd(1:lcmd))
            l=lenstr(alidef(i))
            k=index(alidef(i)(1:l),'*')
            if (k.eq.0) then
              str(j+lcmd:ll)=line(j+lcmd:ll)
              line(j:)=alidef(i)(1:l)//str(j+lcmd:ll)
            else
              str(1:ll)=line(j+lcmd:ll)
              call lefstr (str(1:ll))
              line(j:)=alidef(i)(1:k-1)//str(1:lenstr(str(1:ll)))//
     *                 alidef(i)(k+1:l)
            end if
            go to 15
          else if (cmd(1:lcmd).lt.alias(i)) then
            i2=i-1
          else
            i1=i+1
          end if
          go to 51 
        end if
      end if
c     -------------------------------------------- assignment statements
      if (param(1)(1:lp(1)).eq.'=') then
        param(1)=cmd(1:lcmd)//'='
        lp(1)=lcmd+1
        cmd='eval'
        lcmd=4
      else if (param(1)(1:lp(1)).eq.':=') then
        param(1)=cmd(1:lcmd)//'='
        lp(1)=lcmd+1
        cmd='set'
        lcmd=3
      end if
c     ---------------------------------------------- "parameter" command
      if (cmd(1:lcmd).eq.'parameter') then
        if (.not.declar) then
          print '(''*** Error: Misplaced parameter statement.'')'
          haverr=.true.
        else if (nparam.eq.0) then
          print '(''*** Error: Missing variable name.'')'
          haverr=.true.
        else
          do 54 k=1,nparam
   54       var(nlvar(iunit)+k)=param(k)
        end if
        go to 10
c     ---------------------------------------------------- "var" command
      else if (cmd(1:lcmd).eq.'var') then
        if (.not.declar) then
          print '(''*** Error: Misplaced local variable declaration.'')'
          haverr=.true.
        else if (nvar+nparam.gt.maxvar) then
          print '(''*** Error: Too many variables.'')'
          haverr=.true.
        end if
        do 55 k=1,nparam
          nvar=nvar+1
          var(nvar)=param(k)
   55     vardef(nvar)='NULL'
        go to 10
      end if
      declar=.false.
c     ------------------------------------------------- "end if" command
      if (cmd(1:lcmd).eq.'end' .and. nparam.eq.1 .and. param(1).eq.'if') 
     *then
        if (nif.le.0) then
          print '(''*** Error: "end if" out of place.'')'
          haverr=.true.
        else
          if (mif.gt.0) mif=mif-1
          if (mif.eq.0) nif=nif-1
        end if
        go to 10
c     --------------------------------------------------- "else" command
      else if (cmd(1:lcmd).eq.'else') then
        if (nif.le.0) then
          print '(''*** Error: "else" out of place.'')'
          haverr=.true.
c       .................................................. simple "else"
        else if (nparam.eq.0) then
          if (mif.le.1)  mif=1-mif
c       ...................................................... "else if"
        else if (param(1).eq.'if') then
          if (mif.eq.1) then
            mif=0
            nif=nif-1
            cmd=param(1)
            lcmd=lp(1)
            do 510 k=2,nparam
              param(k-1)=param(k)
  510         lp(k-1)=lp(k)
            nparam=nparam-1 
            go to 550 
          else if (mif.eq.0) then
            mif=1
          end if
        else
          print '(''*** Error: Illegal parameter "'',A,''".'')',
     *            param(1)(1:lp(1))
          haverr=.true.
        end if
        go to 10
c     -------------------------------------------------- "end do" command
      else if (cmd(1:lcmd).eq.'end' .and. nparam.eq.1 .and. 
     *         param(1)(1:lp(1)).eq.'do') then
        if (nloop.le.0 .and. mloop.le.0) then
          print '(''*** Error: "end do" out of place.'')'
          haverr=.true.
        else if (mloop.gt.0) then
          mloop=mloop-1
        else
          lopcnt(nloop)=lopcnt(nloop)+lopinc(nloop)
          if (lopinc(nloop).ne.0) then
            call intstr (lopcnt(nloop),str(1:10))
            call setvar (lopvar(nloop),str(1:10),var,vardef,reonly,
     *                   nvar,nsvar,nlvar,iunit,maxvar,iecho,haverr)
          end if
c         ..................................... loop is not yet finished
          if ((lopinc(nloop).ge.0 .and. 
     *         lopcnt(nloop).le.lopend(nloop)) .or.
     *        (lopinc(nloop).lt.0 .and. 
     *         lopcnt(nloop).ge.lopend(nloop))) then
            if (laslnr(iunit).le.0) then
              rewind (iunit)
              do 520 k=1,loopnr(nloop)
  520           read (iunit,'()')
            end if
            lnr(iunit)=loopnr(nloop)
c         .............................................. loop is finished
          else
            nloop=nloop-1
          end if
        end if
        go to 10
      end if
      if (mif.gt.0 .or. mloop.gt.0) go to 10
c     ---------------------------------------- convert "go to" to "goto"
  550 if (cmd(1:lcmd).eq.'go' .and. nparam.ge.1 .and. 
     *    param(1)(1:lp(1)).eq.'to') then
        nparam=nparam-1
        cmd='goto'
        lcmd=4
        param(1)=param(2)
        lp(1)=lp(2)
      end if
c     --------------------------------------------------- "quit" command
      if (cmd(1:lcmd).eq.'quit') then
        if (nparam.gt.0) then
          print '(''*** Error: Illegal number of parameters.'')'
          haverr=.true.
          go to 10
        end if
        stop
c     ----------------------------------------------------- "if" command
      else if (cmd(1:lcmd).eq.'if') then
        if (nparam.lt.1) then
          print '(''*** Error: Illegal number of parameters.'')'
          haverr=.true.
        else if (nif.ge.maxif) then
          print '(''*** Error: Too many nested "if" commands.'')'
          haverr=.true.
        else if (param(1)(1:1).ne.'(') then
          print '(''*** Error: Missing "(" after "if".'')'
          haverr=.true.
        else
c         ................................... isolate logical expression
c          str=' '
          l=0
          m=0
          nostr=.true.
          do 90 k=1,nparam
            do 90 kk=1,lp(k)
              if (param(k)(kk:kk).eq.quote) nostr=.not.nostr
              if (nostr .and. param(k)(kk:kk).eq.'(') then
                m=m+1
              else if (nostr .and. param(k)(kk:kk).eq.')') then
                m=m-1
              end if
              l=l+1
              str(l:l)=param(k)(kk:kk)
   90         if (m.eq.0) go to 95
          print '(''*** Error: Missing ")".'')'
          haverr=.true.
          go to 10
c         .................................. evaluate logical expression
   95     yes=leva(str(2:l-1),illexp)
          if (illexp) then
            print '(''*** Error: Illegal logical expression "'',A,
     *            ''".'')',str(2:l-1)
            haverr=.true.
c         ............ treat command that follows the logical expression
          else
            cmd=param(k+1)
            lcmd=lp(k+1)
            do 98 l=k+2,nparam
              param(l-k-1)=param(l)
   98         lp(l-k-1)=lp(l)
            nparam=nparam-k-1
            if (cmd(1:lcmd).eq.'then') then
              if (nparam.ne.0) then
                print '(''*** Error: Illegal use of "then".'')'
                haverr=.true.
              else
                nif=nif+1
                if (.not.yes) mif=1
                ifdone(nif)=ifdone(nif).or.yes
              end if
            else if (yes) then
              go to 50
c              go to 550            
            end if
          end if
        end if
        go to 10
c     ----------------------------------------------------- "do" command
      else if (cmd(1:lcmd).eq.'do') then
        if (iunit.le.minuni) then
          print '(''*** Error: Loops are only allowed in macros.'')'
          haverr=.true.
        else if (nloop.ge.maxlop) then
          print '(''*** Error: Too many nested loops.'')'
          haverr=.true.
        else if (nparam.ne.0 .and. nparam.ne.3 .and. nparam.ne.4) then
          print '(''*** Error: Illegal number of parameters.'')'
          haverr=.true.
        else
          loopnr(nloop+1)=lnr(iunit)
          lopnif=nif
          lopmif=mif
c         ........................................... unconditional loop
          if (nparam.eq.0) then
            nloop=nloop+1
            lopcnt(nloop)=0
            lopend(nloop)=1
            lopinc(nloop)=0
c         ......................................... loop with loop count
          else
            lopvar(nloop+1)=param(1)(1:lp(1))
            lopinc(nloop+1)=1
            do 106 k=2,nparam
              l=ieva(param(k)(1:lp(k)),illexp)
              if (illexp) then
                print '(''*** Error: Illegal expression "'',A,''".'')',
     *                param(k)(1:lp(k))
                haverr=.true.
                go to 10
              else if (k.eq.2) then
                lopcnt(nloop+1)=l
              else if (k.eq.3) then
                lopend(nloop+1)=l
              else if (k.eq.4) then
                lopinc(nloop+1)=l
              end if
  106         continue
            call intstr (lopcnt(nloop+1),str(1:10))
            call setvar (lopvar(nloop+1),str(1:10),var,vardef,reonly,
     *                   nvar,nsvar,nlvar,iunit,maxvar,iecho,haverr)
c           ........................................... loop is executed
            if ((lopinc(nloop+1).ge.0 .and. 
     *           lopcnt(nloop+1).le.lopend(nloop+1)) .or.
     *          (lopinc(nloop+1).lt.0 .and. 
     *           lopcnt(nloop+1).ge.lopend(nloop+1))) then
              nloop=nloop+1
c           ........ loop is not executed, search corresponding "end do"
            else
              mloop=1      
            end if
          end if
        end if
        go to 10
c     --------------------------------------------------- "goto" command
      else if (cmd(1:lcmd).eq.'goto') then
        if (cmd(1:lcmd).eq.'goto' .and. nparam.ne.1) then
          print '(''*** Error: Illegal number of labels.'')'
          haverr=.true.
        else if (iunit.le.minuni) then
          print '(''*** Error: Jumps are only allowed in macros.'')'
          haverr=.true.
        else
          going=.true.
          nsulev=0
          label=param(1)(1:lp(1))
          if (laslnr(iunit).le.0) rewind (iunit)
          lnr(iunit)=0
          linbuf(iunit)=' '
          nif=nifbeg(iunit)
          mif=0
          nloop=lopbeg(iunit)
          mloop=0 
        end if
        go to 10
c     -------------------------------------------------- "break" command
      else if (cmd(1:lcmd).eq.'break') then
        if (nparam.ne.0) then
          print '(''*** Error: "break" must not have parameters.'')'
          haverr=.true.
        else if (nloop.le.0) then
          print '(''*** Error: "break" can only stand within a loop.'')'
          haverr=.true.
        else
          nif=lopnif
          mif=lopmif
          nloop=nloop-1
          mloop=1
        end if
        go to 10
c     ------------------------------------------------- "return" command
      else if (cmd(1:lcmd).eq.'return') then
        if (nparam.ne.0) then
          print '(''*** Error: Illegal "return" command.'')'
          haverr=.true.
        else
          if (iunit.le.minuni) stop
          if (laslnr(iunit).le.0) close (iunit)
          nvar=nlvar(iunit)-1
          nif=nifbeg(iunit)
          mif=0
          nloop=lopbeg(iunit)
          mloop=0
          going=.false.
          iunit=iunit-1
c          if (iunit.le.minuni) print '(''... Ready.'')'
        end if
        go to 10
c     --------------------------------------------------- "exit" command
      else if (cmd(1:lcmd).eq.'exit') then
        if (nparam.gt.0) then
          print '(''*** Error: "exit" must not have parameters.'')'
          haverr=.true.
        else
          if (iunit.le.minuni) stop
          do 56 k=iunit,minuni+1,-1
   56       if (laslnr(k).le.0) close (k)
          nvar=nlvar(minuni+1)-1
          iunit=minuni
          nif=nifbeg(minuni+1)
          mif=0
          nloop=0
          mloop=0
          going=.false.
c          print '(''... Ready.'')'
        end if
        go to 10
c     ---------------------------------------------------- "ask" command
      else if (cmd(1:lcmd).eq.'ask') then
        if (nparam.lt.2) then
          print '(''*** Error: Illegal number of parameters.'')'
          haverr=.true.
        else
          prompt=param(1)(1:lp(1))
          nask=nparam-1
          do 57 k=1,nask
   57       askvar(k)=param(k+1)(1:lp(k+1))
          asking=.true.
        end if
        go to 10
c     ------------------------------ "command" and "subroutine" commands
      else if (cmd(1:lcmd).eq.'command' .or. 
     *         cmd(1:lcmd).eq.'subroutine') then
        if (nparam.eq.0 .and. cmd(1:lcmd).eq.'command') then
          if (nsub.le.0) then
            print '(''... No user-defined commands.'')'
          else
            print '(''... User-defined commands:'')'
            l=0
            do 572 i=1,nsub
              do 571 j=i+1,nsub
  571           if (sublin(isub(i)).eq.sublin(isub(j))) go to 572
              l=max(l,lenstr(sublin(isub(i))))
  572         continue
            do 574 i=1,nsub
              do 573 j=i+1,nsub
  573           if (sublin(isub(i)).eq.sublin(isub(j))) go to 574
              print '(4X,A,'' from macro "'',A,''"'')',
     *              sublin(isub(i))(1:l),filsub(i)(1:lenstr(filsub(i)))
  574         continue  
          end if
        else if (iunit.le.minuni) then
          print 
     *      '(''*** Error: Subroutines are only allowed in macros.'')'
          haverr=.true.
        else if (nparam.lt.1) then
          print '(''*** Error: Illegal number of parameters.'')'
          haverr=.true.
        else if (nsub.ge.maxsub) then
          print '(''*** Error: Too many subroutines or commands.'')'
          haverr=.true.
        else
          str='parameter'
          do 578 k=2,nparam
  578       str(lenstr(str)+2:)=param(k)
          if (cmd(1:lcmd).eq.'command') then
            iusub(nsub+1)=minuni
            subbuf(1)=param(1)
            if (nparam.gt.1) subbuf(2)=str
          else
            iusub(nsub+1)=iunit
            sublin(isub(nsub+1))=param(1)
            if (nparam.gt.1) sublin(isub(nsub+1)+1)=str
          end if
          filsub(nsub+1)=filnam(iunit)
          nbuf=min(2,nparam)
          loadin=.true.
          nsulev=0
        end if
        go to 10
c     ------------------------------- "eval", "show", and "set" commands
      else if (cmd(1:lcmd).eq.'eval' .or. cmd(1:lcmd).eq.'set' .or.
     *    cmd(1:lcmd).eq.'show') then
c        t7=timnow()
        str=' '
        ll=0
        do 581 kk=1,nparam
          k=ll+lp(kk)+1
          str(ll+1:k)=param(kk)(1:lp(kk))
  581     ll=k
        ll=ll-1
        if (ll.gt.0) then 
          call lefstr (str(1:ll))
          l=index(str(1:ll),'=')
          if (l.gt.1) then
            if (str(l-1:l-1).eq.':') str(l-1:l-1)=' '
          end if
        end if
        if (ll.gt.0 .and. l.gt.0) then
c         ............................................ define a variable
          if (cmd(1:lcmd).eq.'show') then
            print '(''*** Error: Illegal parameter "=".'')'
            haverr=.true.
          else if (l.eq.1) then
            print '(''*** Error: Missing variable name.'')'
            haverr=.true.
          else
            ll=max(l+1,ll)
            call lefstr (str(l+1:ll))
            if (cmd(1:lcmd).eq.'eval') then
c             ...................................... evaluate expression
              call eva (str(l+1:ll),ires,res,cres,str(l+2:),ityp)
              if (ityp.lt.1 .or. ityp.gt.4) then
c                print '(''ityp ='',I5)',ityp
                print '(''*** Error: Illegal expression "'',A,''".'')',
     *                str(l+1:lenstr(str))
                haverr=.true.
                go to 10
              else 
c               ............................... store result in variable
                if (ityp.eq.1) then
                  ll=l+10
                  call intstr (ires,str(l+1:ll))
                else if (ityp.eq.2) then
                  ll=l+20
                  write (str(l+1:ll),'(1PG20.6)') res
                  call lefstr (str(l+1:ll))
                else if (ityp.eq.3) then
                  str(l+1:l+1)='('
                  write (str(l+2:l+21),'(1PG20.6)') real(cres)
                  call lefstr (str(l+2:l+21))
                  kk=lenstr(str(1:l+21))
                  str(kk+1:kk+1)=','
                  write (str(kk+2:kk+21),'(1PG20.6)') aimag(cres)
                  call lefstr (str(kk+2:kk+21))
                  ll=lenstr(str(1:kk+21))+1
                  str(ll:ll)=')'
                else
                  ll=l+ires+2
                  str(l+1:l+1)=quote
                  str(ll:ll)=quote
                end if
              end if
            end if
            call setvar (str(1:l-1),str(l+1:ll),var,vardef,reonly,
     *                   nvar,nsvar,nlvar,iunit,maxvar,iecho,haverr)
          end if
        else if (cmd(1:lcmd).eq.'eval') then
          print '(''*** Error: Missing "=".'')'
          haverr=.true.
        else 
c         ............................................... list variables
          if (cmd(1:lcmd).eq.'set' .or. iunit.le.minuni) then
            nv=nvar
          else
            nv=nlvar(minuni+1)-1
          end if
          l=0
          do 61 k=1,nv
            if (cmd(1:lcmd).eq.'set') then
              do 59 kk=k+1,nvar
   59           if (var(k).eq.var(kk)) go to 61
            end if
            if (nparam.eq.0) then
              if (vardef(k).ne.'NULL') l=max(l,lenstr(var(k)))
            else
              do 60 kk=1,nparam
c                if (var(k).eq.param(kk)(1:lp(kk))) then
                if (match(var(k),param(kk)(1:lp(kk)))) then
                  l=max(l,lenstr(var(k)))
                  go to 61
                end if
   60           continue
            end if
   61       continue
          if (l.eq.0) then
            if (cmd(1:lcmd).eq.'set') then
              print '(''... No variables defined.'')'
            else
              print '(''... No global variables defined.'')'
            end if
          else 
            if (cmd(1:lcmd).eq.'set') then
              print '(''... Variables:'')'
            else
              print '(''... Global variables:'')'
            end if
            do 70 k=1,nv
              do 63 kk=minuni+1,iunit-1
   63           if (k.ge.nlvar(kk) .and. k.le.nlvar(kk)+nparam) go to 70
              visibl=.true.
              do 66 kk=k+1,nvar
                if (var(k).eq.var(kk)) then
                  visibl=.false.
                  go to 68
                end if
   66           continue
              if (nparam.eq.0) then
                if (vardef(k).eq.'NULL') go to 70
              else
                do 67 kk=1,nparam
c   67             if (var(k).eq.param(kk)(1:lp(kk))) go to 68
   67             if (match(var(k),param(kk)(1:lp(kk)))) go to 68
                go to 70
              end if
   68         if (visibl) then
                if (reonly(k)) then
                  print '(4X,A,'' = '',A,'' (read-only)'')',
     *                  var(k)(1:l),vardef(k)(1:lenstr(vardef(k)))
                else
                  print '(4X,A,'' = '',A)',
     *                  var(k)(1:l),vardef(k)(1:lenstr(vardef(k)))
                end if
              else if (cmd(1:lcmd).eq.'show') then
                if (reonly(k)) then
                  print '(4X,A,'' = '',A,'' (read-only, hidden)'')',
     *                  var(k)(1:l),vardef(k)(1:lenstr(vardef(k)))
                else
                  print '(4X,A,'' = '',A,'' (hidden)'')',
     *                  var(k)(1:l),vardef(k)(1:lenstr(vardef(k)))
                end if
              end if
   70         continue
          end if
        end if 
c        timer(7)=timer(7)+timnow()-t7
        go to 10
c     -------------------------------------------------- "alias" command
      else if (cmd(1:lcmd).eq.'alias') then
        if (nparam.eq.0) then
          if (nalias.le.0) then
            print '(''... No aliases.'')'
          else
            l=0
            do 71 i=1,nalias
   71         l=max(l,lenstr(alias(i)))
            print '(''... Aliases:'')'
            print '(4X,A,2X,A)',(alias(i)(1:l),
     *            alidef(i)(1:lenstr(alidef(i))),i=1,nalias)
          end if
        else if (nparam.ne.2) then
          print '(''*** Error: Illegal number of parameters.'')'
          haverr=.true.
        else
          do 72 i=1,nalias
   72       if (alias(i).ge.param(1)) go to 73
   73     if (i.gt.nalias .or. alias(i).gt.param(1)) then
            if (nalias.ge.maxali) then
              print '(''*** Error: Too many aliases.'')'
              haverr=.true.
              go to 10
            end if
            do 74 j=nalias,i,-1
              alias(j+1)=alias(j)
   74         alidef(j+1)=alidef(j)
            nalias=nalias+1
          end if
          alias(i)=param(1)
          alidef(i)=param(2)
        end if
        go to 10
c     ------------------------------------- "print" and "error" commands
      else if (cmd(1:lcmd).eq.'print' .or. cmd(1:lcmd).eq.'error') then
        if (nparam.gt.4) then
          print '(''*** Error: Illegal number of parameters.'')'
          haverr=.true.
        else if (nparam.eq.0) then
          print '()'
        else if (nparam.eq.1) then
          print '(A)',param(1)(1:lp(1))
        else
          inquire (file=param(1)(1:lp(1)),opened=yes,number=ifil)
          appfil=yes
          clofil=.false.
          do 75 j=3,nparam
            if (param(j)(1:lp(j)).eq.'close') then
              clofil=.true.
            else if (param(j)(1:lp(j)).eq.'append') then
              appfil=.true.
            else
              print '(''*** Error: Illegal parameter "'',A,''".'')',
     *              param(j)(1:lp(j))
              haverr=.true.
              go to 10
            end if
   75       continue
          if (.not. yes) then
            do 76 ifil=maxuni+1,nfil
              inquire (unit=ifil,opened=yes)
   76         if (.not.yes) go to 77
   77       if (ifil.gt.maxfil) then
              print '(''*** Error: Too many open files.'')'
              haverr=.true.
              go to 10
            end if
            nfil=max(nfil,ifil)
            open (ifil,file=param(1)(1:lp(1)),iostat=ios)
            if (ios.gt.0) then
              print '(''*** Error: File "'',A,''" cannot be opened.'')',
     *              param(1)(1:lp(1))
              haverr=.true.
              go to 10
            else if (appfil) then
   80         read (ifil,'()',end=85)
              go to 80
   85         continue
            end if
          end if
          write (ifil,'(A)') param(2)(1:lp(2))
          if (clofil) then
            close (ifil)
            if (ifil.eq.nfil) nfil=nfil-1
          end if
        end if
        if (cmd(1:lcmd).eq.'error') haverr=.true.
        go to 10
c     --------------------------------------------------- "type" command
      else if (cmd(1:lcmd).eq.'type') then
        if (nparam.ne.1) then
          print '(''*** Error: Illegal number of parameters.'')'
          haverr=.true.
          go to 10
        end if
        do 105 jsub=nsub,1,-1
          if (sublin(isub(jsub)).eq.param(1)) then
            if (iusub(jsub).le.minuni) then
              print '(''command '',A)',
     *              sublin(isub(jsub))(1:lenstr(sublin(isub(jsub))))
            else
              print '(''subroutine '',A)',
     *              sublin(isub(jsub))(1:lenstr(sublin(isub(jsub))))
            end if
            print '(A)',(sublin(k)(1:lenstr(sublin(k))),
     *                   k=isub(jsub)+1,isub(jsub+1)-1),'end'
            go to 10
          end if
  105     continue
        havpas=.false.
        do 109 l=1,len(dirend)
  109     havpas=havpas .or. index(param(1)(1:lp(1)),dirend(l:l)).gt.0
        if (havpas) then
          str=param(1)(1:lp(1))//macext
        else
          do 110 k=nvar,1,-1
  110       if (var(k).eq.'path') go to 111
          print '(''*** Error: No such macro or subroutine.'')'
          haverr=.true.
          go to 10
  111     path=vardef(k)
        end if
  112   continue
          if (.not.havpas) then
            call lefstr(path)
            lpath=index(path,',')-1
            if (lpath.lt.0) then
              lpath=lenstr(path)
              if (lpath.lt.1) then
                print '(''*** Error: No such macro or subroutine.'')'
                haverr=.true.
                go to 10
              end if
            end if
            str=path
            path=str(lpath+2:)
            if (lpath.eq.0) go to 112
            str(lpath+1:)='/'//param(1)(1:lp(1))//macext
          end if
          inquire (file=str,exist=yes)
          if (yes) then
            if (iunit.ge.maxuni) then
              print '(''*** Error: Too many open macro files.'')'
              haverr=.true.
              go to 10
            end if
            open (iunit+1,file=str,status='old',err=140)
  118       read (iunit+1,'(A)',end=120) str
              print '(A)',str(1:lenstr(str))
            go to 118
  120       close (iunit+1)            
            go to 10
          end if
        if (.not. havpas) go to 112
  140   print '(''*** Error: Macro file "'',A,
     *          ''" cannot be opened.'')',str(1:lenstr(str))
        haverr=.true.
        go to 10
c     --------------------------------------------------- "help" command
      else if (cmd(1:lcmd).eq.'help') then
        if (iunit.ge.maxuni) then
          print '(''*** Error: Too many open files.'')'
          haverr=.true.
          go to 10
        end if
        ntopic=0
        if (nparam.eq.0) go to 170
        topic=param(1)
        do 142 k=2,nparam
  142     topic(lenstr(topic)+1:)='_'//param(k)
  143   havpas=.false.
        do 145 l=1,len(dirend)
  145     havpas=havpas .or. index(topic,dirend(l:l)).gt.0
        if (havpas) then
          str=topic(1:lenstr(topic))//macext
c       ........................................... help from help files
        else
          str=hlpdir(1:lenstr(hlpdir))//'/'//topic
          inquire (file=str,exist=yes)
          if (yes) then
            open (iunit+1,file=str,status='old',err=170)
            print '()'
            nline=0
  147       read (iunit+1,'(A)',end=148) str
              nline=nline+1
              if (nline.eq.1 .or. topic.eq.'topics') then
                k=index(str,':')
                if (k.gt.0 .and. k.lt.index(str,' - ')) then
                  str2=str(k+1:)
                  str=str2
                  call lefstr(str)
                end if
              end if
              print '(A)',str(1:lenstr(str))
            go to 147
  148       close (iunit+1)
            print '()'
            go to 10
          end if
          do 150 k=nvar,1,-1
  150       if (var(k).eq.'path') go to 151
          go to 170
  151     path=vardef(k)
        end if
c       ................................................ help for macros
  152   continue
          if (.not.havpas) then
            call lefstr(path)
            lpath=index(path,',')-1
            if (lpath.lt.0) then
              lpath=lenstr(path)
              if (lpath.lt.1) go to 170
            end if
            str=path
            path=str(lpath+2:)
            if (lpath.eq.0) go to 152
            str(lpath+1:)='/'//topic(1:lenstr(topic))//macext
          end if
          inquire (file=str,exist=yes)
          if (yes) then
            open (iunit+1,file=str,status='old',err=170)
            havhlp=.false.
            nline=0
  160       read (iunit+1,'(A)',end=162) str2
              if (str2(1:3).eq.'## ') then
                if (.not.havhlp) print '()'
                havhlp=.true.  
                str=str2(4:)
                nline=nline+1
                if (nline.eq.1) then
                  k=index(str,':')
                  if (k.gt.0 .and. k.lt.index(str,' - ')) then
                    str2=str(k+1:)
                    str=str2
                    call lefstr(str)
                  end if
                end if
                print '(A)',str(1:lenstr(str))
              end if
            go to 160
  162       close (iunit+1)
            if (.not.havhlp) go to 170            
            print '()'
            go to 10
          end if
        if (.not. havpas) go to 152
c       ............................................... help topics list
  170   if (ntopic.ne.0) then
          print '(''*** Error: Help topics list is not up to date.'')'
          haverr=.true.
          go to 10
        end if
        str=hlpdir(1:lenstr(hlpdir))//'/topics'
        inquire (file=str,exist=yes)
        if (.not.yes) then
          print '(''*** Error: Help topics list cannot be opened.'')'
          haverr=.true.
          go to 10
        end if
        open (iunit+1,file=str,status='old',err=170)
        ntopic=0
        group=' '
  172   read (iunit+1,'(A)',end=190) str
          do 173 k=1,nparam
            if (index(str,param(k)(1:lenstr(param(k)))).le.0) 
     *        go to 172
  173       continue
          pgroup=group
          group=' '
          k=index(str,':')
          if (k.gt.0 .and. k.lt.index(str,' - ')) then
            do 175 l=1,k
              if ((str(l:l).ge.'A' .and. str(l:l).le.'Z') .or.
     *            (str(l:l).ge.'a' .and. str(l:l).le.'z')) go to 176
  175         continue
  176       do 177 j=k,l,-1
              if ((str(j:j).ge.'A' .and. str(j:j).le.'Z') .or.
     *            (str(j:j).ge.'a' .and. str(j:j).le.'z')) go to 178
  177         continue
  178       group=str(l:j)
            str2=str(k+1:)
            str=str2
            call lefstr(str)
          end if
          k=index(str,' - ')
          if (k.gt.0 .and. k.lt.12) then
            str2=str(k:)
            str(k:)=' '
            str(12:)=str2
          end if
          ntopic=ntopic+1
          if (ntopic.eq.1) then
            str1=str
            l=index(str,' - ')
            k=index(str(1:l),',')
            if (k.gt.0) l=k
            topic=str(1:l-1)
            do 180 k=1,lenstr(topic)
  180         if (topic(k:k).le.' ') topic(k:k)='_'
          else 
            if (ntopic.eq.2) then
              print '(''... Help topics:'')'
              if (pgroup.ne.' ') 
     *          print '(/4X,A,'':'')',pgroup(1:lenstr(pgroup))
              print '(4X,A)',str1(1:lenstr(str1))
            end if
            if (group.ne.pgroup) then
              print '()' 
              if (group.ne.' ') 
     *          print '(4X,A,'':'')',group(1:lenstr(group))
            end if
            print '(4X,A)',str(1:lenstr(str))
          end if
        go to 172
  190   close (iunit+1)
        if (ntopic.eq.1) go to 143
        if (ntopic.le.0) then
          print '(''*** Error: No help about the topic "'',A,''".'')',
     *          topic(1:lenstr(topic))
          haverr=.true.
        end if
        go to 10
      end if
c     -------------------------------------------------- subroutine call
      do 192 jsub=nsub,1,-1
  192   if (sublin(isub(jsub)).eq.cmd) go to 193
      go to 199
  193 mode=0
      if (iunit.ge.maxuni) then
        print '(''*** Error: Too many open macro files.'')'
        haverr=.true.
        go to 10
      else if (nvar+1+nparam.gt.maxvar) then
        print '(''*** Error: Too many variables.'')'
        haverr=.true.
        go to 10
      end if
      iunit=iunit+1
      declar=.true.
      nifbeg(iunit)=nif
      lopbeg(iunit)=nloop
      lnr(iunit)=0
      filnam(iunit)=filsub(jsub)(1:lenstr(filsub(jsub)))//':'//cmd
      do 195 l=1,isub(jsub+1)-isub(jsub)-1
  195   maclin(l,iunit)=sublin(isub(jsub)+l)
      laslnr(iunit)=l-1
c     ........................ set variables with command line parameters
      nlvar(iunit)=nvar+1
      nvar=nvar+1
      var(nvar)='nparam'
      if (nparam.eq.0) then
        vardef(nvar)='0'
      else
        vardef(nvar)=defpar(nparam)(2:5)
      end if
      do 198 l=1,nparam
        nvar=nvar+1
        var(nvar)=defpar(l)
  198   vardef(nvar)=param(l)(1:lp(l))
      go to 10
c     ------------------------------------------ treat external commands
  199 if (echon) call doecho (echful,cmd,param,nparam,lnr,iunit,filnam)
      echon=.false.
      go to 900
c     ----------------------------------------------------- treat macros
  200 if (echon) call doecho (echful,cmd,param,nparam,lnr,iunit,filnam)
      if (mode.ne.2) mode=0
      havpas=.false.
      do 205 l=1,len(dirend)
  205     havpas=havpas .or. index(cmd(1:lcmd),dirend(l:l)).gt.0
      if (havpas) then
        str=cmd(1:lcmd)//macext
      else
        do 210 k=nvar,1,-1
  210     if (var(k).eq.'path') go to 215
        if (mode.eq.2) go to 900
        print '(''*** Error: Illegal command.'')'
        haverr=.true.
        go to 10
  215   path=vardef(k)
      end if
  220 continue
        if (.not.havpas) then
          call lefstr(path)
          lpath=index(path,',')-1
          if (lpath.lt.0) then
            lpath=lenstr(path)
            if (lpath.lt.1) then
              if (mode.eq.2) go to 900
              print '(''*** Error: Illegal command.'')'
              haverr=.true.
              go to 10
            end if
          end if
          str=path
          path=str(lpath+2:)
          if (lpath.eq.0) go to 220
          str(lpath+1:)='/'//cmd(1:lcmd)//macext
        end if      
c       ------------------------------------------------ open macro file
        inquire (file=str,exist=yes)
c        print *,str,yes
        if (yes) then
          mode=0
          if (iunit.ge.maxuni) then
            print '(''*** Error: Too many open macro files.'')'
            haverr=.true.
            go to 10
          else if (nvar+1+nparam.gt.maxvar) then
            print '(''*** Error: Too many variables.'')'
            haverr=.true.
            go to 10
          end if
          open (iunit+1,file=str,status='old',iostat=ios)
          if (ios.gt.0) then
            print '(''*** Error: Macro file "'',A,
     *              ''" cannot be opened.'')',str(1:lenstr(str))
            haverr=.true.
            go to 10
          end if
          iunit=iunit+1
          declar=.true.
          nifbeg(iunit)=nif
          lopbeg(iunit)=nloop
          lnr(iunit)=0
          linbuf(iunit)=' '
          filnam(iunit)=str(1:lenstr(str)-lenstr(macext))
c         ................................. load short macro into memory
          do 240 l=1,maxlnr
            read (iunit,'(A)',iostat=ios) maclin(l,iunit)
            if (ios.lt.0) then
              laslnr(iunit)=l-1
              close (iunit)
              go to 250
            else if (ios.gt.0) then
              print '(''*** Error: Macro file "'',A,
     *                ''" cannot be loaded.'')',str(1:lenstr(str))
              haverr=.true.
              go to 10
            end if
  240       continue
          laslnr(iunit)=0
          rewind(iunit)
c         ................... set variables with command line parameters
  250     nlvar(iunit)=nvar+1
          nvar=nvar+1
          var(nvar)='nparam'
          if (nparam.eq.0) then
            vardef(nvar)='0'
          else
            vardef(nvar)=defpar(nparam)(2:5)
          end if
          do 290 l=1,nparam
            nvar=nvar+1
            var(nvar)=defpar(l)
  290       vardef(nvar)=param(l)(1:lp(l))
          go to 10
        end if
      if (.not.havpas) go to 220
      if (mode.eq.2) go to 900
      print '(''*** Error: Illegal command.'')'
      haverr=.true.
      go to 10
  900 continue
c     timer(1)=timer(1)+timnow()-t0
      end
c     ==================================================================
      subroutine setvar (v,vd,var,vardef,reonly,nvar,
     *                   nsvar,nlvar,iunit,maxvar,iecho,haverr)
c
c      common /timdat/timer(100)
      character quote
      parameter (minuni=10,maxuni=20,quote='''',maxlin=250)
      dimension nlvar(minuni:maxuni),ic(maxlin)
      logical reonly(maxvar),haverr,nostr,illexp,init,idch(0:255)
      character*(*) v,vd,var(maxvar),vardef(maxvar),varsav*(maxlin),
     *              str*(maxlin),ch*1
      save init,idch
      data init/.true./
c
c      t0=timnow()
      if (init) then
        do 4 l=0,255
          ch=char(l)
          idch(l)=(ch.ge.'0' .and. ch.le.'9') .or.
     *            (ch.ge.'a' .and. ch.le.'z') .or.
     *            (ch.ge.'A' .and. ch.le.'Z') .or. ch.eq.'_'
    4     continue
        init=.false.
      end if
      lenvd=len(vardef(1))
c     ---------------------------------------------- substring selection
      i1=1
      i2=lenvd
      iel=0
      j=index(v,'(')
      if (j.le.0) then
        j=lenstr(v)
      else if (j.eq.1) then
        print '(''*** Error: Missing variable name.'')'
        haverr=.true.
        go to 990
      else
        nparen=1
        nostr=.true.
        do 10 l=j+1,lenvd
          if (v(l:l).eq.quote) nostr=.not.nostr
          if (nostr) then
            if (v(l:l).eq.'(') then
              nparen=nparen+1
            else if (nparen.gt.1 .and. v(l:l).eq.')') then
              nparen=nparen-1
            else
              if (v(l:l).eq.':') goto 20
              if (v(l:l).eq.')') then
                iel=ieva(v(j+1:l-1),illexp)
                if (illexp .or. iel.lt.1) then
                  print '(''*** Error: Illegal selection "'',A,
     *                    ''".'')',v(1:lenstr(v))
                  haverr=.true.
                  go to 990
                end if
                go to 90
              end if
            end if
          end if
   10     continue
   20   if (l.ne.j+1) then
          if (v(j+1:l-1).ne.' ') then
            i1=ieva(v(j+1:l-1),illexp)
            if (illexp) then
              print '(''*** Error: Illegal expression "'',A,''".'')',
     *              v(j+1:l-1)
              haverr=.true.
              go to 990
            end if
          end if
        end if
        j=l
        id=0
        nostr=.true.
        do 30 l=j+1,lenvd
          if (v(l:l).eq.quote) nostr=.not.nostr
          if (nostr) then
            if (v(l:l).eq.'(') then
              id=id+1
            else if (v(l:l).eq.')') then
              if (id.eq.0) go to 40
              id=id-1
            end if
          end if
   30     continue
   40   if (l.ne.j+1) then
          if (v(j+1:l-1).ne.' ') then
            i2=ieva(v(j+1:l-1),illexp)
            if (illexp) then
              print '(''*** Error: Illegal expression "'',A,''".'')',
     *              v(j+1:l-1)
              haverr=.true.
              go to 990
            end if
          end if
        end if
        if (i1.lt.1 .or. i1.gt.i2 .or. i2.gt.lenvd) then
          print '(''*** Error: Illegal substring selection "'',A,
     *          ''".'')',v(1:lenstr(v))
          haverr=.true.
          go to 990
        end if
   90   j=index(v,'(')-1
      end if
c     ---------------------------------------------- check variable name
      do 100 k=1,j
        if (.not.idch(ichar(v(k:k)))) then
          print '(''*** Error: Illegal variable name "'',A,''".'')',
     *          v(1:j)
          haverr=.true.
          go to 990
        end if
  100   continue
c     --------------------------------------- look for existing variable
      do 110 k=nvar,1,-1
  110   if (var(k).eq.v(1:j)) go to 140
c     ---------------------------------------------- create new variable
      if (nvar.eq.maxvar) then
        print '(''*** Fatal error: Too many variables.'')'
        stop
      end if
      nvar=nvar+1
      if (iunit.le.minuni) then
        k=nvar
      else
        do 120 k=minuni+1,iunit
  120     nlvar(k)=nlvar(k)+1
        do 130 k=nvar,nlvar(minuni+1),-1
          var(k)=var(k-1)
  130     vardef(k)=vardef(k-1)
      end if
      var(k)=v(1:j)
      if (iel.gt.0) vardef(k)=' '
c     ------------------------------------ set the value of the variable
  140 if (reonly(k)) then
        print '(''*** Error: "'',A,''" is a read-only variable.'')',
     *        v(1:j)
        haverr=.true.
        go to 990
      end if
      if (k.le.nsvar) varsav=vardef(k)
      if (iel.eq.0) then
        vardef(k)(i1:i2)=vd
      else
        i2=lenstr(vardef(k))
        if (vardef(k)(1:i2).eq.'NULL') then
          i2=0
        else
          str(1:i2)=vardef(k)(1:i2)
        end if
        nc=0
        nostr=.true.
        do 370 j=1,i2
          if (str(j:j).eq.quote) nostr=.not.nostr
          if (nostr .and. str(j:j).eq.',') then
            nc=nc+1
            ic(nc)=j
          end if
  370     continue
        if (vd.ne.' ') then
          l=lenstr(vd)
          if (iel.eq.1) then
            if (nc.eq.0) then
              vardef(k)=vd(1:l)
            else
              vardef(k)=vd(1:l)//str(ic(1):i2)
            end if
          else if (iel.le.nc) then
            vardef(k)=str(1:ic(iel-1))//vd(1:l)//str(ic(iel):i2)
          else if (iel.eq.nc+1) then
            vardef(k)=str(1:ic(nc))//vd(1:l)
          else
            do 380 j=nc+1,iel-1
              i2=i2+1
  380         str(i2:i2)=','
            vardef(k)=str(1:i2)//vd(1:l)
          end if
        else
          if (iel.eq.1) then
            if (nc.eq.0) then
              vardef(k)=' '
            else
              vardef(k)=str(ic(1):i2)
            end if
          else if (iel.le.nc) then
            vardef(k)=str(1:ic(iel-1))//str(ic(iel):i2)
          else if (iel.eq.nc+1) then
            vardef(k)(ic(nc):)=' '
          end if
          do 390 j=i2,1,-1
            if (vardef(k)(j:j).eq.',') then
              vardef(k)(j:j)=' '
            else if (vardef(k)(j:j).gt.' ') then 
              go to 400
            end if
  390       continue
  400     continue
        end if
      end if
c     ---------------------------------- export value of system variable
      if (k.le.nsvar) then
        call expvar (var(k),vardef(k),haverr)
        if (haverr) then
          print '(''*** Error: Illegal value "'',A,
     *          ''" for the system variable "'',A,''".'')',
     *          vardef(k)(1:lenstr(vardef(k))),var(k)(1:lenstr(var(k)))
          vardef(k)=varsav
        end if
c     ------------------------------------------------------ update echo
      else if (var(k).eq.'echo') then
        iecho=-1
      end if
  990 continue
c      timer(2)=timer(2)+timnow()-t0
      end
c     ==================================================================
      subroutine doecho (full,cmd,param,nparam,lnr,iunit,filnam)
c
      parameter (minuni=10,maxuni=20,maxlin=250)
      dimension lnr(minuni:maxuni)
      logical full
      character*(*) cmd,param(*),filnam(minuni:maxuni),
     *              dirend*2,str*(maxlin),str2*(maxlin)
      data dirend/'/]'/
c
      if (iunit.le.minuni) then
        str=cmd
      else
        str=filnam(iunit)
        l=lenstr(str)
        str(l+1:)=' '
        if (full) then
          call intstr (lnr(iunit),str2)
          write (str(l+1:),'(''('',A,'')'')') str2(1:lenstr(str2))
        else
          do 51 i=l,1,-1
   51       if (index(dirend,str(i:i)).gt.0) go to 52
   52     str(1:i)=' '
          call lefstr(str)
        end if
        str(lenstr(str)+1:)=': '//cmd
      end if
      do 53 k=1,nparam
        lpk=lenstr(param(k))
        if (index(param(k)(1:lpk),' ').eq.0) then
          str(lenstr(str)+2:)=param(k)
        else
          str(lenstr(str)+2:)='"'//param(k)(1:lpk)//'"'
        end if
   53   continue
        print '(79A1/(4X,75A1))',(str(l:l),l=1,lenstr(str))
      end
c     ==================================================================
      subroutine intstr (i,s)
c
      parameter (mini=-999,maxi=9999,n=maxi-mini+1)
      character*(*) s,istr(mini:maxi)*4
      logical init(mini:maxi)
      save init,istr
      data init/n*.true./
c
      if (i.ge.mini .and. i.le.maxi) then
        if (init(i)) then
          if (i.ge.1000 .or. i.le.-100) then
            write (istr(i),'(I4)') i
          else if (i.ge.100 .or. i.le.-10) then
            write (istr(i),'(I3)') i
          else if (i.ge.10 .or. i.le.-1) then
            write (istr(i),'(I2)') i
          else
            write (istr(i),'(I1)') i
          end if
          init(i)=.false.
        end if
        s=istr(i)
      else
        write (s,'(I10)') i
        call lefstr (s(1:10))
      end if
      end 
E 1
