h47520
s 00089/00000/00000
d D 1.1 95/03/03 14:10:30 cb 1 0
c date and time created 95/03/03 14:10:30 by cb
e
u
U
f e 0
t
T
I 1
/*
************************************************************************
*
*   %M% -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : %E%
*   Pathname of SCCS file     : %P%
*   SCCS identification       : %I%
*
************************************************************************
*/
/**************************************************************************/
/*                                                                        */
/**************************************************************************/

/* C libraries */

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>

/* Global variables and classes */

#include "global.h"

/* Classes used in this module */

#include "cmdline.h"			/* FORTRAN line interpreter       */
#include "log.h"			/* write log file                 */
#include "specTypes.h"			/* list of spectrum types         */
#include "bib.h"			/* lib. of atoms and fragments    */
#include "envir.h"			/* global environment             */
#include "interpreter.h"		/* call to functions,             */
					/* updates global variables       */
/**************************************************************************/
/* main routine                                                           */
/**************************************************************************/

main(int argc, char **argv)
{
   LiSpecType liSpecType;
   Log lo;
   UserVar userVar;
   Cmd command;
   Envir envir;
   Call interpreter(&envir);
   char line[MAXLINE * 2];
   int i;

   /* lo.init(); */
   liSpecType.init();

   line[0] = '\0';
   if(argc > 1) {
      for(i=1;i<argc;i++) {
         strcat(line,argv[i]);
         strcat(line," ");
      }
   }
   interpreter.callmacro(line);

   if(!interpreter.setVars(userVar)) {
      lo.w("Error: Command interpreter can not handle enough variables\n");
   } else {
      command.start();
      while(1) {
         /* Set global user vars                                         */
         interpreter.setValues(userVar,envir);
         /* set error */
         /* Get next command line & change global user vars              */
         command.next();		
         /* Get modified user vars                                       */
         if(!interpreter.getValues(userVar,envir))
            lo.w("... error in global variable definitions\n");
          /* Call appropriate routines                                   */
         userVar.error = interpreter.applyCmd(envir,command);
      }
   }
}
E 1
