h18802
s 00000/00000/00060
d D 1.2 95/09/15 13:38:55 cb 2 1
c program renamed into garant
e
s 00060/00000/00000
d D 1.1 95/03/03 14:09:38 cb 1 0
c date and time created 95/03/03 14:09:38 by cb
e
u
U
f e 0
t
T
I 1
/*
************************************************************************
*
*   %M% -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : %E%
*   Pathname of SCCS file     : %P%
*   SCCS identification       : %I%
*
************************************************************************
*/
/**************************************************************************/
/*                           frag.h                                       */
/*                                                                        */
/* Defines list of fragments                                              */
/**************************************************************************/

#ifndef _FRAG_H_
#define _FRAG_H_

#include "score.h"
#include "element.h"

class Frag : public Element {
public:
   int type;			/* detsination or subfragment             */
   int nrInt;			/* internal fragment number               */
   int nrExt;			/* external number                        */
   char *name;			/* name of the fragment                   */
   Frag(int,int,int,char *,int);/* initialize with type, nrInt, nrExt and */
				/* name and equivNr                       */
   Frag(int n) {nrInt=n;}	/* initialization for searching in list   */
   LiScore scores;		/* list of scores evaluating the ass. of  */
				/* the fragment                           */
   float penDegen;		/* used for scoring: penalty for multiple */
				/* assigned peaks                         */
   float penMiss;		/* used for scoring: penalty for          */
				/* unassigned peaks                       */
   int equivNr;			/* number identifying equivalent ss       */
   int equiv(Frag *);		/* are two fragments equivalent           */
};

class LiFrag : public Index {
public:
   int firstDest,lastDest;	/* first and last destination fragment    */
   LiFrag() : Index(4) {}
   virtual int compare(const Element *,const Element *);
				/* use internal number for comparison     */
};

#endif
E 1
