h13003
s 00000/00000/00256
d D 1.2 95/09/15 13:38:50 cb 2 1
c program renamed into garant
e
s 00256/00000/00000
d D 1.1 95/03/03 14:09:18 cb 1 0
c date and time created 95/03/03 14:09:18 by cb
e
u
U
f e 0
t
T
I 1
/*
************************************************************************
*
*   %M% -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : %E%
*   Pathname of SCCS file     : %P%
*   SCCS identification       : %I%
*
************************************************************************
*/
/**************************************************************************/
/*                             co.h                                       */
/*                                                                        */
/* coherences and list of coherences                                      */
/**************************************************************************/

#ifndef _CO_H_
#define _CO_H_

#include "element.h"
#include "wert.h"
#include "score.h"
#include "imp.h"

class Atom;
class ErPeak;
class LiErPeak;
class Spectrum;
class NMRdia;
class SQCoParser;
class LiPeakDegen;
class NMRTopol;

class Coherence;			/* general coherence                 */
class SQCo;				/* single quantum coherence          */
class LiCo;				/* list of arbitrary coherences      */
class ScoreLiCo;			/* list of co's sorted by score      */

#define UNASSIGNED 0
	/* no peaks have been assigne to the coherence */
#define ASSIGNED   1
	/* some peaks are assigned to the coherence    */

#define RESET      0
	/* reset all the old assignments               */
#define ADAPT      1
	/* adapt the frequency to match new assignment */

#define PSEUDON   0
	/* pseudo coherence active */
#define PSEUDOFF -1
	/* no pseudo coherence active */
#define PSEUDOCO -2
	/* coherence is pseudo coherence */

/* observealbe nuclei   */
#define NR_NUCLEI 4			/* number of different nuclei       */
#define PROTON   0
#define CARBON   1
#define NITROGEN 2
#define PHOSPHOR 3

extern char name_nuclei[NR_NUCLEI][10];

float expDistr(Wert,float);		/* calculates prob. that given shift */
					/* lies within given range           */

class CoAss {
public:
   CoAss();
   float *measF;
   float meanF;
   float mutInf;
};

class Coherence : public Element {	/* a coherence has a single define   */
					/* frequency. It involves a number of*/
					/* nuclei (1 for single quantum co.).*/
					/* It defines the frequency of an    */
					/* expected peak in one dimension    */
   Atom **nuclei;			/* nuclei involved in the coherence  */
   ErPeak **peaks;			/* peaks with frequencies defined by */
					/* the coherence                     */
   int nrErPeak;			/* number of peaks defined by the co */
   int maxErPeak;			/* size of peaks[] list              */
   float pUnass;			/* probability not to observe the co */
   float sumPeakP;   			/* sum of probabilities of the peaks */
					/* in peaks[]                        */
   Wert expF;				/* statisticaly expected frequency   */
   Wert assF;				/* assigned frquency                 */
public:
   friend SQCo;
   friend LiCo;
   friend OrdLiCo;
   friend ScoreLiCo;
   friend ErPeak;
   friend LiErPeak;
   friend LiPeakDegen;
   friend Atom;
   friend NMRdia;
   friend NMRTopol;
/* only read access allowed: */
   Mean meanF;				/* mean frequency of assigned peaks  */
   Mean *measF;				/* mean freq. for each spectrum      */
   CoAss *assPop;			/* populatioon of assigned freq.     */
   int typeNucleus;			/* proton, carbon, ...		     */
/* full access: */
   float bonusFreq;			/* log of probability by which ass.  */
					/* is more likely, if meas. freq.    */
					/* exactly matches expected freq     */
   float localScore;			/* score without global degeneracies */
   float maxScore;			/* best score                        */
   float meanDev;			/* average deviation from max        */
					/* pattern			     */
   float mutInf;			/* mutual information of freq.       */
   Imp imp;				/* statistics of made scorings       */
   LiCo *pseudo;			/* list of coherences grouped into   */
					/* a pseudo coherence                */
   int statPseudo;			/* pseudo co status		     */
					/* PSEUDOCO ... co is pseudo co      */
					/* PSEUDOFF ... no active pseudoco   */
					/* PSEUDON  ... pseudoco active      */
   Coherence *pseudCo;			/* active pseudoCohernece            */
   Coherence();				/* init peaks, nrErPeak, maxErPeak   */
   ~Coherence();
   float getMutInf(int nr)
      {return assPop[nr].mutInf;}
   Atom *firstAt() {return nuclei[0];}
   virtual Atom *start(Iterator &);	/* iterate over all involved atoms   */
   virtual Atom *next(Iterator &);
   ErPeak *startPeak(int &);		/* iterate over all peaks            */
   ErPeak *nextPeak(int &);
   void addPeak(ErPeak *);		/* add a peak to the peaks[] list    */
   int status;				/* UNASSIGNED ... no peaks assighned */
					/* ASSIGNED ..... peaks assigned to  */
   int fixed;				/* TRUE ......... do not change      */
					/* FALSE ........ include in opt.    */
   void setAss(int nr); 		/* set assPop                        */
   Wert expFreq();			/* get the expected or assigned freq.*/
   void calcMeanScore();		/* calculate average scoring         */
   inline float getScoreDev() {return meanDev; }
					/* get the mean deviation of the     */
					/* score                             */
   inline float getScoreMean() {return maxScore; }
					/* get the mean score                */
   float expProb(float);		/* return probability that the shift */
					/* corresponds to the expected resp. */
					/* assigned frequency                */
   Wert meanFreq(Spectrum *,int);	/* get the measured frequency        */
					/* with variance for given dim.      */
   LiScore scores;		        /* list of scores evaluating the ass.*/
   void expRange(float &,float &);	/* return expected or assigned range */
   void meanRange(Spectrum *,int, float &, float &);
					/* return measured range for given   */
					/* spectrum and dimension            */
   void notifyFreqReset(float,Spectrum *);
					/* an assignmnet has been reset      */
					/* update the frequency              */
   void notifyNewFreq(float,float,float *,Spectrum *,int);
					/* a peak has been assigned to the   */
					/* coherence                         */
					/* INPUT: mean & meas frequency,     */
					/*        spectrum and decision      */
					/*      RESET: old ass. invalid      */
					/*      ADAPT: old ass. still valid  */
   int updateFreq();			/* calculate meanF and measF using   */
					/* the current assignments           */
					/* set status                        */
   void updateScores();			/* calculate the local score of the  */
					/* coherences, returns score         */
   void setSumPeakP();			/* calculate sum of scores           */
   int cpMeanToAss();			/* copies valid meanF to assF        */
   void resetAssF();			/* set assF to BAD_PPM               */
   void addCoToPseudo(Coherence *);	/* add co to list		     */
   void turnOnPseud();			/* enable this pseudo coherence      */
   void turnOffPseud();			/* disable this pseudo coherence     */
   int pseudIdentical(Coherence *);	/* using activated pseudo coherences */
					/* are the co's then identical ?     */
   int floatIdentical(Coherence *);	/* using floating assignments for    */
					/* pseudo coherences */
					/* are the co's then identical ?     */
   int floatEquivalent(Coherence *);	/* using floating assignments for    */
					/* pseudo coherences and spin system */
					/* types for residues                */
					/* are the co's then identical ?     */
   int subEqual(Coherence *);		/* are two coherences from a sub and */
					/* a dest farg. equal                */
   int sortFloatAss(Coherence *, Coherence *);
				/* sort peaks of the two floating co's    */
				/* according to chem. shift               */
   virtual int equiv(Coherence *) {return 0;}
					/* are the two coherences equivalent */
   virtual void nameGet(char *,int &) {}
					/* get atom name and residue number  */
					/* as needed for EASY *.prot files   */
   virtual void nameSet(char *) {}      /* set the name of the coherence for */
					/* the EASY *.prot file              */
   virtual void fullNameGet(char *) {}  /* get full name of coherence        */
   virtual void print(int);		/* print info for coherence          */
};

class SQCo : public Coherence {
public:
   SQCo(Atom *,float,Wert);
   virtual Atom *start(Iterator &);	/* iterate over all involved atoms   */
   virtual Atom *next(Iterator &);
   virtual int equiv(Coherence *);      /* are the two coherences equivalent */
					/* calls Atom::equiv()               */
   friend SQCo *newR(LiCo &, Atom *, float);
					/* returns reference to sq. co. with */
					/* given atom and probability        */
					/* creates new co., if it is not     */
					/* present in the given list         */
   virtual void nameGet(char *,int &);
					/* get atom name and residue number  */
					/* as needed for EASY *.prot files   */
   virtual void nameSet(char *);        /* set the name of the coherence for */
					/* the EASY *.prot file              */
   virtual void fullNameGet(char *);    /* get full name of coherence        */
   virtual void print(int);		/* print info for coherence          */
   virtual int match(char *);		/* does co match template ?          */
};

class LiCo : public Index {
public:
   LiCo() : Index(MAXCOHERENCE) {}
   LiCo(int n) : Index(n) {}
   virtual int compare(const Element *,const Element *);
   int compare(int,char *,int,const Coherence *);
					/* compare using external number,    */
					/* name and fragment type            */
   Coherence *find(int,char *,int);	/* find coherence given external     */
					/* fragment number, name and type    */
   void listDif(char *,float);		/* list difference between expected  */
					/* and measured mean frequency       */
   void print(int);
};

class OrdLiCo : public Index {
public:
   OrdLiCo(LiCo &);
   virtual int compare(const Element *,const Element *);
};


#endif
E 1
