h46604
s 00000/00000/00052
d D 1.2 95/09/15 13:38:48 cb 2 1
c program renamed into garant
e
s 00052/00000/00000
d D 1.1 95/03/03 14:09:10 cb 1 0
c date and time created 95/03/03 14:09:10 by cb
e
u
U
f e 0
t
T
I 1
/*
************************************************************************
*
*   %M% -
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
*   Date of last modification : %E%
*   Pathname of SCCS file     : %P%
*   SCCS identification       : %I%
*
************************************************************************
*/
/**************************************************************************/
/*                              choice.h                                  */
/*                                                                        */
/* random choice of a peak                                                */
/**************************************************************************/

#ifndef _CHOICE_H_
#define _CHOICE_H_

#define MAXPEAKS 2000			/* Max number of peaks in a choice    */

class Peak;
class ErPeak;

/* Selection list of measured peaks  */
class ChoicePeak {
   float ptot;				/* sum of all scores             */
   float ploc[MAXPEAKS];		/* score of corresponding peak   */
   float psum[MAXPEAKS];		/* summed up scores              */
   Peak *peaks[MAXPEAKS];		/* peaks                         */
   ErPeak *erPeaks[MAXPEAKS];
   int parents[MAXPEAKS];
   int n;				/* number of peaks               */
public:
   ChoicePeak() {}
   int insert(Peak *, float, ErPeak *, int);
					/* add possible peak to list     */
   Peak *select(ErPeak *&, int &);	/* select from list              */
   void reset();			/* reset list of possibilities   */
};

#endif
E 1
