h49199
s 00004/00004/00293
d D 1.2 95/09/15 13:38:46 cb 2 1
c program renamed into garant
e
s 00297/00000/00000
d D 1.1 95/03/03 14:08:54 cb 1 0
c date and time created 95/03/03 14:08:54 by cb
e
u
U
f e 0
t
T
I 1
/*
************************************************************************
*
D 2
*   %M% -
E 2
I 2
*   atom.C -
E 2
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   All Rights Reserved
*
D 2
*   Date of last modification : %E%
*   Pathname of SCCS file     : %P%
*   SCCS identification       : %I%
E 2
I 2
*   Date of last modification : 95/03/03
*   Pathname of SCCS file     : /export/home3/cb/garant-1.0/src/SCCS/s.atom.C
*   SCCS identification       : 1.1
E 2
*
************************************************************************
*/
/**************************************************************************/
/*                             atom.cc                                    */
/*                                                                        */
/* class to define atoms and list of atoms                                */
/**************************************************************************/

#include <string.h>
#include <stdio.h>
#include "global.h"			/* global constants               */
#include "log.h"			/* general log file               */
#include "bib.h"			/* library with atoms and bonds   */
#include "str.h"
#include "parser.h"
#include "frag.h"
#include "atom.h"

Atom::Atom(): pseud(2)
{
   atype[0]='\0';
   name[0] ='\0';
   nr=0;
   t = ATOM;
   nrCos = 0;
   pseudoCorr = 0.0;
}

Atom::Atom(int n, char *na, char *tn, Wert shift, float prob, Frag *fr):
							pseud(2)
{
   strcpy(atype,tn);
   strcpy(name,na);
   nr = n;
   t = ATOM;
   nrCos = 0;
   w = shift;
   p = prob;
   frag = fr;
   pseudoCorr = 0.0;
}

Atom::Atom(int n, char *na,char *tn): pseud(2)
{
   strcpy(atype,tn);
   strcpy(name,na);
   nr = n;
   t = ATOM;
   nrCos = 0;
   p = 0.0;
   w = Wert(0,0);
   pseudoCorr = 0.0;
}

Atom::Atom(int n): pseud(2)
{
   nr = n;
   t = ATOM;
}

void Atom::print(int off)
{
   Log log;
   char str[MAXLINE];
   char fulln[MAXLINE];

   fullNameGet(fulln);
   if(frag->type == DESTFRAG) {
      sprintf(str,
         "%*sAtom of dest.: %5d %-15s %5s %8.4g\n",off,"",nr,fulln,atype,p);
      log.w(str);
   } else {
      sprintf(str,
         "%*sAtom of subs.: %5d %-15s %5s %8.4g\n",off,"",nr,fulln,atype,p);
      log.w(str);
   }
}

void Atom::fullname(char *na, char *aa, int &nr)
{
   shortname(na);
   strcpy(aa,frag->name);
   nr = frag->nrExt;
}

void Atom::fullNameGet(char *n)
{
   sprintf(n,"%s(%s %d)",name,frag->name,frag->nrExt);
}

void Atom::shortname(char *na)
{
   strcpy(na,name);
}

void Atom::nameSet(char *na)
{
   strcpy(name,na);
}

void Atom::resnumber(int &nr)
{
   nr = frag->nrExt;
}

int Atom::sameSsPos(Atom *) {return 0; }

void Atom::addCo(Coherence *c)
{
   int found = 0;
   int i = 0;
   Log log;
   char str[MAXLINE];

   while(!found && i<nrCos) {
      if (liCo[i] == c) found = 1;
      i++;
   }
   if(!found && nrCos<MAX_CO_PER_ATOM) {
      liCo[nrCos] = c;
      nrCos++;
      found = 1;
   }

   if(!found) {
      sprintf(str,"\n... ERROR: too many coherences for atom %s",name);
      log.w(str);
   }
}

int Atom::equiv(Atom *at)
{
   BibAccess bib;

   return bib.equivAt(nr,frag->nrInt,at->nr,at->frag->nrInt);
}

int Atom::match(char *t)
{
   int nrRes,tb,ib;
   Parser pars;
   char n[MAXLINE];

   fullNameGet(n);
   nrRes = UNDEFINED_RES_NR;
   return pars.atom(t,0,tb,n,0,ib,nrRes);
}

int Atom::proton()
{
   return (strcmp(atype,"PSEUD") == 0 ||
           strcmp(atype,"H_ALI") == 0 ||
           strcmp(atype,"H_AMI") == 0 ||
           strcmp(atype,"H_ARO") == 0 ||
           strcmp(atype,"H_SUL") == 0 ||
           strcmp(atype,"H_OXY") == 0
          );
}

void LiAtom::print(int off)
{
   char str[MAXLINE];
   Log log;

   sprintf(str,"%*sAtomlist:\n",off,"");
   log.w(str);
   Index::print(off+3);
}

int LiAtom::compare(const Element *a1,const Element *a2)
{
   return(((Atom *)a2)->nr - ((Atom *)a1)->nr);
}

void LiAtom::setScore(char *t, float prob)
{
   Atom *at;
   int nrSet;
   Log log;
   char str[MAXLINE];
   Iterator i;

   nrSet = 0;
   at = (Atom *)startPars(i,t);
   while(at != 0) {
      at->p = prob;
      nrSet++;
      at = (Atom *)nextPars(i,t);
   }
   sprintf(str,"\n... %d atom scores set",nrSet);
   log.w(str);
}

void LiAtom::setPseudCor(char *t, float dist)
{
   Atom *at;
   int nrSet;
   Log log;
   char str[MAXLINE];
   Iterator i;

   nrSet = 0;
   at = (Atom *)startPars(i,t);
   while(at != 0) {
      at->pseudoCorr = dist;
      nrSet++;
      at = (Atom *)nextPars(i,t);
   }
   sprintf(str,"\n... %d pseudo atom corrections set",nrSet);
   log.w(str);
}

OrdLiAtom::OrdLiAtom(LiAtom &list) : Index(list.getn())
{
   Atom *co;

   remove();
   co = (Atom *)list.start();
   while(co != 0) {
      add(co);
      co = (Atom *)list.next();
   }
   sort(-1);
}

int OrdLiAtom::compare(const Element *a1,const Element *a2)
{
   int res;
   res = a2->t - a1->t;
   if(!res) res = ((Atom *)a2)->frag->nrExt - ((Atom *)a1)->frag->nrExt;
   if(!res) res = strcmp(((Atom *)a2)->name, ((Atom *)a1)->name);
   if(!res) res = ((Atom *)a2)->frag->type - ((Atom *)a1)->frag->type;
   if(!res) res = ((Atom *)a2)->nr - ((Atom *)a1)->nr;
   return(res);
}

int OrdLiAtom::compare(int nrExt, char *name, int type, const Atom *a2)
{
   int res;
   res = ((Atom *)a2)->frag->nrExt - nrExt;
   if(!res) res = strcmp(((Atom *)a2)->name, name);
   if(!res) res = ((Atom *)a2)->frag->type - type;
   return(res);
}

Atom *OrdLiAtom::find(int nrExt,char *name,int type)
{
  int i,j,res;				// element

   if(n==0) return(0);

   i=0;
   j=n-1;
   cur=0;
   res=1;
   while(i<=j && res !=0) {
      cur = (i+j)/2;
      res=compare(nrExt,name,type,(Atom *)l[cur]);
      if(res < 0) i=cur+1;
      else j=cur-1;
   }
   if(res==0) return((Atom *)l[cur]);
   else if(res<0) {cur++; return(0); }
   else return(0);
}

Coord::Coord(float *c,int id)
{
   int i;

   for(i=0;i<3;i++) coord[i]=c[i];
   idStructure=id;
}


int LiCoord::compare(const Element *c1,const Element *c2)
{
   return ((Coord *)c2)->idStructure - ((Coord *)c1)->idStructure;
}
E 1
