/*
 * Decompiled with CFR 0.152.
 */
package visualization.snapshots;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import model.components.Recorder;
import model.experiment.ExperimentSimplePiston;

public class ExperimentSnapshot {
    private final HashMap<String, Double> experimentState;
    private final HashMap<String, double[]> experimentDistributions;
    private final String experimentStage;
    public static final String EXPERIMENTAL_MB_DISTR = "Experimental Maxwell Boltzmann Distribution";
    public static final String IDEAL_MB_DISTR = "Ideal Maxwell Boltzmann Distribution";

    public ExperimentSnapshot(ExperimentSimplePiston e) {
        Recorder reader = e.getRecorder();
        this.experimentStage = reader.getCurrentStage();
        this.experimentState = reader.getState();
        this.experimentDistributions = e.getDistributions();
    }

    public ExperimentSnapshot(ArrayList<ExperimentSnapshot> snapshotListTemporaryIn) {
        this.experimentStage = snapshotListTemporaryIn.get((int)0).experimentStage;
        this.experimentState = snapshotListTemporaryIn.get(0).getState();
        for (String key : this.experimentState.keySet()) {
            double averageState = 0.0;
            for (ExperimentSnapshot snapshotTemporary : snapshotListTemporaryIn) {
                averageState += snapshotTemporary.getState().get(key).doubleValue();
            }
            this.experimentState.replace(key, averageState /= (double)snapshotListTemporaryIn.size());
        }
        String key = EXPERIMENTAL_MB_DISTR;
        int maxNumberOfBins = 0;
        for (int n = 0; n < snapshotListTemporaryIn.size(); ++n) {
            double[] distr = snapshotListTemporaryIn.get(n).getDistributions().get(key);
            if (distr.length <= maxNumberOfBins) continue;
            maxNumberOfBins = distr.length;
        }
        double[] averageDistribution = new double[maxNumberOfBins];
        for (int n = 0; n < maxNumberOfBins; ++n) {
            double averageDistributionEntry = 0.0;
            for (ExperimentSnapshot snapshotTemporary : snapshotListTemporaryIn) {
                if (n >= snapshotTemporary.getDistributions().get(key).length) continue;
                averageDistributionEntry += snapshotTemporary.getDistributions().get(key)[n];
            }
            averageDistribution[n] = averageDistributionEntry / (double)snapshotListTemporaryIn.size();
        }
        this.experimentDistributions = snapshotListTemporaryIn.get(0).getDistributions();
        this.experimentDistributions.replace(key, averageDistribution);
    }

    public String getCurrentStage() {
        return this.experimentStage;
    }

    public HashMap<String, Double> getState() {
        return this.experimentState;
    }

    public HashMap<String, double[]> getDistributions() {
        return this.experimentDistributions;
    }

    public Set<String> getParameterNames() {
        TreeSet<String> tmp = new TreeSet<String>(this.getState().keySet());
        tmp.remove("Simulation time [s]");
        return tmp;
    }
}

