/*
 * Decompiled with CFR 0.152.
 */
package multimedia.aviwriter;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;

abstract class AVIstruct {
    private long m_lngPlaceholder;

    AVIstruct() {
    }

    public static void write32LE(RandomAccessFile raf, int i) throws IOException {
        raf.write(i & 0xFF);
        raf.write(i >>> 8 & 0xFF);
        raf.write(i >>> 16 & 0xFF);
        raf.write(i >>> 24 & 0xFF);
    }

    public static void write16LE(RandomAccessFile raf, short i) throws IOException {
        raf.write(i & 0xFF);
        raf.write(i >>> 8 & 0xFF);
    }

    public static int string2int(String s) {
        if (s.length() != 4) {
            throw new IllegalArgumentException();
        }
        try {
            return AVIstruct.bytes2int(s.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public static int bytes2int(byte[] ab) {
        if (ab.length != 4) {
            throw new IllegalArgumentException();
        }
        return ab[0] | ab[1] << 8 | ab[2] << 16 | ab[3] << 24;
    }

    public abstract void write(RandomAccessFile var1) throws IOException;

    public abstract int sizeof();

    public void makePlaceholder(RandomAccessFile raf) throws IOException {
        this.m_lngPlaceholder = raf.getFilePointer();
        raf.write(new byte[this.sizeof()]);
    }

    public void goBackAndWrite(RandomAccessFile raf) throws IOException {
        long lngCurPos = raf.getFilePointer();
        raf.seek(this.m_lngPlaceholder);
        this.write(raf);
        raf.seek(lngCurPos);
    }
}

