/*
 * Decompiled with CFR 0.152.
 */
package multimedia;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javafx.beans.Observable;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Line;
import javax.imageio.ImageIO;
import multimedia.VTLPlotUtils;
import settings.Settings;
import visualization.snapshots.ExperimentSnapshotCollector;

public class PDFReport {
    private LinkedHashMap<String, String> properties;
    private ExperimentSnapshotCollector snapshotCollector;

    public PDFReport(LinkedHashMap<String, String> propertiesToPlot, ExperimentSnapshotCollector snapshotCollector) {
        this.snapshotCollector = snapshotCollector;
        this.properties = propertiesToPlot;
    }

    public void generateReport(File outputFile) throws FileNotFoundException, DocumentException {
        Document report = new Document();
        PdfWriter writer = PdfWriter.getInstance(report, new FileOutputStream(outputFile));
        report.open();
        report.addTitle("Experiment Report");
        ArrayList<String> propertiesToPlot = new ArrayList<String>();
        ArrayList<String> propertiesToPlotKeys = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            propertiesToPlotKeys.add(entry.getKey());
            propertiesToPlot.add(entry.getValue());
        }
        for (int n = 0; n < propertiesToPlot.size(); ++n) {
            NumberAxis xAxis = new NumberAxis(0.0, (double)this.snapshotCollector.lenRecording() / (double)Settings.recordingsPerSecond, Math.pow(10.0, Math.round(Math.log10((double)this.snapshotCollector.lenRecording() / (double)Settings.recordingsPerSecond / 10.0))));
            NumberAxis yAxis = new NumberAxis();
            this.formatOneAxis(xAxis, yAxis, propertiesToPlot, n, propertiesToPlotKeys);
            LineChartWithMarkers<Number, Number> lineChart = new LineChartWithMarkers<Number, Number>((Axis<Number>)xAxis, (Axis<Number>)yAxis);
            Pane chartHolder = new Pane();
            chartHolder.getChildren().add(lineChart);
            lineChart.setAxisSortingPolicy(LineChart.SortingPolicy.NONE);
            lineChart.setTitle(propertiesToPlot.get(n) + " over time");
            XYChart.Series series = new XYChart.Series();
            series.setName(propertiesToPlot.get(n));
            for (int k = 0; k < this.snapshotCollector.lenRecording(); ++k) {
                series.getData().add((Object)new XYChart.Data((Object)(((double)k + 1.0) / (double)Settings.recordingsPerSecond), (Object)this.snapshotCollector.getSnapshot(k).getState().get(propertiesToPlotKeys.get(n))));
            }
            lineChart.getData().add((Object)series);
            VTLPlotUtils.formatLineChart(lineChart, false, true);
            lineChart.setLegendVisible(false);
            Scene scene = new Scene((Parent)chartHolder);
            for (int k = 0; k < this.snapshotCollector.lenRecording() - 1; ++k) {
                if (this.snapshotCollector.getSnapshot(k).getCurrentStage().equals(this.snapshotCollector.getSnapshot(k + 1).getCurrentStage())) continue;
                lineChart.addVerticalValueMarker((XYChart.Data<Number, Number>)new XYChart.Data((Object)(((double)k + 1.0) / (double)Settings.recordingsPerSecond), (Object)(((double)k + 1.0) / (double)Settings.recordingsPerSecond)));
            }
            this.addGraph(lineChart, report, 0);
        }
        report.newPage();
        int[][] indices = new int[][]{{0, 1}, {0, 2}, {1, 2}};
        ArrayList<String> plotNames = new ArrayList<String>();
        plotNames.add("V-T Diagram");
        plotNames.add("p-T Diagram");
        plotNames.add("p-V Diagram");
        for (int n = 0; n < indices.length; ++n) {
            NumberAxis xAxis = new NumberAxis();
            NumberAxis yAxis = new NumberAxis();
            this.formatTwoAxis(xAxis, yAxis, propertiesToPlot, indices[n]);
            LineChart lineChart = new LineChart((Axis)xAxis, (Axis)yAxis);
            Pane chartHolder = new Pane();
            chartHolder.getChildren().add((Object)lineChart);
            lineChart.setAxisSortingPolicy(LineChart.SortingPolicy.NONE);
            lineChart.setTitle((String)plotNames.get(n));
            XYChart.Series series = new XYChart.Series();
            for (int k = 0; k < this.snapshotCollector.lenRecording(); ++k) {
                series.getData().add((Object)new XYChart.Data((Object)this.snapshotCollector.getSnapshot(k).getState().get(propertiesToPlotKeys.get(indices[n][0])), (Object)this.snapshotCollector.getSnapshot(k).getState().get(propertiesToPlotKeys.get(indices[n][1]))));
            }
            lineChart.getData().add((Object)series);
            VTLPlotUtils.formatLineChart((LineChart<Number, Number>)lineChart, true, true);
            lineChart.setLegendVisible(false);
            Scene scene = new Scene((Parent)chartHolder);
            this.addGraph((LineChart<Number, Number>)lineChart, report, 1);
        }
        int lastSnapShot = this.snapshotCollector.lenRecording() - 1;
        Paragraph totalWork = new Paragraph(String.format("Total work considered for efficiency: %.3f J", this.snapshotCollector.getSnapshot(lastSnapShot).getState().get("Work for Efficiency [J]")));
        Paragraph totalHeat = new Paragraph(String.format("Total heat considered for efficiency: %.3f J", this.snapshotCollector.getSnapshot(lastSnapShot).getState().get("Heat for Efficiency [J]")));
        Paragraph Efficiency = new Paragraph(String.format("Efficiency (Work/Heat): %.3f", Math.abs(this.snapshotCollector.getSnapshot(lastSnapShot).getState().get("Work for Efficiency [J]") / this.snapshotCollector.getSnapshot(lastSnapShot).getState().get("Heat for Efficiency [J]"))));
        report.add(totalWork);
        report.add(totalHeat);
        report.add(Efficiency);
        report.newPage();
        for (int k = 0; k <= this.snapshotCollector.lenEndOfStageRecording() - 1; ++k) {
            HashMap<String, Double> state = this.snapshotCollector.getSnapshotEndOfStage(k).getState();
            HashMap<String, Double> stateAveraged = this.snapshotCollector.getSnapshotEndOfStage(k).getState();
            String stage = this.snapshotCollector.getStageName(k);
            try {
                if (k == this.snapshotCollector.lenEndOfStageRecording() - 1) {
                    report.add(new Paragraph("End of stage " + (k + 1) + ": " + stage + " (end of experiment)", new Font(BaseFont.createFont("Times-Bold", "Cp1252", true))));
                } else {
                    report.add(new Paragraph("End of stage " + (k + 1) + ": " + stage, new Font(BaseFont.createFont("Times-Bold", "Cp1252", true))));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            report.add(new Paragraph(String.format("Current Time [s]: %.3f", state.get("Simulation time [s]"))));
            report.add(new Paragraph(String.format("Avg Temperature Particles [K]: %.3f", stateAveraged.get("Average Temperature Particles [K]"))));
            report.add(new Paragraph(String.format("Volume [m^3]: %.3f", stateAveraged.get("Volume [m^3]"))));
            report.add(new Paragraph(String.format("Internal pressure [Pa]: %.3f", stateAveraged.get("Internal Pressure (total) [Pa]"))));
            report.add(new Paragraph(String.format("External pressure [Pa]: %.3f", state.get("External Pressure [Pa]"))));
            report.add(new Paragraph(String.format("Total Energy [J]: %.3f", state.get("Total Energy [J]"))));
            report.add(new Paragraph(String.format("Total Work (by System) [J]: %.3f", state.get("Total Work by System [J]"))));
            report.add(new Paragraph(String.format("Total recorded work [J]: %.3f", state.get("Work for Efficiency [J]"))));
            report.add(new Paragraph(String.format("Work during current stage [J]: %.3f", state.get("Work during Current Stage [J]"))));
            report.add(new Paragraph(String.format("Total Heat (into System) [J]: %.3f", state.get("Total Heat into System [J]"))));
            report.add(new Paragraph(String.format("Total recorded heat [J]: %.3f", state.get("Heat for Efficiency [J]"))));
            report.add(new Paragraph(String.format("Heat during current stage [J]: %.3f", state.get("Heat during Current Stage [J]"))));
            report.add(new Paragraph(String.format("pV/nRT: %.3f", stateAveraged.get("pV/nRT"))));
            report.add(new Paragraph(" "));
        }
        report.newPage();
        File txtFile = Settings.hiddenTemporaryExperimentFile;
        if (txtFile.exists()) {
            try {
                String lineString;
                BufferedReader reader = new BufferedReader(new FileReader(txtFile));
                BaseFont courier = BaseFont.createFont("Courier", "Cp1252", true);
                Font monospacedFont = new Font(courier, 9.0f);
                while ((lineString = reader.readLine()) != null) {
                    Paragraph line = new Paragraph(lineString, monospacedFont);
                    report.add(line);
                }
            }
            catch (IOException e) {
                System.out.println("Error writing pdf");
                e.printStackTrace();
            }
        }
        report.close();
        writer.close();
    }

    private void formatOneAxis(NumberAxis xAxisIn, NumberAxis yAxisIn, ArrayList<String> propertiesToPlotIn, int indexIn, ArrayList<String> keysIn) {
        xAxisIn.setLabel("Time [s]");
        xAxisIn.setTickLabelFont(new javafx.scene.text.Font(20.0));
        yAxisIn.setLabel(propertiesToPlotIn.get(indexIn));
        yAxisIn.setTickLabelRotation(270.0);
        yAxisIn.setTickLabelFont(new javafx.scene.text.Font(20.0));
    }

    private void formatTwoAxis(NumberAxis xAxisIn, NumberAxis yAxisIn, ArrayList<String> propertiesToPlotIn, int[] indexIn) {
        xAxisIn.setLabel(propertiesToPlotIn.get(indexIn[0]));
        xAxisIn.setTickLabelFont(new javafx.scene.text.Font(20.0));
        yAxisIn.setLabel(propertiesToPlotIn.get(indexIn[1]));
        yAxisIn.setTickLabelRotation(270.0);
        yAxisIn.setTickLabelFont(new javafx.scene.text.Font(20.0));
    }

    private void addGraph(LineChart<Number, Number> lineChartIn, Document reportIn, int sizeIndicator) {
        float documentWidth = reportIn.getPageSize().getWidth() - reportIn.leftMargin() - reportIn.rightMargin();
        float documentHeight = reportIn.getPageSize().getHeight() - reportIn.topMargin() - reportIn.bottomMargin();
        try {
            if (sizeIndicator == 0) {
                lineChartIn.getStylesheets().add((Object)this.getClass().getResource("/visualization/resources/css/graph_1D_report.css").toURI().toURL().toExternalForm());
            }
            if (sizeIndicator == 1) {
                lineChartIn.getStylesheets().add((Object)this.getClass().getResource("/visualization/resources/css/graph_2D_report.css").toURI().toURL().toExternalForm());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (sizeIndicator == 0) {
            lineChartIn.setMinSize((double)(5.0f * documentWidth), (double)(5.0f * documentHeight / 6.0f));
            lineChartIn.setMaxSize((double)(5.0f * documentWidth), (double)(5.0f * documentHeight / 6.0f));
        }
        if (sizeIndicator == 1) {
            lineChartIn.setMinSize((double)(5.0f * documentWidth), (double)(5.0f * documentHeight / 4.0f));
            lineChartIn.setMaxSize((double)(5.0f * documentWidth), (double)(5.0f * documentHeight / 4.0f));
        }
        WritableImage imageInput = lineChartIn.getParent().snapshot(new SnapshotParameters(), null);
        BufferedImage bufferedImage = SwingFXUtils.fromFXImage((Image)imageInput, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", baos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        com.itextpdf.text.Image iTextImage = null;
        try {
            iTextImage = com.itextpdf.text.Image.getInstance(baos.toByteArray());
            if (sizeIndicator == 0) {
                iTextImage.scaleToFit(documentWidth, documentHeight / 6.0f);
            } else {
                iTextImage.scaleToFit(documentWidth, documentHeight / 4.0f);
                iTextImage.setAlignment(1);
            }
        }
        catch (BadElementException | IOException e) {
            e.printStackTrace();
        }
        try {
            reportIn.add(iTextImage);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    private static class LineChartWithMarkers<X, Y>
    extends LineChart<X, Y> {
        private final ObservableList<XYChart.Data<X, Y>> verticalMarkers;

        /*
         * Exception decompiling
         */
        public LineChartWithMarkers(Axis<X> xAxis, Axis<Y> yAxis) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void addVerticalValueMarker(XYChart.Data<X, Y> marker) {
            Line line = new Line();
            marker.setNode((Node)line);
            this.getPlotChildren().add((Object)line);
            this.verticalMarkers.add(marker);
        }

        protected void layoutPlotChildren() {
            super.layoutPlotChildren();
            for (XYChart.Data verticalMarker : this.verticalMarkers) {
                Line line = (Line)verticalMarker.getNode();
                line.setStartX(this.getXAxis().getDisplayPosition(verticalMarker.getXValue()) + 0.5);
                line.setEndX(line.getStartX());
                line.setStartY(0.0);
                line.setEndY(this.getBoundsInLocal().getHeight());
                line.toFront();
                line.setStrokeWidth(2.0);
            }
        }

        private /* synthetic */ void lambda$new$1(Observable observable) {
            this.layoutPlotChildren();
        }
    }
}

