/*
 * Decompiled with CFR 0.152.
 */
package model.experiment;

import java.util.ArrayList;
import model.components.basic.Particle;
import model.components.core.VTLComponent;
import model.components.particleEmitters.ParticleEmitter;
import model.components.schedulers.Scheduler;

public abstract class Experiment {
    private ArrayList<VTLComponent> sceneComponents = new ArrayList();
    private ArrayList<Particle> sceneParticles = new ArrayList();
    private final ArrayList<Scheduler> schedulers = new ArrayList();

    public void addComponent(VTLComponent component) {
        this.sceneComponents.add(component);
        if (component instanceof ParticleEmitter) {
            this.sceneParticles.addAll(((ParticleEmitter)component).getParticleList());
            ((ParticleEmitter)component).getParticleList().clear();
        }
    }

    public VTLComponent getComponentById(int i) {
        return this.sceneComponents.get(i);
    }

    public int getNumComponents() {
        return this.sceneComponents.size();
    }

    public ArrayList<VTLComponent> getComponents() {
        return this.sceneComponents;
    }

    public ArrayList<Particle> getParticles() {
        return this.sceneParticles;
    }

    public void setParticles(ArrayList<Particle> particles) {
        this.sceneParticles = particles;
    }

    public Particle getParticleById(int i) {
        return this.sceneParticles.get(i);
    }

    public int getNumOfParticles() {
        return this.sceneParticles.size();
    }

    public Scheduler getSchedulerById(int i) {
        return this.schedulers.get(i);
    }

    public int getNumOfSchedulers() {
        return this.schedulers.size();
    }

    public void addScheduler(Scheduler o) {
        this.schedulers.add(o);
    }

    public void clearSchedulers() {
        this.schedulers.clear();
    }

    public abstract void setup();

    public void clear() {
        if (this.sceneComponents != null) {
            this.sceneComponents.clear();
        } else {
            this.sceneComponents = new ArrayList();
        }
        if (this.sceneParticles != null) {
            this.sceneParticles.clear();
        } else {
            this.sceneParticles = new ArrayList();
        }
    }

    public void reset() {
        this.clear();
        this.setup();
    }

    public double[] getParticleStatistics(ArrayList<Particle> particles) {
        double[] output = new double[6];
        int n_particles = particles.size();
        double[] speed = new double[n_particles];
        double sumSpeed = 0.0;
        double sumEnergy = 0.0;
        double sumEnergyAtomic = 0.0;
        for (int n = 0; n < n_particles; ++n) {
            double s;
            Particle p = particles.get(n);
            speed[n] = s = p.getSpeed();
            sumSpeed += s;
            output[1] = Math.max(output[1], s);
            s *= s;
            sumEnergy += 0.5 * p.getM() * s;
            sumEnergyAtomic += 0.5 * p.getMAtomic() * s;
        }
        output[0] = sumSpeed / (double)n_particles;
        double sum = 0.0;
        for (int n = 0; n < n_particles; ++n) {
            sum += (output[0] - speed[n]) * (output[0] - speed[n]);
        }
        output[2] = Math.sqrt(sum / (double)(n_particles - 1));
        output[3] = sumEnergy / (double)n_particles;
        output[4] = sumEnergy;
        output[5] = sumEnergyAtomic / (double)n_particles;
        return output;
    }
}

