/*
 * Decompiled with CFR 0.152.
 */
package model.components.advanced;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import model.components.containers.BoxDynamic;
import model.physics.properties.TemperatureObject;
import settings.Settings;
import visualization.gui.UtilsUI;

public class PistonVertical
extends BoxDynamic
implements TemperatureObject {
    public double temperature;
    protected boolean isStuck = false;
    protected double[] pos_init = new double[6];
    protected double max_displacementTop;
    protected double max_displacementBottom;
    protected BufferedImage image;
    protected double areaSI;
    public static final int MODE_FREE_MOVEMENT = 0;
    public static final int MODE_FIXED_VOLUME = 1;
    public static final int MODE_FIXED_POSITION = 2;

    public PistonVertical(double x1In, double y1In, double x2In, double y2In, double massIn, double maxDisplacementTopIn, double maxDisplacementBottomIn, double temperatureIn) {
        super(x1In, y1In, x2In, y2In, massIn);
        this.pos_init[0] = x1In;
        this.pos_init[1] = y1In;
        this.pos_init[2] = Settings.zFront;
        this.pos_init[3] = x2In;
        this.pos_init[4] = y2In;
        this.pos_init[5] = Settings.zBack;
        this.temperature = temperatureIn;
        this.max_displacementTop = maxDisplacementTopIn;
        this.max_displacementBottom = maxDisplacementBottomIn;
        this.image = UtilsUI.getInstance().prepareImage("/visualization/resources/images/piston.png", (int)(Math.abs(x2In - x1In) + 4.0), (int)Math.abs(y2In - y1In));
        this.areaSI = Math.abs((this.pos[3] - this.pos[0]) * (this.pos[5] - this.pos[2]) / (Settings.pixelsInAMeter * Settings.pixelsInAMeter));
    }

    @Override
    public void draw(Graphics2D context) {
        double[] pos = this.getPosition();
        context.setColor(new Color(51, 51, 51));
        int thickness = (int)(this.pos[4] - this.pos[1]);
        context.fillRoundRect((int)Math.min(pos[0], pos[3]), (int)pos[1], (int)Math.abs(pos[0] - pos[3]), thickness, 10, 10);
        if (Settings.allowHeating) {
            context.setColor(UtilsUI.getTemperatureColor(this.temperature));
            context.fillRoundRect((int)Math.min(pos[0], pos[3]), (int)pos[4] - thickness / 3, (int)Math.abs(pos[0] - pos[3]), thickness / 3, thickness / 6, thickness / 6);
        }
    }

    @Override
    public void update(double dt) {
    }

    public void update(double dt, double accelerationIn, boolean pistonFixedIn, boolean volumeFixedIn, double fixedVelocityIn) {
        double s;
        if (pistonFixedIn && volumeFixedIn) {
            s = fixedVelocityIn * dt;
            this.setV(fixedVelocityIn);
        } else if (pistonFixedIn) {
            s = 0.0;
            this.setV(0.0);
        } else {
            this.setV(this.v[1] + 0.5 * accelerationIn * dt);
            s = this.v[1] * dt;
            s = this.v[1] * dt;
            s *= Settings.pixelsInAMeter;
        }
        if (this.pos[1] + s <= this.pos_init[1] - this.max_displacementTop) {
            this.setV(new double[]{0.0, 0.0, 0.0});
            this.pos[1] = this.pos_init[1] - this.max_displacementTop;
            this.pos[4] = this.pos_init[4] - this.max_displacementTop;
            this.setPosY(this.pos[1], this.pos[4]);
            this.isStuck = true;
        } else if (this.pos[4] + s >= this.pos_init[4] + this.max_displacementBottom) {
            this.setV(new double[]{0.0, 0.0, 0.0});
            this.pos[1] = this.pos_init[1] + this.max_displacementBottom;
            this.pos[4] = this.pos_init[4] + this.max_displacementBottom;
            this.setPosY(this.pos[1], this.pos[4]);
            this.isStuck = true;
        } else {
            this.pos[1] = this.pos[1] + s;
            this.pos[4] = this.pos[4] + s;
            this.setPosY(this.pos[1], this.pos[4]);
            for (int i = 0; i < 6; ++i) {
                this.walls[i].update(dt);
            }
            this.isStuck = false;
        }
        if (!pistonFixedIn && !this.isStuck) {
            this.setV(this.v[1] + 0.5 * accelerationIn * dt);
        }
    }

    @Override
    public void setV(double[] v) {
        this.v = new double[]{0.0, v[1], 0.0};
        for (int i = 0; i < 6; ++i) {
            this.walls[i].setV(new double[]{0.0, v[1], 0.0});
        }
    }

    public void setV(double speedYIn) {
        double[] vNew = this.getV();
        vNew[1] = speedYIn;
        this.setV(vNew);
    }

    public boolean getIsStuck() {
        return this.isStuck;
    }

    @Override
    public HashMap<String, Double> getState() {
        HashMap<String, Double> state = super.getState();
        state.put("Speed", this.v[1]);
        return state;
    }

    public double getAreaSI() {
        return this.areaSI;
    }

    @Override
    public double getT() {
        return this.temperature;
    }

    @Override
    public void setT(double t) {
        this.temperature = t;
    }
}

