/*
 * Decompiled with CFR 0.152.
 */
package visualization.gui.popup;

import java.net.URISyntaxException;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import settings.Settings;
import settings.VTLLabels;

public class DefaultPopups {
    public static Stage waitingPopup = null;

    public static void showInfoPopup(String message) {
        final Stage dialogStage = new Stage();
        dialogStage.initModality(Modality.WINDOW_MODAL);
        Button button = new Button("OK");
        button.setPrefWidth(120.0);
        button.setPrefHeight(25.0);
        Label label = new Label(message);
        label.maxWidth(400.0);
        label.setWrapText(true);
        label.setPadding(new Insets(20.0, 10.0, 30.0, 10.0));
        VBox vbox = new VBox(new Node[]{label, button});
        vbox.setAlignment(Pos.CENTER);
        vbox.setPadding(new Insets(30.0));
        vbox.setSpacing(10.0);
        button.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                dialogStage.close();
            }
        });
        Scene s = new Scene((Parent)vbox);
        dialogStage.setScene(s);
        try {
            dialogStage.getIcons().add((Object)new Image(DefaultPopups.class.getResource("/visualization/resources/buttons/information.png").toURI().toString()));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        dialogStage.show();
    }

    public static void showApplicationCrashPopup(StackTraceElement[] stackTrace) {
        StackTraceElement s2;
        final Stage dialogStage = new Stage();
        dialogStage.initModality(Modality.WINDOW_MODAL);
        Button button = new Button("OK");
        button.setPrefWidth(100.0);
        button.setPrefHeight(25.0);
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement s2 : stackTrace) {
            sb.append(s2.toString() + "\n");
        }
        Label label1 = new Label(VTLLabels.CRITICAL_ERROR);
        label1.setPadding(new Insets(20.0, 10.0, 30.0, 10.0));
        label1.setAlignment(Pos.TOP_LEFT);
        TextArea label = new TextArea(sb.toString());
        label.setWrapText(true);
        label.setPadding(new Insets(20.0, 10.0, 30.0, 10.0));
        label.setEditable(false);
        VBox vbox = new VBox(new Node[]{label1, label, button});
        vbox.setAlignment(Pos.CENTER);
        vbox.setPadding(new Insets(30.0));
        vbox.setSpacing(10.0);
        button.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                dialogStage.close();
                if (Settings.stopProgramExecutionOnException) {
                    System.exit(10);
                }
            }
        });
        s2 = new Scene((Parent)vbox);
        dialogStage.setScene((Scene)s2);
        s2.getWindow().setWidth(800.0);
        try {
            dialogStage.getIcons().add((Object)new Image(DefaultPopups.class.getResource("/visualization/resources/buttons/information.png").toURI().toString()));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        dialogStage.show();
    }
}

