/*
 * Decompiled with CFR 0.152.
 */
package visualization.gui.components;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.VBox;
import visualization.gui.UtilsUI;

public class NewExperimentSchedulerBoxController
implements Initializable {
    public VBox root = new VBox();
    public VBox volumeBox = new VBox();
    public VBox volumeTimeBox = new VBox();
    public VBox heatersTemperatureBox = new VBox();
    public VBox heatersRateBox = new VBox();
    public VBox pressureBox = new VBox();
    public VBox schedulerTimeBox = new VBox();
    @FXML
    public TextField schedulerNameField = new TextField();
    public TextField schedulerTimeField = new TextField();
    public CheckBox addPistonSchedulerTickBox = new CheckBox();
    public CheckBox addTemperatureSchedulerTickBox = new CheckBox();
    public CheckBox addPressureSchedulerTickBox = new CheckBox();
    public CheckBox reportHeatTickBox = new CheckBox();
    public CheckBox reportWorkTickBox = new CheckBox();
    @FXML
    public TitledPane pistonPane = new TitledPane();
    public CheckBox fixPistonCheckBox = new CheckBox();
    public CheckBox fixVolumeCheckBox = new CheckBox();
    public Label volumeLabel = new Label();
    public TextField volumeField = new TextField();
    public TextField volumeTimeField = new TextField();
    @FXML
    public TitledPane heatersPane = new TitledPane();
    public CheckBox heatersCheckBoxSchedule = new CheckBox();
    public TextField heatersTemperatureField = new TextField();
    public TextField heatersRateField = new TextField();
    @FXML
    public TitledPane pressurePane = new TitledPane();
    public CheckBox smoothPressureTickBox = new CheckBox();
    public TextField pressureField = new TextField();
    @FXML
    public Button deleteButton = new Button();
    public ComboBox pistonModeCombo;
    public Label pistonModeLabel;
    public VBox pistonMode;
    public ComboBox heatersModeCombo;
    public ComboBox pressureModeCombo;
    String separator = ": ";

    public void writeScheduler(PrintWriter printWriterIn) {
        printWriterIn.println("  scheduler name     " + this.separator + this.schedulerNameField.getText());
        printWriterIn.println("  scheduler duration " + this.separator + NewExperimentSchedulerBoxController.readValue(this.schedulerTimeField));
        printWriterIn.println("  schedule piston?   " + this.separator + this.addPistonSchedulerTickBox.isSelected());
        printWriterIn.println("  schedule heaters?  " + this.separator + this.addTemperatureSchedulerTickBox.isSelected());
        printWriterIn.println("  schedule pressure? " + this.separator + this.addPressureSchedulerTickBox.isSelected());
        printWriterIn.println("  report heat?       " + this.separator + this.reportHeatTickBox.isSelected());
        printWriterIn.println("  report work?       " + this.separator + this.reportWorkTickBox.isSelected());
        printWriterIn.println("  piston mode        " + this.separator + this.pistonModeCombo.getSelectionModel().getSelectedIndex());
        printWriterIn.println("  chamber volume     " + this.separator + NewExperimentSchedulerBoxController.readValue(this.volumeField));
        printWriterIn.println("  heater mode        " + this.separator + this.heatersModeCombo.getSelectionModel().getSelectedIndex());
        printWriterIn.println("  heater temperature " + this.separator + NewExperimentSchedulerBoxController.readValue(this.heatersTemperatureField));
        printWriterIn.println("  heater rate        " + this.separator + NewExperimentSchedulerBoxController.readValue(this.heatersRateField));
        printWriterIn.println("  pressure mode      " + this.separator + this.pressureModeCombo.getSelectionModel().getSelectedIndex());
        printWriterIn.println("  pressure           " + this.separator + NewExperimentSchedulerBoxController.readValue(this.pressureField));
    }

    public void readScheduler(BufferedReader readerIn, int format) {
        try {
            if (format == 0) {
                this.schedulerNameField.setText(readerIn.readLine().split(this.separator)[1]);
                this.schedulerTimeField.setText(readerIn.readLine().split(this.separator)[1]);
                this.addPistonSchedulerTickBox.setSelected(Boolean.parseBoolean(readerIn.readLine().split(this.separator)[1]));
                this.addTemperatureSchedulerTickBox.setSelected(Boolean.parseBoolean(readerIn.readLine().split(this.separator)[1]));
                this.addPressureSchedulerTickBox.setSelected(Boolean.parseBoolean(readerIn.readLine().split(this.separator)[1]));
                this.reportHeatTickBox.setSelected(Boolean.parseBoolean(readerIn.readLine().split(this.separator)[1]));
                this.reportWorkTickBox.setSelected(Boolean.parseBoolean(readerIn.readLine().split(this.separator)[1]));
                this.pistonModeCombo.getSelectionModel().select((int)Double.parseDouble(readerIn.readLine().split(this.separator)[1]));
                this.volumeField.setText(readerIn.readLine().split(this.separator)[1]);
                this.heatersModeCombo.getSelectionModel().select((int)Double.parseDouble(readerIn.readLine().split(this.separator)[1]));
                this.heatersTemperatureField.setText(readerIn.readLine().split(this.separator)[1]);
                this.heatersRateField.setText(readerIn.readLine().split(this.separator)[1]);
                this.pressureModeCombo.getSelectionModel().select((int)Double.parseDouble(readerIn.readLine().split(this.separator)[1]));
                this.pressureField.setText(readerIn.readLine().split(this.separator)[1]);
            } else if (format == 1) {
                this.schedulerNameField.setText(readerIn.readLine());
                this.schedulerTimeField.setText(readerIn.readLine());
                this.addPistonSchedulerTickBox.setSelected(Boolean.parseBoolean(readerIn.readLine()));
                this.addTemperatureSchedulerTickBox.setSelected(Boolean.parseBoolean(readerIn.readLine()));
                this.addPressureSchedulerTickBox.setSelected(Boolean.parseBoolean(readerIn.readLine()));
                this.reportHeatTickBox.setSelected(Boolean.parseBoolean(readerIn.readLine()));
                this.reportWorkTickBox.setSelected(Boolean.parseBoolean(readerIn.readLine()));
                this.pistonModeCombo.getSelectionModel().select((int)Double.parseDouble(readerIn.readLine()));
                this.volumeField.setText(readerIn.readLine());
                this.heatersModeCombo.getSelectionModel().select((int)Double.parseDouble(readerIn.readLine()));
                this.heatersTemperatureField.setText(readerIn.readLine());
                this.heatersRateField.setText(readerIn.readLine());
                this.pressureModeCombo.getSelectionModel().select((int)Double.parseDouble(readerIn.readLine()));
                this.pressureField.setText(readerIn.readLine());
            }
            this.pressureCheckbox();
            this.pistonCheckbox();
            this.heaterCheckbox();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.pistonPane.setVisible(false);
        this.pistonPane.setExpanded(false);
        this.heatersPane.setVisible(false);
        this.heatersPane.setExpanded(false);
        this.pressurePane.setVisible(false);
        this.pressurePane.setExpanded(false);
        UtilsUI.attachNumericalValidator(this.schedulerTimeField, 0.1, 10.0, 1, true, true);
        UtilsUI.attachNumericalValidator(this.volumeField, 0.001, 1000000.0, 1, true, true);
        UtilsUI.attachNumericalValidator(this.heatersRateField, 1.0E-6, 1000000.0, 1, true, true);
        UtilsUI.attachNumericalValidator(this.heatersTemperatureField, 1.0E-6, 1000.0, 1, true, true);
        UtilsUI.attachNumericalValidator(this.pressureField, 3000.0, 20000.0, 1, true, true);
    }

    private static Double readValue(TextField textFieldIn) {
        return Double.parseDouble(textFieldIn.getText());
    }

    public void pistonCheckbox() {
        this.pistonPane.setVisible(this.addPistonSchedulerTickBox.isSelected());
        this.pistonPane.setExpanded(this.addPistonSchedulerTickBox.isSelected());
        this.pistonModeCombo.setVisible(this.addPistonSchedulerTickBox.isSelected());
        this.pistonModeLabel.setVisible(this.addPistonSchedulerTickBox.isSelected());
        this.selectPistonMode();
    }

    public void selectPistonMode() {
        int pistonMode = this.pistonModeCombo.getSelectionModel().getSelectedIndex();
        if (pistonMode == 0 || pistonMode == 2) {
            this.volumeBox.setVisible(false);
        }
        if (pistonMode == 1) {
            this.volumeBox.setVisible(true);
        }
    }

    public void heaterCheckbox() {
        this.heatersPane.setVisible(this.addTemperatureSchedulerTickBox.isSelected());
        this.heatersPane.setExpanded(this.addTemperatureSchedulerTickBox.isSelected());
        this.heatersModeCombo.setVisible(this.addTemperatureSchedulerTickBox.isSelected());
        this.selectHeatersMode(null);
    }

    public void selectHeatersMode(ActionEvent actionEvent) {
        int heaterMode = this.heatersModeCombo.getSelectionModel().getSelectedIndex();
        if (heaterMode == 0) {
            this.heatersTemperatureBox.setVisible(false);
            this.heatersRateBox.setVisible(false);
        }
        if (heaterMode == 1) {
            this.heatersTemperatureBox.setVisible(true);
            this.heatersRateBox.setVisible(true);
        }
    }

    public void pressureCheckbox() {
        this.pressurePane.setVisible(this.addPressureSchedulerTickBox.isSelected());
        this.pressurePane.setExpanded(this.addPressureSchedulerTickBox.isSelected());
    }
}

