/*
 * Decompiled with CFR 0.152.
 */
package multimedia.aviwriter;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import multimedia.aviwriter.AVIMAINHEADER;
import multimedia.aviwriter.AVIOLDINDEX;
import multimedia.aviwriter.AVISTREAMHEADER;
import multimedia.aviwriter.AVIstruct;
import multimedia.aviwriter.BITMAPINFOHEADER;
import multimedia.aviwriter.WAVEFORMATEX;

public class AviWriter {
    private static final boolean CAN_ENCODE_JPEG;
    private int m_iWidth = -1;
    private int m_iHeight = -1;
    private int m_iFrames = -1;
    private int m_iPerSecond = -1;
    private int m_iFrameByteSize = -1;
    private int m_iFrameCount = 0;
    private int m_iChannels;
    private final int m_iBytesPerSample = 2;
    private int m_iSamplesPerSecond = -1;
    private double m_dblSampleCount = 0.0;
    private final ImageWriter m_oImgWriter;
    private final ImageWriteParam m_oWriteParams;
    private final boolean m_blnMJPG;
    private RandomAccessFile raFile;
    private Chunk RIFF_chunk;
    private Chunk LIST_hdr1;
    private AVIMAINHEADER avih;
    private Chunk LIST_strl_vid;
    private Chunk strf_vid;
    private AVISTREAMHEADER strh_vid;
    private BITMAPINFOHEADER bif;
    private Chunk LIST_strl_aud;
    private Chunk strf_aud;
    private AVISTREAMHEADER strh_aud;
    private WAVEFORMATEX wavfmt;
    private Chunk LIST_movi;
    private AVIOLDINDEX avioldidx;
    private ArrayList<AVIOLDINDEX.AVIOLDINDEXENTRY> indexList;

    public void setSamplesPerSecond(int i) {
        if (i < 1) {
            throw new IllegalArgumentException("Samples/Second must be greater than 0");
        }
        this.m_iSamplesPerSecond = i;
    }

    public int getSamplesPerSecond() {
        return this.m_iSamplesPerSecond;
    }

    public void setFramesPerSecond(int i, int j) {
        if (i < 1 || j < 1) {
            throw new IllegalArgumentException("frames/sec must be greater than 0");
        }
        this.m_iFrames = i;
        this.m_iPerSecond = j;
    }

    public int getFramesPerSecNum() {
        return this.m_iFrames;
    }

    public int getFramesperSecDenom() {
        return this.m_iPerSecond;
    }

    public void setDimensions(int i, int j) {
        if (i < 1 || j < 1) {
            throw new IllegalArgumentException("Dimensions must be greater than 0");
        }
        if (this.m_iWidth >= 0) {
            throw new IllegalArgumentException("Width has already been set.");
        }
        this.m_iWidth = i;
        if (this.m_iHeight >= 0) {
            throw new IllegalArgumentException("Height has already been set.");
        }
        this.m_iHeight = j;
    }

    public int getWidth() {
        return this.m_iWidth;
    }

    public int getHeight() {
        return this.m_iHeight;
    }

    public AviWriter(File oOutputfile, int iAudChannels) throws IOException {
        this(oOutputfile, iAudChannels, false);
    }

    public AviWriter(File oOutputfile, int iAudChannels, boolean blnEncodeMjpg) throws IOException {
        Iterator<ImageWriter> oIter;
        if (blnEncodeMjpg) {
            if (!CAN_ENCODE_JPEG) {
                throw new UnsupportedOperationException("Unable to encode 'jpeg' on this platform.");
            }
            oIter = ImageIO.getImageWritersByFormatName("jpeg");
        } else {
            oIter = ImageIO.getImageWritersByFormatName("bmp");
        }
        this.m_oImgWriter = oIter.next();
        this.m_blnMJPG = blnEncodeMjpg;
        this.m_oWriteParams = null;
        this.InitAVIWriter(oOutputfile, iAudChannels);
    }

    public AviWriter(File oOutputfile, int iAudChannels, float fltMjpgQuality) throws IOException {
        if (!CAN_ENCODE_JPEG) {
            throw new UnsupportedOperationException("Unable to encode 'jpeg' on this platform.");
        }
        Iterator<ImageWriter> oIter = ImageIO.getImageWritersByFormatName("jpeg");
        this.m_oImgWriter = oIter.next();
        this.m_oWriteParams = this.m_oImgWriter.getDefaultWriteParam();
        this.m_oWriteParams.setCompressionMode(2);
        this.m_oWriteParams.setCompressionQuality(fltMjpgQuality);
        this.m_blnMJPG = true;
        this.InitAVIWriter(oOutputfile, iAudChannels);
    }

    private void InitAVIWriter(File oOutputfile, int iAudChannels) throws IOException {
        if (iAudChannels < 0 || iAudChannels > 2) {
            throw new IllegalArgumentException("Channels must be 0, 1 or 2");
        }
        this.m_iChannels = iAudChannels;
        this.raFile = new RandomAccessFile(oOutputfile, "rw");
        this.raFile.setLength(0L);
        this.RIFF_chunk = new Chunk(this.raFile, "RIFF", "AVI ");
        this.LIST_hdr1 = new Chunk(this.raFile, "LIST", "hdrl");
        this.avih = new AVIMAINHEADER();
        this.avih.makePlaceholder(this.raFile);
        this.LIST_strl_vid = new Chunk(this.raFile, "LIST", "strl");
        this.strh_vid = new AVISTREAMHEADER();
        this.strh_vid.makePlaceholder(this.raFile);
        this.strf_vid = new Chunk(this.raFile, "strf");
        this.bif = new BITMAPINFOHEADER();
        this.bif.makePlaceholder(this.raFile);
        this.strf_vid.endChunk(this.raFile);
        this.LIST_strl_vid.endChunk(this.raFile);
        if (this.m_iChannels > 0) {
            this.LIST_strl_aud = new Chunk(this.raFile, "LIST", "strl");
            this.strh_aud = new AVISTREAMHEADER();
            this.strh_aud.makePlaceholder(this.raFile);
            this.strf_aud = new Chunk(this.raFile, "strf");
            this.wavfmt = new WAVEFORMATEX();
            this.wavfmt.makePlaceholder(this.raFile);
            this.strf_aud.endChunk(this.raFile);
            this.LIST_strl_aud.endChunk(this.raFile);
        }
        this.LIST_hdr1.endChunk(this.raFile);
        this.LIST_movi = new Chunk(this.raFile, "LIST", "movi");
        this.indexList = new ArrayList();
    }

    public void writeFrame(byte[] abData) throws IOException {
        if (this.raFile == null) {
            throw new IOException("Avi file is closed");
        }
        if (!this.m_blnMJPG) {
            if (this.m_iFrameByteSize < 0) {
                this.m_iFrameByteSize = abData.length;
            } else if (this.m_iFrameByteSize != abData.length) {
                throw new IllegalArgumentException("Frame data size is not consistent");
            }
        }
        this.writeStreamDataChunk(abData, true);
    }

    public void writeFrame(BufferedImage bi) throws IOException {
        if (this.raFile == null) {
            throw new IOException("Avi file is closed");
        }
        if (this.m_iWidth < 0) {
            this.m_iWidth = bi.getWidth();
        } else if (this.m_iWidth != bi.getWidth()) {
            throw new IllegalArgumentException("AviWriter: Frame width is inconsistent (was " + this.m_iWidth + ", now " + bi.getWidth() + ").");
        }
        if (this.m_iHeight < 0) {
            this.m_iHeight = bi.getHeight();
        } else if (this.m_iHeight != bi.getHeight()) {
            throw new IllegalArgumentException("AviWriter: Frame height is inconsistent (was " + this.m_iHeight + ", now " + bi.getHeight() + ").");
        }
        if (this.m_blnMJPG) {
            this.writeFrame(this.Image2MJPEG(bi));
        } else {
            this.writeFrame(this.Image2DIB(bi, this.m_iFrameByteSize));
        }
    }

    public void writeAudio(byte[] abData) throws IOException {
        if (this.raFile == null) {
            throw new IOException("Avi file is closed");
        }
        this.writeStreamDataChunk(abData, false);
    }

    public void writeAudio(AudioInputStream oData) throws IOException {
        int i;
        if (this.raFile == null) {
            throw new IOException("Avi file is closed");
        }
        AudioFormat fmt = oData.getFormat();
        if (fmt.getSampleSizeInBits() != 16) {
            throw new IOException("The bytes per sample don't match.");
        }
        if (this.m_iChannels != fmt.getChannels()) {
            throw new IOException("The number of audio channels don't match.");
        }
        if (this.m_iSamplesPerSecond < 0) {
            this.m_iSamplesPerSecond = (int)fmt.getSampleRate();
        } else if (this.m_iSamplesPerSecond != (int)fmt.getSampleRate()) {
            throw new IOException("The sample rate doesn't match.");
        }
        AVIOLDINDEX.AVIOLDINDEXENTRY idxentry = new AVIOLDINDEX.AVIOLDINDEXENTRY();
        idxentry.dwOffset = (int)(this.raFile.getFilePointer() - (this.LIST_movi.getStart() + 4L));
        idxentry.dwChunkId = AVIstruct.string2int("01wb");
        idxentry.dwFlags = 0;
        Chunk data_size = new Chunk(this.raFile, "01wb");
        byte[] b = new byte[1024];
        while ((i = oData.read(b)) > 0) {
            this.m_dblSampleCount += (double)i / 2.0 / (double)this.m_iChannels;
            this.raFile.write(b, 0, i);
        }
        for (int remaint = (int)(4L - (this.raFile.getFilePointer() - (data_size.getStart() + 4L)) % 4L) % 4; remaint > 0; --remaint) {
            this.raFile.write(0);
        }
        data_size.endChunk(this.raFile);
        idxentry.dwSize = (int)data_size.getSize();
        this.indexList.add(idxentry);
    }

    private void writeStreamDataChunk(byte[] abData, boolean blnIsVideo) throws IOException {
        Chunk data_size;
        AVIOLDINDEX.AVIOLDINDEXENTRY idxentry = new AVIOLDINDEX.AVIOLDINDEXENTRY();
        idxentry.dwOffset = (int)(this.raFile.getFilePointer() - (this.LIST_movi.getStart() + 4L));
        if (blnIsVideo) {
            String sChunkId = this.m_blnMJPG ? "00dc" : "00db";
            idxentry.dwChunkId = AVIstruct.string2int(sChunkId);
            idxentry.dwFlags = AVIOLDINDEX.AVIIF_KEYFRAME;
            ++this.m_iFrameCount;
            data_size = new Chunk(this.raFile, sChunkId);
        } else {
            if (abData.length % 2 != 0 || abData.length % this.m_iChannels != 0) {
                throw new IllegalArgumentException("Half an audio sample can't be processed.");
            }
            idxentry.dwChunkId = AVIstruct.string2int("01wb");
            idxentry.dwFlags = 0;
            this.m_dblSampleCount += (double)abData.length / 2.0 / (double)this.m_iChannels;
            data_size = new Chunk(this.raFile, "01wb");
        }
        this.raFile.write(abData);
        for (int remaint = (4 - abData.length % 4) % 4; remaint > 0; --remaint) {
            this.raFile.write(0);
        }
        data_size.endChunk(this.raFile);
        idxentry.dwSize = (int)data_size.getSize();
        this.indexList.add(idxentry);
    }

    public void close() throws IOException {
        if (this.raFile == null) {
            throw new IOException("Avi file is closed");
        }
        if (this.m_iFrames < 1 || this.m_iPerSecond < 1) {
            throw new IllegalStateException("Must set frames/second before closing avi");
        }
        if (this.m_iChannels > 0 && this.m_iSamplesPerSecond < 1) {
            throw new IllegalStateException("Must set samples/second before closing avi");
        }
        if (this.m_iWidth < 0 || this.m_iHeight < 0) {
            throw new IllegalStateException("Must set dimentions before closing avi");
        }
        this.LIST_movi.endChunk(this.raFile);
        this.avioldidx = new AVIOLDINDEX(this.indexList.toArray(new AVIOLDINDEX.AVIOLDINDEXENTRY[0]));
        this.avioldidx.write(this.raFile);
        this.RIFF_chunk.endChunk(this.raFile);
        this.avih.dwMicroSecPerFrame = (int)((double)this.m_iPerSecond / (double)this.m_iFrames * 1000000.0);
        this.avih.dwMaxBytesPerSec = 0;
        this.avih.dwPaddingGranularity = 0;
        this.avih.dwFlags = 272;
        this.avih.dwTotalFrames = this.m_iFrameCount;
        this.avih.dwInitialFrames = 0;
        this.avih.dwStreams = this.m_iChannels > 0 ? 2 : 1;
        this.avih.dwSuggestedBufferSize = 0;
        this.avih.dwWidth = this.m_iWidth;
        this.avih.dwHeight = this.m_iHeight;
        this.strh_vid.fccType = AVIstruct.string2int("vids");
        this.strh_vid.fccHandler = this.m_blnMJPG ? AVIstruct.string2int("MJPG") : AVIstruct.string2int("DIB ");
        this.strh_vid.dwFlags = 0;
        this.strh_vid.wPriority = 0;
        this.strh_vid.wLanguage = 0;
        this.strh_vid.dwInitialFrames = 0;
        this.strh_vid.dwScale = this.m_iPerSecond;
        this.strh_vid.dwRate = this.m_iFrames;
        this.strh_vid.dwStart = 0;
        this.strh_vid.dwLength = this.m_iFrameCount;
        this.strh_vid.dwSuggestedBufferSize = 0;
        this.strh_vid.dwQuality = -1;
        this.strh_vid.dwSampleSize = 0;
        this.strh_vid.left = 0;
        this.strh_vid.top = 0;
        this.strh_vid.right = (short)this.m_iWidth;
        this.strh_vid.bottom = (short)this.m_iHeight;
        this.bif.biWidth = this.m_iWidth;
        this.bif.biHeight = this.m_iHeight;
        this.bif.biBitCount = (short)24;
        this.bif.biCompression = this.m_blnMJPG ? AVIstruct.string2int("MJPG") : 0;
        this.bif.biSizeImage = 0;
        this.bif.biXPelsPerMeter = 0;
        this.bif.biYPelsPerMeter = 0;
        this.bif.biClrUsed = 0;
        this.bif.biClrImportant = 0;
        if (this.m_iChannels > 0) {
            this.strh_aud.fccType = AVIstruct.string2int("auds");
            this.strh_aud.fccHandler = 0;
            this.strh_aud.dwFlags = 0;
            this.strh_aud.wPriority = 0;
            this.strh_aud.wLanguage = 0;
            this.strh_aud.dwInitialFrames = 1;
            this.strh_aud.dwScale = 1;
            this.strh_aud.dwRate = this.m_iSamplesPerSecond;
            this.strh_aud.dwStart = 0;
            this.strh_aud.dwLength = (int)this.m_dblSampleCount;
            this.strh_aud.dwSuggestedBufferSize = 0;
            this.strh_aud.dwQuality = -1;
            this.strh_aud.dwSampleSize = 2 * this.m_iChannels;
            this.strh_aud.left = 0;
            this.strh_aud.top = 0;
            this.strh_aud.right = 0;
            this.strh_aud.bottom = 0;
            this.wavfmt.wFormatTag = WAVEFORMATEX.WAVE_FORMAT_PCM;
            this.wavfmt.nChannels = (short)this.m_iChannels;
            this.wavfmt.nSamplesPerSec = this.m_iSamplesPerSecond;
            this.wavfmt.nAvgBytesPerSec = 2 * this.m_iSamplesPerSecond * this.m_iChannels;
            this.wavfmt.nBlockAlign = (short)(2 * this.m_iChannels);
            this.wavfmt.wBitsPerSample = (short)16;
        }
        this.avih.goBackAndWrite(this.raFile);
        this.strh_vid.goBackAndWrite(this.raFile);
        this.bif.goBackAndWrite(this.raFile);
        if (this.m_iChannels > 0) {
            this.strh_aud.goBackAndWrite(this.raFile);
            this.wavfmt.goBackAndWrite(this.raFile);
        }
        this.raFile.close();
        this.raFile = null;
        this.RIFF_chunk = null;
        this.LIST_hdr1 = null;
        this.avih = null;
        this.LIST_strl_vid = null;
        this.strf_vid = null;
        this.strh_vid = null;
        this.bif = null;
        this.LIST_strl_aud = null;
        this.strf_aud = null;
        this.strh_aud = null;
        this.wavfmt = null;
        this.LIST_movi = null;
        this.avioldidx = null;
    }

    private static final void writeString(RandomAccessFile raFile, String s) throws IOException {
        byte[] bytes = s.getBytes("UTF8");
        raFile.write(bytes);
    }

    private static final void write32LE(RandomAccessFile raFile, int v) throws IOException {
        raFile.write(v & 0xFF);
        raFile.write(v >>> 8 & 0xFF);
        raFile.write(v >>> 16 & 0xFF);
        raFile.write(v >>> 24 & 0xFF);
    }

    private byte[] Image2DIB(BufferedImage bmp, int iSize) throws IOException {
        ColorModel cm = bmp.getColorModel();
        if (bmp.getType() != 5) {
            BufferedImage buffer = new BufferedImage(bmp.getWidth(), bmp.getHeight(), 5);
            Graphics2D g = buffer.createGraphics();
            g.drawImage((Image)bmp, 0, 0, null);
            g.dispose();
            bmp = buffer;
        }
        byte[] abDIB = iSize <= 32 ? this.WriteImageToBytes(bmp, new ByteArrayOutputStream()) : this.WriteImageToBytes(bmp, new ByteArrayOutputStream(iSize + 54));
        int iDataStart = AviWriter.read32LE(abDIB, 10);
        byte[] abDIBcpy = new byte[abDIB.length - iDataStart];
        System.arraycopy(abDIB, iDataStart, abDIBcpy, 0, abDIBcpy.length);
        return abDIBcpy;
    }

    private static int read32LE(byte[] ab, int iPos) {
        return ab[iPos + 0] | ab[iPos + 1] << 8 | ab[iPos + 2] << 16 | ab[iPos + 3] << 24;
    }

    private byte[] Image2MJPEG(BufferedImage img) throws IOException {
        byte[] abJpg = this.WriteImageToBytes(img, new ByteArrayOutputStream());
        AviWriter.JPEG2MJPEG(abJpg);
        return abJpg;
    }

    private byte[] WriteImageToBytes(BufferedImage img, ByteArrayOutputStream oOut) throws IOException {
        MemoryCacheImageOutputStream oMemOut = new MemoryCacheImageOutputStream(oOut);
        this.m_oImgWriter.setOutput(oMemOut);
        IIOImage oImgIO = new IIOImage(img, null, null);
        this.m_oImgWriter.write(null, oImgIO, this.m_oWriteParams);
        oMemOut.flush();
        oMemOut.close();
        this.m_oImgWriter.setOutput(null);
        return oOut.toByteArray();
    }

    private static void JPEG2MJPEG(byte[] ab) throws IOException {
        if (ab[6] != 74 || ab[7] != 70 || ab[8] != 73 || ab[9] != 70) {
            throw new IOException("JFIF header not found in jpeg data, unable to write frame to AVI.");
        }
    }

    static {
        boolean bln = false;
        for (String s : ImageIO.getReaderFormatNames()) {
            if (!s.equals("jpeg")) continue;
            bln = true;
            break;
        }
        CAN_ENCODE_JPEG = bln;
    }

    private static class Chunk {
        private final long m_lngPos;
        private long m_lngSize = -1L;

        Chunk(RandomAccessFile oRAF, String sChunkName) throws IOException {
            AviWriter.writeString(oRAF, sChunkName);
            this.m_lngPos = oRAF.getFilePointer();
            oRAF.writeInt(0);
        }

        Chunk(RandomAccessFile oRAF, String sChunkName, String sSubChunkName) throws IOException {
            this(oRAF, sChunkName);
            AviWriter.writeString(oRAF, sSubChunkName);
        }

        public void endChunk(RandomAccessFile oRAF) throws IOException {
            long lngCurPos = oRAF.getFilePointer();
            oRAF.seek(this.m_lngPos);
            this.m_lngSize = lngCurPos - (this.m_lngPos + 4L);
            AviWriter.write32LE(oRAF, (int)this.m_lngSize);
            oRAF.seek(lngCurPos);
        }

        private long getSize() {
            return this.m_lngSize;
        }

        private long getStart() {
            return this.m_lngPos;
        }
    }
}

