/*
 * Decompiled with CFR 0.152.
 */
package model.experiment;

import java.util.HashMap;
import model.components.Recorder;
import model.components.advanced.PistonVertical;
import model.components.basic.WallStaticBottomHeater;
import model.components.basic.WallStaticPlane;
import model.components.basic.WallStaticSideHeater;
import model.components.particleEmitters.ParticleEmitterUniformArea;
import model.experiment.Experiment;
import settings.Settings;

public class ExperimentSimplePiston
extends Experiment {
    public static final int x1 = 0;
    public static final int y1 = 1;
    public static final int z1 = 2;
    public static final int x2 = 3;
    public static final int y2 = 4;
    public static final int z2 = 5;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final int left = 0;
    public static final int bottom = 1;
    public static final int front = 2;
    public static final int right = 3;
    public static final int top = 4;
    public static final int back = 5;
    public double leftX = 430.0;
    public double rightX = 1180.0;
    public double topY = 100.0;
    public double bottomY = 850.0;
    public String stage = "Default";
    public int pistonMode = 0;
    public double targetVolume = 1.0;
    public double pistonThickness = 30.0;
    public double pistonMass = 0.2;
    public double pressure = 19954.7;
    public int numberParticles = 50;
    public double numberMoles = 1.0;
    public double tempParticles = 600.0;
    public double particleRadius = 2.0;
    public double particleExchangeRate = 100.0;
    public double atomMassInUnits = 28.0;
    public double tempHeater = 600.0;
    public double heaterParameter = 1000.0;
    double pistonRangeTop;
    double pistonRangeDown;
    double zFront;
    double zBack;
    double atomsPerParticle;
    double width;
    double depth;
    double height;
    double pistonY;
    double atomMass;
    double particleMass;
    double emitterX;
    double emitterY;
    double emitterWidth;
    double emitterHeight;
    WallStaticSideHeater wall1Left;
    WallStaticBottomHeater wall2Bottom;
    WallStaticSideHeater wall4Right;
    Recorder recorder;
    PistonVertical piston;
    public double internalPressure;
    public double internalPressureX;
    public double internalPressureY;
    public double internalPressureZ;
    public static final double[] idealBoltzmanDistribution = new double[1000];

    public ExperimentSimplePiston() {
        double a = Math.sqrt(0.6366197021702048) * Math.pow(this.atomMassInUnits * 1.660539E-27 / (1.380649E-23 * this.tempHeater), 1.5);
        for (int n = 0; n < 1000; ++n) {
            double v2 = 16 * n * n;
            ExperimentSimplePiston.idealBoltzmanDistribution[n] = a * v2 * Math.exp(-(this.atomMassInUnits * 1.660539E-27 * v2) / (2.761298E-23 * this.tempHeater));
        }
    }

    @Override
    public void setup() {
        this.updateSettings();
        this.wall1Left = new WallStaticSideHeater(this.leftX, this.topY, this.bottomY, this.tempHeater, 1);
        this.addComponent(this.wall1Left);
        this.wall1Left.setName("wallLeft");
        this.wall2Bottom = new WallStaticBottomHeater(this.leftX, this.rightX, this.bottomY, this.tempHeater, 0);
        this.addComponent(this.wall2Bottom);
        this.wall2Bottom.setName("wallBottom");
        WallStaticPlane Wall3Front = new WallStaticPlane(this.leftX, this.rightX, this.topY, this.bottomY, this.zFront);
        this.addComponent(Wall3Front);
        Wall3Front.setName("wallFront");
        this.wall4Right = new WallStaticSideHeater(this.rightX, this.bottomY, this.topY, this.tempHeater, 0);
        this.addComponent(this.wall4Right);
        this.wall4Right.setName("wallRight");
        this.piston = new PistonVertical(this.leftX, this.pistonY, this.leftX + this.width, this.pistonY + this.pistonThickness, this.pistonMass, this.pistonRangeTop, this.pistonRangeDown, this.tempHeater);
        this.addComponent(this.piston);
        this.piston.setName("Piston");
        WallStaticPlane Wall5Back = new WallStaticPlane(this.rightX, this.rightX, this.bottomY, this.topY, this.zFront);
        this.addComponent(Wall5Back);
        Wall5Back.setName("wallBack");
        ParticleEmitterUniformArea pe = new ParticleEmitterUniformArea(this.numberParticles, this.emitterX, this.emitterY, this.emitterX + this.emitterWidth, this.emitterY + this.emitterHeight, this.particleRadius, this.atomMass, this.particleMass, this.tempParticles);
        this.addComponent(pe);
        pe.setName("particleEmitter");
        this.recorder = new Recorder();
        this.addComponent(this.recorder);
        this.recorder.setName("Property/Time Plots");
    }

    public void updateSettings() {
        int hMax = 1330;
        int hMin = 430;
        int vMax = 850;
        int vMin = 50;
        this.leftX = (double)hMin + ((double)(hMax - hMin) - Settings.pixelsInAMeter * Settings.chamberWidth) / 2.0;
        this.rightX = this.leftX + Settings.pixelsInAMeter * Settings.chamberWidth;
        this.topY = (double)vMin + ((double)(vMax - vMin) - Settings.pixelsInAMeter * Settings.chamberHeight) / 2.0;
        this.bottomY = this.topY + Settings.pixelsInAMeter * Settings.chamberHeight;
        this.pistonThickness = Math.max(2.0, 0.05 * Settings.pixelsInAMeter);
        this.pistonRangeTop = 3.0 * (this.bottomY - this.topY) / 4.0;
        this.pistonRangeDown = 0.5 * (this.bottomY - this.topY) / 4.0;
        this.zFront = Settings.zFront;
        this.zBack = Settings.zBack;
        this.atomsPerParticle = this.numberMoles / (double)this.numberParticles * 6.022141E23;
        this.width = this.rightX - this.leftX;
        this.depth = this.zBack - this.zFront;
        this.height = this.bottomY - this.topY;
        this.pistonY = this.topY + this.pistonRangeTop - this.pistonThickness;
        this.atomMass = this.atomMassInUnits * 1.660539E-27;
        this.particleMass = this.atomMass * this.atomsPerParticle;
        this.emitterX = this.leftX;
        this.emitterY = this.pistonY + this.pistonThickness;
        this.emitterWidth = this.width;
        this.emitterHeight = this.bottomY - this.emitterY;
    }

    public double[] getLegalAreaSimpleExperiment() {
        double[] pistonPos = this.getComponentById(4).getPosition();
        return new double[]{this.leftX, pistonPos[4], this.zFront, this.rightX, this.bottomY, this.zBack};
    }

    public double getVolumeTotalSI() {
        double[] shape = this.getLegalAreaSimpleExperiment();
        return (shape[3] - shape[0]) * (shape[4] - shape[1]) * (shape[5] - shape[2]) / Settings.pixelsInAMeter3;
    }

    public double getXAreaSI() {
        double[] shape = this.getLegalAreaSimpleExperiment();
        return 2.0 * (shape[5] - shape[2]) * (shape[4] - shape[1]) / Settings.pixelsInAMeter2;
    }

    public double getYAreaSI() {
        double[] shape = this.getLegalAreaSimpleExperiment();
        return 2.0 * (shape[5] - shape[2]) * (shape[3] - shape[0]) / Settings.pixelsInAMeter2;
    }

    public double getZAreaSI() {
        double[] shape = this.getLegalAreaSimpleExperiment();
        return 2.0 * (shape[3] - shape[0]) * (shape[4] - shape[1]) / Settings.pixelsInAMeter2;
    }

    public double getAreaTotalSI() {
        return this.getXAreaSI() + this.getYAreaSI() + this.getZAreaSI();
    }

    public HashMap<String, Double> getDisplayStatistics() {
        HashMap<String, Double> stats = this.recorder.getState();
        for (String key : stats.keySet()) {
            stats.replace(key, (double)Math.round(stats.get(key) * 1000.0) / 1000.0);
        }
        return stats;
    }

    public HashMap<String, double[]> getDistributions() {
        int n;
        HashMap<String, double[]> distr = new HashMap<String, double[]>();
        int maxSpeed = 2000;
        int numberOfBins = maxSpeed / 4;
        double[] distribution = new double[numberOfBins];
        for (n = 0; n < this.getNumOfParticles(); ++n) {
            int index = (int)(this.getParticleById(n).getSpeed() / 4.0);
            if (index >= distribution.length) continue;
            int n2 = index;
            distribution[n2] = distribution[n2] + 0.25;
        }
        for (n = 0; n < numberOfBins; ++n) {
            distribution[n] = distribution[n] / (double)this.getNumOfParticles();
        }
        distr.put("Experimental Maxwell Boltzmann Distribution", distribution);
        distr.put("Ideal Maxwell Boltzmann Distribution", idealBoltzmanDistribution);
        return distr;
    }

    public Recorder getRecorder() {
        return this.recorder;
    }

    public void setTempHeater(double tempHeater) {
        this.tempHeater = tempHeater;
        this.wall1Left.temperature = tempHeater;
        this.wall2Bottom.temperature = tempHeater;
        this.wall4Right.temperature = tempHeater;
        this.piston.temperature = tempHeater;
    }
}

